/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.domain.subscription.managed;

import de.justsoftware.news.ChannelId;
import de.justsoftware.news.ItemId;
import de.justsoftware.news.ManagedSubscriptionId;
import de.justsoftware.news.UserId;
import de.justsoftware.news.auth.AuthorizationContext;
import de.justsoftware.news.domain.channel.Channel;
import de.justsoftware.news.domain.channel.ChannelRepo;
import de.justsoftware.news.domain.subscription.SubscriptionRepoWrapper;
import de.justsoftware.news.domain.subscription.managed.ManagedSubscription;
import de.justsoftware.news.domain.subscription.managed.ManagedSubscriptionAdd;
import de.justsoftware.news.domain.subscription.managed.ManagedSubscriptionChanges;
import de.justsoftware.news.domain.subscription.managed.ManagedSubscriptionRepo;
import de.justsoftware.news.domain.subscription.managed.ManagedSubscriptionService;
import de.justsoftware.news.domain.subscription.managed.ManagedSubscriptionType;
import de.justsoftware.news.domain.subscription.managed.ManagedSubscriptionUpdate;
import de.justsoftware.news.events.GroupDeletedEvent;
import de.justsoftware.news.events.ProfileDeletedEvent;
import de.justsoftware.news.util.Unauthorized;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 !2\u00020\u0001:\u0001!B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0012J\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0012H\u0017J\u0018\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0017J*\u0010\u0018\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u00190\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00150\u00192\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u001b\u001a\u00020\u001cH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lde/justsoftware/news/domain/subscription/managed/ManagedSubscriptionService;", "", "channelRepo", "Lde/justsoftware/news/domain/channel/ChannelRepo;", "managedSubscriptionRepo", "Lde/justsoftware/news/domain/subscription/managed/ManagedSubscriptionRepo;", "subscriptionRepoWrapper", "Lde/justsoftware/news/domain/subscription/SubscriptionRepoWrapper;", "(Lde/justsoftware/news/domain/channel/ChannelRepo;Lde/justsoftware/news/domain/subscription/managed/ManagedSubscriptionRepo;Lde/justsoftware/news/domain/subscription/SubscriptionRepoWrapper;)V", "createChannelSubscriptions", "", "origin", "Lde/justsoftware/news/domain/subscription/managed/ManagedSubscription;", "newType", "Lde/justsoftware/news/domain/subscription/managed/ManagedSubscriptionType;", "deleteManagedSubscriptions", "event", "Lde/justsoftware/news/events/GroupDeletedEvent;", "Lde/justsoftware/news/events/ProfileDeletedEvent;", "getByChannelIdAndUserId", "channelId", "Lde/justsoftware/news/ChannelId;", "userId", "Lde/justsoftware/news/UserId;", "getForChannelIds", "", "channelIds", "authContext", "Lde/justsoftware/news/auth/AuthorizationContext;", "set", "Lde/justsoftware/news/domain/channel/Channel;", "changes", "Lde/justsoftware/news/domain/subscription/managed/ManagedSubscriptionChanges;", "Companion", "news-service"})
public class ManagedSubscriptionService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ChannelRepo channelRepo;
    @NotNull
    private final ManagedSubscriptionRepo managedSubscriptionRepo;
    @NotNull
    private final SubscriptionRepoWrapper subscriptionRepoWrapper;
    private static final Logger log = LoggerFactory.getLogger(ManagedSubscriptionService.class);

    public ManagedSubscriptionService(@NotNull ChannelRepo channelRepo, @NotNull ManagedSubscriptionRepo managedSubscriptionRepo, @NotNull SubscriptionRepoWrapper subscriptionRepoWrapper) {
        Intrinsics.checkNotNullParameter((Object)channelRepo, (String)"channelRepo");
        Intrinsics.checkNotNullParameter((Object)managedSubscriptionRepo, (String)"managedSubscriptionRepo");
        Intrinsics.checkNotNullParameter((Object)subscriptionRepoWrapper, (String)"subscriptionRepoWrapper");
        this.channelRepo = channelRepo;
        this.managedSubscriptionRepo = managedSubscriptionRepo;
        this.subscriptionRepoWrapper = subscriptionRepoWrapper;
    }

    @Unauthorized
    @NotNull
    public ManagedSubscription getByChannelIdAndUserId(@NotNull ChannelId channelId, @NotNull UserId userId) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        return (ManagedSubscription)CollectionsKt.first((Iterable)this.managedSubscriptionRepo.getByChannelIdAndUserId(channelId, userId));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<List<ManagedSubscription>> getForChannelIds(@NotNull List<ChannelId> channelIds, @NotNull AuthorizationContext authContext) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(channelIds, (String)"channelIds");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        if (!authContext.mayManageAll((Collection)channelIds)) {
            Collection<String> collection;
            void $this$mapTo$iv$iv2;
            void $this$map$iv;
            Iterable iterable = channelIds;
            String string = authContext.getUser().toTypedString();
            Logger logger = log;
            boolean $i$f$map = false;
            void var5_10 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it;
                ChannelId channelId = (ChannelId)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.toTypedString());
            }
            collection = (List)destination$iv$iv;
            logger.warn("User '" + string + "' may not MANAGE at least one of '" + (List)collection + "'.");
            return CollectionsKt.emptyList();
        }
        Set subscriptions = this.managedSubscriptionRepo.getByChannelIdIn((Collection)channelIds);
        Iterable $this$map$iv = channelIds;
        boolean $i$f$map = false;
        Iterable destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $this$filterTo$iv$iv;
            ChannelId bl = (ChannelId)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl2 = false;
            Iterable $this$filter$iv = subscriptions;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv3 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                void channelId;
                ManagedSubscription it = (ManagedSubscription)element$iv$iv;
                boolean bl3 = false;
                if (!Intrinsics.areEqual((Object)it.getChannelId(), (Object)channelId)) continue;
                destination$iv$iv3.add(element$iv$iv);
            }
            collection.add((List)destination$iv$iv3);
        }
        return (List)destination$iv$iv2;
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    @NotNull
    public Channel set(@NotNull ManagedSubscriptionChanges changes, @NotNull AuthorizationContext authContext) {
        Collection<UserId> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void it;
        void $this$mapTo$iv$iv2;
        Object object;
        ManagedSubscription origin;
        void $this$mapTo$iv$iv3;
        void $this$mapTo$iv$iv4;
        void $this$map$iv2;
        Object element$iv2;
        Intrinsics.checkNotNullParameter((Object)changes, (String)"changes");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        authContext.checkManage((ItemId)changes.getChannelId());
        Iterable $this$forEach$iv = changes.getAdds();
        boolean $i$f$forEach22 = false;
        for (Object element$iv2 : $this$forEach$iv) {
            ManagedSubscriptionAdd it2 = (ManagedSubscriptionAdd)element$iv2;
            boolean bl = false;
            this.managedSubscriptionRepo.insert(ManagedSubscriptionId.Companion.random(), changes.getChannelId(), it2.getType(), it2.getUserId());
        }
        Iterable $i$f$forEach22 = changes.getUpdates();
        Object object2 = this.managedSubscriptionRepo;
        boolean $i$f$map22 = false;
        element$iv2 = $this$map$iv2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv2 : $this$mapTo$iv$iv4) {
            void it3;
            ManagedSubscriptionUpdate managedSubscriptionUpdate = (ManagedSubscriptionUpdate)item$iv$iv2;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(it3.getId());
        }
        Iterable iterable = object2.findAllById((Iterable)((List)destination$iv$iv));
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"managedSubscriptionRepo.\u2026es.updates.map { it.id })");
        Iterable $this$map$iv3 = iterable;
        boolean $i$f$map = false;
        Iterable $i$f$map22 = $this$map$iv3;
        Iterable destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv3) {
            Object v1;
            block8: {
                Object item$iv$iv2;
                item$iv$iv2 = (ManagedSubscription)item$iv$iv;
                object2 = destination$iv$iv2;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)origin.getChannelId(), (Object)changes.getChannelId())) {
                    boolean $i$a$-require-ManagedSubscriptionService$set$3$22 = false;
                    String $i$a$-require-ManagedSubscriptionService$set$3$22 = "Only changes for the same channel are allowed.";
                    throw new IllegalArgumentException($i$a$-require-ManagedSubscriptionService$set$3$22.toString());
                }
                Iterable iterable2 = changes.getUpdates();
                Iterator iterator = iterable2.iterator();
                while (iterator.hasNext()) {
                    object = iterator.next();
                    ManagedSubscriptionUpdate it4 = (ManagedSubscriptionUpdate)object;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it4.getId(), (Object)origin.getId())) continue;
                    v1 = object;
                    break block8;
                }
                v1 = null;
            }
            Intrinsics.checkNotNull(v1);
            ManagedSubscriptionType newType = ((ManagedSubscriptionUpdate)v1).getType();
            Intrinsics.checkNotNullExpressionValue((Object)origin, (String)"origin");
            this.createChannelSubscriptions(origin, newType);
            object2.add(ManagedSubscription.copy$default((ManagedSubscription)origin, null, null, (ManagedSubscriptionType)newType, null, (int)11, null));
        }
        List it5 = (List)destination$iv$iv2;
        boolean $i$a$-let-ManagedSubscriptionService$set$52 = false;
        this.managedSubscriptionRepo.saveAll((Iterable)it5);
        Iterable iterable3 = this.managedSubscriptionRepo.findAllById((Iterable)changes.getDeletes());
        Intrinsics.checkNotNullExpressionValue((Object)iterable3, (String)"managedSubscriptionRepo.\u2026dAllById(changes.deletes)");
        $this$map$iv3 = iterable3;
        $i$f$map = false;
        Iterable $i$a$-let-ManagedSubscriptionService$set$52 = $this$map$iv3;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
        $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            origin = (ManagedSubscription)item$iv$iv;
            object2 = destination$iv$iv2;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getChannelId(), (Object)changes.getChannelId())) {
                boolean $i$a$-require-ManagedSubscriptionService$set$5$22 = false;
                String $i$a$-require-ManagedSubscriptionService$set$5$22 = "Only changes for the same channel are allowed.";
                throw new IllegalArgumentException($i$a$-require-ManagedSubscriptionService$set$5$22.toString());
            }
            object2.add(it);
        }
        List managedSubscriptions = (List)destination$iv$iv2;
        boolean bl = false;
        this.managedSubscriptionRepo.deleteAll((Iterable)managedSubscriptions);
        destination$iv$iv2 = managedSubscriptions;
        ChannelId channelId = changes.getChannelId();
        SubscriptionRepoWrapper subscriptionRepoWrapper = this.subscriptionRepoWrapper;
        boolean $i$f$map3 = false;
        it = $this$map$iv;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo3 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it6;
            object = (ManagedSubscription)item$iv$iv;
            collection = destination$iv$iv3;
            boolean bl3 = false;
            collection.add(it6.getUserId());
        }
        collection = (List)destination$iv$iv3;
        subscriptionRepoWrapper.cleanUpPersonalSubscriptions(channelId, (Collection)collection);
        return this.channelRepo.getByIdAndDeletedFalse(changes.getChannelId());
    }

    @EventListener
    public void deleteManagedSubscriptions(@NotNull ProfileDeletedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.managedSubscriptionRepo.deleteByUserId((UserId)event.getProfileId());
    }

    @EventListener
    public void deleteManagedSubscriptions(@NotNull GroupDeletedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.managedSubscriptionRepo.deleteByUserId((UserId)event.getUserGroupId());
    }

    private void createChannelSubscriptions(ManagedSubscription origin, ManagedSubscriptionType newType) {
        if (origin.getType() == newType || newType != ManagedSubscriptionType.NO_RECOMMENDATION) {
            return;
        }
        SubscriptionRepoWrapper.createPersonalSubscriptions$default((SubscriptionRepoWrapper)this.subscriptionRepoWrapper, (ChannelId)origin.getChannelId(), (UserId)origin.getUserId(), (boolean)false, (int)4, null);
    }
}

