/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.domain.subscription;

import de.justsoftware.news.ChannelId;
import de.justsoftware.news.PersonalSubscriptionId;
import de.justsoftware.news.ProfileId;
import de.justsoftware.news.UserGroupId;
import de.justsoftware.news.UserGroupMemberId;
import de.justsoftware.news.UserId;
import de.justsoftware.news.connector.permission.PermissionConnector;
import de.justsoftware.news.domain.subscription.ChannelSubscription;
import de.justsoftware.news.domain.subscription.SubscriptionRepoWrapper;
import de.justsoftware.news.domain.subscription.managed.ManagedSubscription;
import de.justsoftware.news.domain.subscription.managed.ManagedSubscriptionRepo;
import de.justsoftware.news.domain.subscription.managed.ManagedSubscriptionType;
import de.justsoftware.news.domain.subscription.personal.PersonalSubscription;
import de.justsoftware.news.domain.subscription.personal.PersonalSubscriptionRepo;
import de.justsoftware.news.domain.user.UserGroupMember;
import de.justsoftware.news.domain.user.UserGroupMemberRepo;
import de.justsoftware.news.events.GroupMembersDeletedEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\b\u0017\u0018\u0000 ,2\u00020\u0001:\u0001,B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u001e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0017J\"\u0010\u0014\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u00112\b\b\u0002\u0010\u0016\u001a\u00020\u0017H\u0016J2\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u0010H\u0012J\u001a\u0010 \u001a\u0004\u0018\u00010\u00192\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J&\u0010!\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00190\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u000e0\"2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0016\u0010$\u001a\b\u0012\u0004\u0012\u00020\u000e0\"2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0018\u0010%\u001a\u00020\u00192\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0016\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00190\"2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\"\u0010&\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\"0\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u000e0\"H\u0016J,\u0010'\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020)0\u00102\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u001f0+H\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lde/justsoftware/news/domain/subscription/SubscriptionRepoWrapper;", "", "managedSubscriptionRepo", "Lde/justsoftware/news/domain/subscription/managed/ManagedSubscriptionRepo;", "permissionConnector", "Lde/justsoftware/news/connector/permission/PermissionConnector;", "personalSubscriptionRepo", "Lde/justsoftware/news/domain/subscription/personal/PersonalSubscriptionRepo;", "userGroupMemberRepo", "Lde/justsoftware/news/domain/user/UserGroupMemberRepo;", "(Lde/justsoftware/news/domain/subscription/managed/ManagedSubscriptionRepo;Lde/justsoftware/news/connector/permission/PermissionConnector;Lde/justsoftware/news/domain/subscription/personal/PersonalSubscriptionRepo;Lde/justsoftware/news/domain/user/UserGroupMemberRepo;)V", "cleanUpPersonalSubscriptions", "", "channelId", "Lde/justsoftware/news/ChannelId;", "userIds", "", "Lde/justsoftware/news/UserId;", "event", "Lde/justsoftware/news/events/GroupMembersDeletedEvent;", "createPersonalSubscriptions", "userId", "notificationsEnabled", "", "deriveSubscription", "Lde/justsoftware/news/domain/subscription/ChannelSubscription;", "profileId", "Lde/justsoftware/news/ProfileId;", "personalSubscription", "Lde/justsoftware/news/domain/subscription/personal/PersonalSubscription;", "managedSubscriptions", "Lde/justsoftware/news/domain/subscription/managed/ManagedSubscription;", "findSubscription", "findSubscriptions", "", "channelIds", "getSubscribedChannelIds", "getSubscription", "getSubscriptions", "profileHasOtherManagedSubs", "groupsOfProfile", "Lde/justsoftware/news/UserGroupId;", "managedSubsOfChannel", "", "Companion", "news-service"})
public class SubscriptionRepoWrapper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ManagedSubscriptionRepo managedSubscriptionRepo;
    @NotNull
    private final PermissionConnector permissionConnector;
    @NotNull
    private final PersonalSubscriptionRepo personalSubscriptionRepo;
    @NotNull
    private final UserGroupMemberRepo userGroupMemberRepo;
    private static final Logger log = LoggerFactory.getLogger(SubscriptionRepoWrapper.class);

    public SubscriptionRepoWrapper(@NotNull ManagedSubscriptionRepo managedSubscriptionRepo, @NotNull PermissionConnector permissionConnector, @NotNull PersonalSubscriptionRepo personalSubscriptionRepo, @NotNull UserGroupMemberRepo userGroupMemberRepo) {
        Intrinsics.checkNotNullParameter((Object)managedSubscriptionRepo, (String)"managedSubscriptionRepo");
        Intrinsics.checkNotNullParameter((Object)permissionConnector, (String)"permissionConnector");
        Intrinsics.checkNotNullParameter((Object)personalSubscriptionRepo, (String)"personalSubscriptionRepo");
        Intrinsics.checkNotNullParameter((Object)userGroupMemberRepo, (String)"userGroupMemberRepo");
        this.managedSubscriptionRepo = managedSubscriptionRepo;
        this.permissionConnector = permissionConnector;
        this.personalSubscriptionRepo = personalSubscriptionRepo;
        this.userGroupMemberRepo = userGroupMemberRepo;
    }

    /*
     * WARNING - void declaration
     */
    @EventListener
    public void cleanUpPersonalSubscriptions(@NotNull GroupMembersDeletedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Iterable $this$forEach$iv = event.getUserGroupMemberIds();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            void $this$filterTo$iv$iv2;
            void $this$filter$iv2;
            void $this$mapTo$iv$iv2;
            Map $this$map$iv2;
            UserGroupMemberId it = (UserGroupMemberId)element$iv;
            boolean bl = false;
            List subscriptions = this.personalSubscriptionRepo.getByProfileId(it.getProfileId());
            Iterable iterable = subscriptions;
            Object object = this.permissionConnector;
            boolean $i$f$map = false;
            void var12_14 = $this$map$iv2;
            Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)((Object)$this$map$iv2), (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void subscription;
                PersonalSubscription personalSubscription = (PersonalSubscription)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(subscription.getChannelId());
            }
            $this$map$iv2 = object.mayRead((Collection)((List)destination$iv$iv), (UserId)it.getProfileId());
            boolean $i$f$filter22 = false;
            $this$mapTo$iv$iv2 = $this$filter$iv2;
            destination$iv$iv = new LinkedHashMap();
            boolean $i$f$filterTo = false;
            Iterator<Object> iterator = $this$filterTo$iv$iv2.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv$iv;
                Map.Entry mayRead = element$iv$iv = (Map.Entry)iterator.next();
                boolean bl3 = false;
                if (!((Boolean)mayRead.getValue() == false)) continue;
                destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            Object channelIdsWithoutAccess = destination$iv$iv;
            Iterable $i$f$filter22 = subscriptions;
            boolean $i$f$filter = false;
            destination$iv$iv = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                PersonalSubscription subscription = (PersonalSubscription)element$iv$iv;
                boolean bl4 = false;
                if (!channelIdsWithoutAccess.containsKey(subscription.getChannelId())) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv2;
            boolean $i$f$map2 = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                PersonalSubscription subscription = (PersonalSubscription)item$iv$iv;
                object = destination$iv$iv2;
                boolean bl5 = false;
                object.add(p0.getId());
            }
            List subscriptionsToDelete = (List)destination$iv$iv2;
            this.personalSubscriptionRepo.deleteAllById((Iterable)subscriptionsToDelete);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void cleanUpPersonalSubscriptions(@NotNull ChannelId channelId, @NotNull Collection<? extends UserId> userIds) {
        Collection<String> collection;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Collection collection2;
        void $this$mapTo$iv$iv;
        void $this$filterIsInstanceTo$iv$iv;
        void $this$filterTo$iv$iv2;
        void $this$filter$iv2;
        Iterable $this$filterIsInstanceTo$iv$iv2;
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter(userIds, (String)"userIds");
        if (userIds.isEmpty()) {
            return;
        }
        Set managedSubsOfChannel = this.managedSubscriptionRepo.getByChannelId(channelId);
        Iterable $this$filterIsInstance$iv = userIds;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo22 = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv2) {
            if (!(element$iv$iv instanceof ProfileId)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List profileIds = (List)destination$iv$iv;
        Set userGroupMembersForProfiles = this.userGroupMemberRepo.getByProfileIdIn((Collection)profileIds);
        $this$filterIsInstanceTo$iv$iv2 = profileIds;
        boolean $i$f$filter = false;
        void $i$f$filterIsInstanceTo22 = $this$filter$iv2;
        Iterable<Object> destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            void $this$mapTo$iv$iv2;
            void $this$map$iv;
            UserGroupMember it;
            void $this$filterTo$iv$iv3;
            ProfileId profileId = (ProfileId)element$iv$iv;
            boolean bl = false;
            Iterable $this$filter$iv3 = userGroupMembersForProfiles;
            boolean $i$f$filter2 = false;
            Iterable iterable2 = $this$filter$iv3;
            Collection destination$iv$iv3 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv2 : $this$filterTo$iv$iv3) {
                it = (UserGroupMember)element$iv$iv2;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)it.getProfileId(), (Object)profileId)) continue;
                destination$iv$iv3.add(element$iv$iv2);
            }
            $this$filter$iv3 = (List)destination$iv$iv3;
            boolean $i$f$map2 = false;
            $this$filterTo$iv$iv3 = $this$map$iv;
            destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                it = (UserGroupMember)item$iv$iv;
                Collection collection3 = destination$iv$iv3;
                boolean bl3 = false;
                collection3.add(it.getUserGroupId());
            }
            List groupsOfProfile = (List)destination$iv$iv3;
            if (!(!this.profileHasOtherManagedSubs(profileId, (Collection)groupsOfProfile, managedSubsOfChannel))) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List profileIdsToDelete = (List)destination$iv$iv2;
        Iterable $this$filterIsInstance$iv2 = userIds;
        boolean $i$f$filterIsInstance2 = false;
        destination$iv$iv2 = $this$filterIsInstance$iv2;
        Collection destination$iv$iv4 = new ArrayList();
        boolean $i$f$filterIsInstanceTo32 = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof UserGroupId)) continue;
            destination$iv$iv4.add(element$iv$iv);
        }
        List groupIds = (List)destination$iv$iv4;
        Set userGroupMembersForGroups = this.userGroupMemberRepo.getByUserGroupIdIn((Collection)groupIds);
        Iterable $this$map$iv = userGroupMembersForGroups;
        boolean $i$f$map = false;
        Iterable $i$f$filterIsInstanceTo32 = $this$map$iv;
        Collection destination$iv$iv5 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            UserGroupMember $i$f$map2 = (UserGroupMember)item$iv$iv;
            collection2 = destination$iv$iv5;
            boolean bl = false;
            collection2.add(it.getProfileId());
        }
        $this$map$iv = CollectionsKt.distinct((Iterable)((List)destination$iv$iv5));
        boolean $i$f$filter3 = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv5 = new ArrayList();
        boolean $i$f$filterTo3 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            void $this$mapTo$iv$iv3;
            void $this$map$iv2;
            UserGroupMember it;
            void $this$filterTo$iv$iv4;
            ProfileId profileId = (ProfileId)element$iv$iv;
            boolean bl = false;
            Iterable $this$filter$iv4 = userGroupMembersForGroups;
            boolean $i$f$filter4 = false;
            Iterable iterable3 = $this$filter$iv4;
            Collection destination$iv$iv6 = new ArrayList();
            boolean $i$f$filterTo4 = false;
            for (Object element$iv$iv3 : $this$filterTo$iv$iv4) {
                it = (UserGroupMember)element$iv$iv3;
                boolean bl4 = false;
                if (!Intrinsics.areEqual((Object)it.getProfileId(), (Object)profileId)) continue;
                destination$iv$iv6.add(element$iv$iv3);
            }
            $this$filter$iv4 = (List)destination$iv$iv6;
            boolean $i$f$map3 = false;
            $this$filterTo$iv$iv4 = $this$map$iv2;
            destination$iv$iv6 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv3) {
                it = (UserGroupMember)item$iv$iv;
                Collection collection4 = destination$iv$iv6;
                boolean bl5 = false;
                collection4.add(it.getUserGroupId());
            }
            List groupsOfProfile = (List)destination$iv$iv6;
            if (!(!this.profileHasOtherManagedSubs(profileId, (Collection)groupsOfProfile, managedSubsOfChannel))) continue;
            destination$iv$iv5.add(element$iv$iv);
        }
        List profileIdsFromGroupsToDelete = (List)destination$iv$iv5;
        $this$filter$iv = CollectionsKt.plus((Collection)profileIdsToDelete, (Iterable)profileIdsFromGroupsToDelete);
        ChannelId channelId2 = channelId;
        collection2 = this.personalSubscriptionRepo;
        $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv5 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ProfileId profileId = (ProfileId)item$iv$iv;
            collection = destination$iv$iv5;
            boolean bl = false;
            collection.add(it.toTypedString());
        }
        collection = (List)destination$iv$iv5;
        collection2.deleteByChannelIdAndProfileIdIn(channelId2, CollectionsKt.toSet((Iterable)collection));
    }

    /*
     * WARNING - void declaration
     */
    public void createPersonalSubscriptions(@NotNull ChannelId channelId, @NotNull UserId userId, boolean notificationsEnabled) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        UserId userId2 = userId;
        if (userId2 instanceof ProfileId) {
            PersonalSubscription personalSubscription = this.personalSubscriptionRepo.findByChannelIdAndProfileId(channelId, (ProfileId)userId);
            if (personalSubscription == null) {
                PersonalSubscriptionRepo.insert$default((PersonalSubscriptionRepo)this.personalSubscriptionRepo, (PersonalSubscriptionId)PersonalSubscriptionId.Companion.random(), (ChannelId)channelId, (ProfileId)((ProfileId)userId), (boolean)notificationsEnabled, (boolean)false, (int)16, null);
                personalSubscription = Unit.INSTANCE;
            }
        } else if (userId2 instanceof UserGroupId) {
            Object object;
            void $this$mapTo$iv$iv;
            log.info("Start creating personal subscriptions for all members of UserGroup: '" + userId + "'.");
            Iterable $this$map$iv = this.userGroupMemberRepo.getByUserGroupId((UserGroupId)userId);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                object = (UserGroupMember)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getProfileId());
            }
            List profileIdsOfGroup = (List)destination$iv$iv;
            Set channelSubscriptionsOfGroup = this.personalSubscriptionRepo.getByChannelIdAndProfileIdIn(channelId, profileIdsOfGroup);
            Iterable $this$forEach$iv = profileIdsOfGroup;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PersonalSubscription personalSubscription;
                Object v1;
                ProfileId profileId;
                block7: {
                    profileId = (ProfileId)element$iv;
                    boolean bl = false;
                    object = channelSubscriptionsOfGroup;
                    Iterator iterator = object.iterator();
                    while (iterator.hasNext()) {
                        Object t = iterator.next();
                        PersonalSubscription it = (PersonalSubscription)t;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)it.getProfileId(), (Object)profileId)) continue;
                        v1 = t;
                        break block7;
                    }
                    v1 = null;
                }
                if ((personalSubscription = (PersonalSubscription)v1) != null) continue;
                PersonalSubscriptionRepo.insert$default((PersonalSubscriptionRepo)this.personalSubscriptionRepo, (PersonalSubscriptionId)PersonalSubscriptionId.Companion.random(), (ChannelId)channelId, (ProfileId)profileId, (boolean)notificationsEnabled, (boolean)false, (int)16, null);
                personalSubscription = Unit.INSTANCE;
            }
            log.info("Finished creating personal subscriptions for all members of UserGroup: '" + userId + "'.");
        }
    }

    public static /* synthetic */ void createPersonalSubscriptions$default(SubscriptionRepoWrapper subscriptionRepoWrapper, ChannelId channelId, UserId userId, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: createPersonalSubscriptions");
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        subscriptionRepoWrapper.createPersonalSubscriptions(channelId, userId, bl);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public ChannelSubscription findSubscription(@NotNull ChannelId channelId, @NotNull ProfileId profileId) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        Iterable $this$map$iv = this.userGroupMemberRepo.getByProfileId(profileId);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            UserGroupMember userGroupMember = (UserGroupMember)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getUserGroupId());
        }
        List userGroupIds = (List)destination$iv$iv;
        Set managedSubscriptions = this.managedSubscriptionRepo.getByChannelIdInAndUserIdIn((Collection)SetsKt.setOf((Object)channelId), (Collection)CollectionsKt.plus((Collection)userGroupIds, (Object)profileId));
        PersonalSubscription personalSubscription = this.personalSubscriptionRepo.findByChannelIdAndProfileId(channelId, profileId);
        return this.deriveSubscription(channelId, profileId, personalSubscription, (Collection)managedSubscriptions);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<ChannelSubscription> findSubscriptions(@NotNull List<ChannelId> channelIds, @NotNull ProfileId profileId) {
        void $this$mapTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Intrinsics.checkNotNullParameter(channelIds, (String)"channelIds");
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        Iterable $this$map$iv = this.userGroupMemberRepo.getByProfileId(profileId);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            UserGroupMember userGroupMember = (UserGroupMember)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getUserGroupId());
        }
        List userGroupIds = (List)destination$iv$iv;
        Set managedSubscriptions = this.managedSubscriptionRepo.getByChannelIdInAndUserIdIn((Collection)channelIds, (Collection)CollectionsKt.plus((Collection)userGroupIds, (Object)profileId));
        Set personalSubscriptions = this.personalSubscriptionRepo.getAllByChannelIdInAndProfileId(channelIds, profileId);
        Iterable $this$map$iv2 = channelIds;
        boolean $i$f$map2 = false;
        Iterable $i$f$mapTo22 = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $this$filterTo$iv$iv;
            Object v0;
            void channelId;
            Object object2;
            block4: {
                ChannelId channelId2 = (ChannelId)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl = false;
                Iterable iterable2 = personalSubscriptions;
                for (Object object2 : iterable2) {
                    PersonalSubscription it = (PersonalSubscription)object2;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getChannelId(), (Object)channelId)) continue;
                    v0 = object2;
                    break block4;
                }
                v0 = null;
            }
            PersonalSubscription personalSubscriptionForChannel = v0;
            Iterable $this$filter$iv = managedSubscriptions;
            boolean $i$f$filter = false;
            object2 = $this$filter$iv;
            Collection destination$iv$iv3 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                ManagedSubscription it = (ManagedSubscription)element$iv$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getChannelId(), (Object)channelId)) continue;
                destination$iv$iv3.add(element$iv$iv);
            }
            List managedSubscriptionsForChannel = (List)destination$iv$iv3;
            collection.add(this.deriveSubscription((ChannelId)channelId, profileId, personalSubscriptionForChannel, (Collection)managedSubscriptionsForChannel));
        }
        return (List)destination$iv$iv2;
    }

    @NotNull
    public ChannelSubscription getSubscription(@NotNull ChannelId channelId, @NotNull ProfileId profileId) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        ChannelSubscription channelSubscription = this.findSubscription(channelId, profileId);
        if (channelSubscription == null) {
            throw new NoSuchElementException("ProfileId: '" + profileId + "' has no subscription for ChannelId: '" + channelId + "'.");
        }
        return channelSubscription;
    }

    @NotNull
    public List<ChannelSubscription> getSubscriptions(@NotNull ChannelId channelId) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        return (List)CollectionsKt.first((List)this.getSubscriptions(CollectionsKt.listOf((Object)channelId)));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<List<ChannelSubscription>> getSubscriptions(@NotNull List<ChannelId> channelIds) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(channelIds, (String)"channelIds");
        Set managedSubscriptions = this.managedSubscriptionRepo.getByChannelIdIn((Collection)channelIds);
        Set personalSubscriptions = this.personalSubscriptionRepo.getByChannelIdIn((Collection)channelIds);
        Iterable $this$map$iv = channelIds;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            void $this$mapTo$iv$iv2;
            Iterable iterable2;
            Iterable $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv;
            void $this$mapTo$iv$iv3;
            void $this$filterIsInstanceTo$iv$iv2;
            void $this$filterIsInstance$iv2;
            Collection collection;
            void $this$mapTo$iv$iv4;
            void $this$filterTo$iv$iv;
            void channelId;
            Object element$iv$iv2;
            void $this$filterTo$iv$iv2;
            ChannelId channelId2 = (ChannelId)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            Iterable $this$filter$iv = personalSubscriptions;
            boolean $i$f$filter = false;
            Iterable iterable3 = $this$filter$iv;
            Iterable destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv2 : $this$filterTo$iv$iv2) {
                PersonalSubscription it = (PersonalSubscription)element$iv$iv2;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)it.getChannelId(), (Object)channelId)) continue;
                destination$iv$iv2.add(element$iv$iv2);
            }
            List personalSubscriptionsForChannel = (List)destination$iv$iv2;
            Iterable $this$filter$iv2 = managedSubscriptions;
            boolean $i$f$filter2 = false;
            destination$iv$iv2 = $this$filter$iv2;
            Iterable destination$iv$iv3 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            element$iv$iv2 = $this$filterTo$iv$iv.iterator();
            while (element$iv$iv2.hasNext()) {
                Object element$iv$iv3 = element$iv$iv2.next();
                ManagedSubscription it = (ManagedSubscription)element$iv$iv3;
                boolean bl3 = false;
                if (!Intrinsics.areEqual((Object)it.getChannelId(), (Object)channelId)) continue;
                destination$iv$iv3.add(element$iv$iv3);
            }
            List managedSubscriptionsForChannel = (List)destination$iv$iv3;
            Iterable $this$map$iv2 = managedSubscriptionsForChannel;
            boolean $i$f$map2 = false;
            destination$iv$iv3 = $this$map$iv2;
            Iterable destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv4) {
                void it;
                ManagedSubscription bl3 = (ManagedSubscription)item$iv$iv2;
                collection = destination$iv$iv4;
                boolean bl4 = false;
                collection.add(it.getUserId());
            }
            $this$map$iv2 = (List)destination$iv$iv4;
            boolean $i$f$filterIsInstance = false;
            $this$mapTo$iv$iv4 = $this$filterIsInstance$iv2;
            destination$iv$iv4 = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv4 : $this$filterIsInstanceTo$iv$iv2) {
                if (!(element$iv$iv4 instanceof ProfileId)) continue;
                destination$iv$iv4.add(element$iv$iv4);
            }
            List profileManaged = (List)destination$iv$iv4;
            Iterable $this$map$iv3 = managedSubscriptionsForChannel;
            boolean $i$f$map3 = false;
            destination$iv$iv4 = $this$map$iv3;
            Iterable destination$iv$iv5 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
            boolean $i$f$mapTo3 = false;
            for (Object item$iv$iv3 : $this$mapTo$iv$iv3) {
                void it;
                ManagedSubscription bl4 = (ManagedSubscription)item$iv$iv3;
                collection = destination$iv$iv5;
                boolean bl5 = false;
                collection.add(it.getUserId());
            }
            $this$map$iv3 = (List)destination$iv$iv5;
            boolean $i$f$filterIsInstance2 = false;
            $this$mapTo$iv$iv3 = $this$filterIsInstance$iv;
            destination$iv$iv5 = new ArrayList();
            boolean $i$f$filterIsInstanceTo2 = false;
            for (Object element$iv$iv5 : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv5 instanceof UserGroupId)) continue;
                destination$iv$iv5.add(element$iv$iv5);
            }
            $this$filterIsInstance$iv = (List)destination$iv$iv5;
            $i$f$map3 = false;
            $this$filterIsInstanceTo$iv$iv = $this$map$iv3;
            destination$iv$iv5 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
            $i$f$mapTo3 = false;
            for (Object item$iv$iv4 : $this$mapTo$iv$iv3) {
                void $this$mapTo$iv$iv5;
                UserGroupId it = (UserGroupId)item$iv$iv4;
                collection = destination$iv$iv5;
                boolean bl6 = false;
                Iterable $this$map$iv4 = this.userGroupMemberRepo.getByUserGroupId(it);
                boolean $i$f$map4 = false;
                Iterable iterable4 = $this$map$iv4;
                Collection destination$iv$iv6 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv4, (int)10));
                boolean $i$f$mapTo4 = false;
                for (Object item$iv$iv5 : $this$mapTo$iv$iv5) {
                    void p0;
                    UserGroupMember userGroupMember = (UserGroupMember)item$iv$iv5;
                    iterable2 = destination$iv$iv6;
                    boolean bl7 = false;
                    iterable2.add(p0.getProfileId());
                }
                collection.add((List)destination$iv$iv6);
            }
            List groupManaged = CollectionsKt.flatten((Iterable)((List)destination$iv$iv5));
            Iterable $this$map$iv5 = personalSubscriptionsForChannel;
            boolean $i$f$map5 = false;
            destination$iv$iv5 = $this$map$iv5;
            Collection destination$iv$iv7 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv5, (int)10));
            boolean $i$f$mapTo5 = false;
            for (Object item$iv$iv6 : $this$mapTo$iv$iv2) {
                void it;
                PersonalSubscription bl6 = (PersonalSubscription)item$iv$iv6;
                collection = destination$iv$iv7;
                boolean bl8 = false;
                collection.add(it.getProfileId());
            }
            List subscribers = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)((List)destination$iv$iv7), (Iterable)profileManaged), (Iterable)groupManaged);
            $this$map$iv5 = CollectionsKt.distinct((Iterable)subscribers);
            boolean $i$f$mapNotNull = false;
            $this$mapTo$iv$iv2 = $this$mapNotNull$iv;
            destination$iv$iv7 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                ChannelSubscription it$iv$iv;
                Object v0;
                List managedSubscriptionsForUser;
                ProfileId subscriber;
                block14: {
                    void $this$filterTo$iv$iv3;
                    Object item$iv$iv72;
                    void $this$mapTo$iv$iv6;
                    Object element$iv$iv$iv;
                    Object element$iv$iv6 = element$iv$iv$iv = iterator.next();
                    boolean bl9 = false;
                    subscriber = (ProfileId)element$iv$iv6;
                    boolean bl10 = false;
                    Iterable $this$map$iv6 = this.userGroupMemberRepo.getByProfileId(subscriber);
                    boolean $i$f$map6 = false;
                    Iterable p0 = $this$map$iv6;
                    Iterable destination$iv$iv8 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv6, (int)10));
                    boolean $i$f$mapTo6 = false;
                    for (Object item$iv$iv72 : $this$mapTo$iv$iv6) {
                        void it;
                        UserGroupMember userGroupMember = (UserGroupMember)item$iv$iv72;
                        Collection collection3 = destination$iv$iv8;
                        boolean bl11 = false;
                        collection3.add(it.getUserGroupId());
                    }
                    List groupsOfSubscriber = (List)destination$iv$iv8;
                    Iterable $this$filter$iv3 = managedSubscriptionsForChannel;
                    boolean $i$f$filter3 = false;
                    destination$iv$iv8 = $this$filter$iv3;
                    Collection destination$iv$iv9 = new ArrayList();
                    boolean $i$f$filterTo3 = false;
                    item$iv$iv72 = $this$filterTo$iv$iv3.iterator();
                    while (item$iv$iv72.hasNext()) {
                        Object element$iv$iv7 = item$iv$iv72.next();
                        ManagedSubscription it = (ManagedSubscription)element$iv$iv7;
                        boolean bl12 = false;
                        if (!(Intrinsics.areEqual((Object)it.getUserId(), (Object)subscriber) || CollectionsKt.contains((Iterable)groupsOfSubscriber, (Object)it.getUserId()))) continue;
                        destination$iv$iv9.add(element$iv$iv7);
                    }
                    managedSubscriptionsForUser = (List)destination$iv$iv9;
                    iterable2 = personalSubscriptionsForChannel;
                    for (Object e : iterable2) {
                        PersonalSubscription it = (PersonalSubscription)e;
                        boolean bl13 = false;
                        if (!Intrinsics.areEqual((Object)it.getProfileId(), (Object)subscriber)) continue;
                        v0 = e;
                        break block14;
                    }
                    v0 = null;
                }
                PersonalSubscription personalSubscriptionForUser = v0;
                if (this.deriveSubscription((ChannelId)channelId, subscriber, personalSubscriptionForUser, (Collection)managedSubscriptionsForUser) == null) continue;
                boolean bl14 = false;
                destination$iv$iv7.add(it$iv$iv);
            }
            collection2.add((List)destination$iv$iv7);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<ChannelId> getSubscribedChannelIds(@NotNull ProfileId profileId) {
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        void $this$filterTo$iv$iv2;
        Collection collection2;
        void $this$mapTo$iv$iv2;
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        Iterable $this$map$iv2 = this.userGroupMemberRepo.getByProfileId(profileId);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            UserGroupMember userGroupMember = (UserGroupMember)item$iv$iv;
            collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(it.getUserGroupId());
        }
        List userGroupIds = (List)destination$iv$iv;
        Set managedSubscriptions = this.managedSubscriptionRepo.getByUserIdIn((Collection)CollectionsKt.plus((Collection)userGroupIds, (Object)profileId));
        List personalSubscriptions = this.personalSubscriptionRepo.getByProfileId(profileId);
        Iterable $this$filter$iv2 = managedSubscriptions;
        boolean $i$f$filter22 = false;
        Iterable iterable2 = $this$filter$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            ManagedSubscription it = (ManagedSubscription)element$iv$iv;
            boolean bl = false;
            if (!(it.getType() == ManagedSubscriptionType.MANDATORY)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List mandatory = (List)destination$iv$iv2;
        Iterable $i$f$filter22 = managedSubscriptions;
        boolean $i$f$filter = false;
        destination$iv$iv2 = $this$filter$iv;
        Collection destination$iv$iv3 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ManagedSubscription it = (ManagedSubscription)element$iv$iv;
            boolean bl = false;
            if (!(it.getType() == ManagedSubscriptionType.RECOMMENDED)) continue;
            destination$iv$iv3.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv3;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv3 = new ArrayList();
        $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PersonalSubscription personalSubscriptionForChannel;
            Object v0;
            block9: {
                ManagedSubscription managed = (ManagedSubscription)element$iv$iv;
                boolean bl = false;
                Iterable iterable3 = personalSubscriptions;
                for (Object t : iterable3) {
                    PersonalSubscription it = (PersonalSubscription)t;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)managed.getChannelId(), (Object)it.getChannelId())) continue;
                    v0 = t;
                    break block9;
                }
                v0 = null;
            }
            if (!((personalSubscriptionForChannel = (PersonalSubscription)v0) == null || !personalSubscriptionForChannel.getUserHasUnsubscribed())) continue;
            destination$iv$iv3.add(element$iv$iv);
        }
        List recommended = (List)destination$iv$iv3;
        $this$filter$iv = personalSubscriptions;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv3 = new ArrayList();
        $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PersonalSubscription it = (PersonalSubscription)element$iv$iv;
            boolean bl = false;
            if (!(!it.getUserHasUnsubscribed())) continue;
            destination$iv$iv3.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv3;
        boolean $i$f$map2 = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            PersonalSubscription it = (PersonalSubscription)item$iv$iv;
            collection2 = destination$iv$iv3;
            boolean bl = false;
            collection2.add(it.getChannelId());
        }
        $this$map$iv = mandatory;
        collection2 = (List)destination$iv$iv3;
        $i$f$map2 = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            ManagedSubscription it = (ManagedSubscription)item$iv$iv;
            collection = destination$iv$iv3;
            boolean bl = false;
            collection.add(it.getChannelId());
        }
        $this$map$iv = recommended;
        collection2 = CollectionsKt.plus((Collection)collection2, (Iterable)((List)destination$iv$iv3));
        $i$f$map2 = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            ManagedSubscription it = (ManagedSubscription)item$iv$iv;
            collection = destination$iv$iv3;
            boolean bl = false;
            collection.add(it.getChannelId());
        }
        return CollectionsKt.distinct((Iterable)CollectionsKt.plus((Collection)collection2, (Iterable)((List)destination$iv$iv3)));
    }

    private ChannelSubscription deriveSubscription(ChannelId channelId, ProfileId profileId, PersonalSubscription personalSubscription, Collection<ManagedSubscription> managedSubscriptions) {
        boolean recommended;
        boolean mandatory;
        block12: {
            boolean bl;
            boolean bl2;
            block11: {
                if (personalSubscription == null && managedSubscriptions.isEmpty()) {
                    return null;
                }
                Iterable $this$any$iv = managedSubscriptions;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        ManagedSubscription it = (ManagedSubscription)element$iv;
                        boolean bl3 = false;
                        if (!(it.getType() == ManagedSubscriptionType.MANDATORY)) continue;
                        bl2 = true;
                        break block11;
                    }
                    bl2 = false;
                }
            }
            mandatory = bl2;
            Iterable $this$any$iv = managedSubscriptions;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ManagedSubscription it = (ManagedSubscription)element$iv;
                    boolean bl4 = false;
                    if (!(it.getType() == ManagedSubscriptionType.RECOMMENDED)) continue;
                    bl = true;
                    break block12;
                }
                bl = recommended = false;
            }
        }
        if (mandatory) {
            return new ChannelSubscription(channelId, profileId, true, true);
        }
        if (recommended) {
            PersonalSubscription personalSubscription2 = personalSubscription;
            boolean bl = personalSubscription2 != null ? personalSubscription2.getUserHasUnsubscribed() : false;
            if (bl) {
                return null;
            }
            PersonalSubscription personalSubscription3 = personalSubscription;
            return new ChannelSubscription(channelId, profileId, false, personalSubscription3 != null ? personalSubscription3.getNotificationsEnabled() : true);
        }
        if (personalSubscription == null || personalSubscription.getUserHasUnsubscribed()) {
            return null;
        }
        return new ChannelSubscription(channelId, profileId, false, personalSubscription.getNotificationsEnabled());
    }

    private boolean profileHasOtherManagedSubs(ProfileId profileId, Collection<UserGroupId> groupsOfProfile, Set<ManagedSubscription> managedSubsOfChannel) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = managedSubsOfChannel;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ManagedSubscription it = (ManagedSubscription)element$iv;
                    boolean bl2 = false;
                    if (!(Intrinsics.areEqual((Object)it.getUserId(), (Object)profileId) || CollectionsKt.contains((Iterable)groupsOfProfile, (Object)it.getUserId()))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }
}

