/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.domain.subscription;

import de.justsoftware.news.ChannelId;
import de.justsoftware.news.ItemId;
import de.justsoftware.news.PersonalSubscriptionId;
import de.justsoftware.news.ProfileId;
import de.justsoftware.news.auth.AuthorizationContext;
import de.justsoftware.news.domain.subscription.ChannelSubscription;
import de.justsoftware.news.domain.subscription.SubscriptionRepoWrapper;
import de.justsoftware.news.domain.subscription.personal.PersonalSubscription;
import de.justsoftware.news.domain.subscription.personal.PersonalSubscriptionRepo;
import de.justsoftware.news.events.ProfileDeletedEvent;
import de.justsoftware.news.util.Unauthorized;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0017J*\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J&\u0010\u0012\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J \u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lde/justsoftware/news/domain/subscription/ChannelSubscriptionService;", "", "subscriptionRepoWrapper", "Lde/justsoftware/news/domain/subscription/SubscriptionRepoWrapper;", "personalSubscriptionRepo", "Lde/justsoftware/news/domain/subscription/personal/PersonalSubscriptionRepo;", "(Lde/justsoftware/news/domain/subscription/SubscriptionRepoWrapper;Lde/justsoftware/news/domain/subscription/personal/PersonalSubscriptionRepo;)V", "deletePersonalSubscriptions", "", "event", "Lde/justsoftware/news/events/ProfileDeletedEvent;", "findAllSubscriptionsForChannelIds", "", "Lde/justsoftware/news/domain/subscription/ChannelSubscription;", "channelIds", "Lde/justsoftware/news/ChannelId;", "authContext", "Lde/justsoftware/news/auth/AuthorizationContext;", "findOwnSubscriptionsForChannelIds", "subscribe", "channelId", "notificationsEnabled", "", "unsubscribe", "news-service"})
public class ChannelSubscriptionService {
    @NotNull
    private final SubscriptionRepoWrapper subscriptionRepoWrapper;
    @NotNull
    private final PersonalSubscriptionRepo personalSubscriptionRepo;

    public ChannelSubscriptionService(@NotNull SubscriptionRepoWrapper subscriptionRepoWrapper, @NotNull PersonalSubscriptionRepo personalSubscriptionRepo) {
        Intrinsics.checkNotNullParameter((Object)subscriptionRepoWrapper, (String)"subscriptionRepoWrapper");
        Intrinsics.checkNotNullParameter((Object)personalSubscriptionRepo, (String)"personalSubscriptionRepo");
        this.subscriptionRepoWrapper = subscriptionRepoWrapper;
        this.personalSubscriptionRepo = personalSubscriptionRepo;
    }

    @NotNull
    public ChannelSubscription subscribe(@NotNull ChannelId channelId, boolean notificationsEnabled, @NotNull AuthorizationContext authContext) {
        PersonalSubscription personalSubscription;
        ChannelSubscription channelSubscription;
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        authContext.checkRead((ItemId)channelId);
        ChannelSubscription channelSubscription2 = channelSubscription = this.subscriptionRepoWrapper.findSubscription(channelId, authContext.getUser());
        boolean bl = channelSubscription2 != null ? channelSubscription2.getMandatory() : false;
        if (bl) {
            throw new IllegalArgumentException("A mandatory subscription can't be subscribed.");
        }
        PersonalSubscription originSubscription = this.personalSubscriptionRepo.findByChannelIdAndProfileId(channelId, authContext.getUser());
        if (originSubscription == null) {
            PersonalSubscriptionRepo.insert$default((PersonalSubscriptionRepo)this.personalSubscriptionRepo, (PersonalSubscriptionId)PersonalSubscriptionId.Companion.random(), (ChannelId)channelId, (ProfileId)authContext.getUser(), (boolean)notificationsEnabled, (boolean)false, (int)16, null);
            personalSubscription = this.personalSubscriptionRepo.getByChannelIdAndProfileId(channelId, authContext.getUser());
        } else {
            PersonalSubscription update = PersonalSubscription.copy$default((PersonalSubscription)originSubscription, null, null, null, (boolean)notificationsEnabled, (boolean)false, (int)7, null);
            Object object = this.personalSubscriptionRepo.save((Object)update);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"{\n            val update\u2026po.save(update)\n        }");
            personalSubscription = (PersonalSubscription)object;
        }
        PersonalSubscription updated = personalSubscription;
        return this.subscriptionRepoWrapper.getSubscription(updated.getChannelId(), updated.getProfileId());
    }

    public void unsubscribe(@NotNull ChannelId channelId, @NotNull AuthorizationContext authContext) {
        ChannelSubscription channelSubscription;
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        authContext.checkRead((ItemId)channelId);
        ChannelSubscription channelSubscription2 = channelSubscription = this.subscriptionRepoWrapper.findSubscription(channelId, authContext.getUser());
        boolean bl = channelSubscription2 != null ? channelSubscription2.getMandatory() : false;
        if (bl) {
            throw new IllegalArgumentException("A mandatory subscription can't be unsubscribed.");
        }
        PersonalSubscription originSubscription = this.personalSubscriptionRepo.findByChannelIdAndProfileId(channelId, authContext.getUser());
        if (originSubscription == null) {
            this.personalSubscriptionRepo.insert(PersonalSubscriptionId.Companion.random(), channelId, authContext.getUser(), false, true);
        } else {
            authContext.checkUserEqual(originSubscription.getProfileId());
            this.personalSubscriptionRepo.save((Object)PersonalSubscription.copy$default((PersonalSubscription)originSubscription, null, null, null, (boolean)false, (boolean)true, (int)15, null));
        }
    }

    @NotNull
    public List<List<ChannelSubscription>> findAllSubscriptionsForChannelIds(@NotNull List<ChannelId> channelIds, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter(channelIds, (String)"channelIds");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        authContext.checkReadAll((Collection)channelIds);
        return this.subscriptionRepoWrapper.getSubscriptions(channelIds);
    }

    @NotNull
    public List<ChannelSubscription> findOwnSubscriptionsForChannelIds(@NotNull List<ChannelId> channelIds, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter(channelIds, (String)"channelIds");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        authContext.checkReadAll((Collection)channelIds);
        return this.subscriptionRepoWrapper.findSubscriptions(channelIds, authContext.getUser());
    }

    @EventListener
    @Unauthorized
    public void deletePersonalSubscriptions(@NotNull ProfileDeletedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.personalSubscriptionRepo.deleteByProfileId(event.getProfileId());
    }
}

