/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.domain.reaction;

import de.justsoftware.news.CommentId;
import de.justsoftware.news.ItemId;
import de.justsoftware.news.ReactionId;
import de.justsoftware.news.auth.AuthorizationContext;
import de.justsoftware.news.domain.comment.PostComment;
import de.justsoftware.news.domain.comment.PostCommentRepo;
import de.justsoftware.news.domain.reaction.Reaction;
import de.justsoftware.news.domain.reaction.ReactionRepo;
import de.justsoftware.news.domain.reaction.ReactionService;
import de.justsoftware.news.util.Unauthorized;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Service;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Service
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0002\b\u0017\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J \u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\b0\u00152\u0006\u0010\t\u001a\u00020\nH\u0017J\u001c\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\b0\u00152\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\n0\u0018H\u0017R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lde/justsoftware/news/domain/reaction/ReactionService;", "", "reactionRepo", "Lde/justsoftware/news/domain/reaction/ReactionRepo;", "postCommentRepo", "Lde/justsoftware/news/domain/comment/PostCommentRepo;", "(Lde/justsoftware/news/domain/reaction/ReactionRepo;Lde/justsoftware/news/domain/comment/PostCommentRepo;)V", "addLike", "Lde/justsoftware/news/domain/reaction/Reaction;", "itemId", "Lde/justsoftware/news/ItemId;", "authContext", "Lde/justsoftware/news/auth/AuthorizationContext;", "addReaction", "emoji", "", "deleteLike", "deleteReaction", "reactionId", "Lde/justsoftware/news/ReactionId;", "findAllByItemId", "", "findAllLikesByItemIds", "itemIds", "", "Companion", "news-service"})
public class ReactionService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ReactionRepo reactionRepo;
    @NotNull
    private final PostCommentRepo postCommentRepo;
    @NotNull
    public static final String LIKE_EMOJI = ":thumbsup:";

    public ReactionService(@NotNull ReactionRepo reactionRepo, @NotNull PostCommentRepo postCommentRepo) {
        Intrinsics.checkNotNullParameter((Object)reactionRepo, (String)"reactionRepo");
        Intrinsics.checkNotNullParameter((Object)postCommentRepo, (String)"postCommentRepo");
        this.reactionRepo = reactionRepo;
        this.postCommentRepo = postCommentRepo;
    }

    @NotNull
    public Reaction addLike(@NotNull ItemId itemId, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)itemId, (String)"itemId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.addReaction(LIKE_EMOJI, itemId, authContext);
    }

    @NotNull
    public Reaction addReaction(@NotNull String emoji, @NotNull ItemId itemId, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)emoji, (String)"emoji");
        Intrinsics.checkNotNullParameter((Object)itemId, (String)"itemId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        if (itemId instanceof CommentId) {
            PostComment comment = this.postCommentRepo.getById((CommentId)itemId);
            authContext.checkRead((ItemId)comment.getPostId());
        } else {
            authContext.checkRead(itemId);
        }
        Reaction original = this.reactionRepo.findByItemIdAndEmojiAndProfileId(itemId, emoji, authContext.getUser());
        if (original != null) {
            return original;
        }
        ReactionId reactionId = ReactionId.Companion.random();
        this.reactionRepo.insert(reactionId, emoji, itemId, authContext.getUser());
        return this.reactionRepo.getById(reactionId);
    }

    @Nullable
    public Reaction deleteLike(@NotNull ItemId itemId, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)itemId, (String)"itemId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        Reaction like = this.reactionRepo.findByItemIdAndEmojiAndProfileId(itemId, LIKE_EMOJI, authContext.getUser());
        if (like != null) {
            authContext.checkUserEqual(like.getProfileId());
            this.reactionRepo.deleteById((Object)like.getId());
        }
        return like;
    }

    @Nullable
    public Reaction deleteReaction(@NotNull ReactionId reactionId, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)reactionId, (String)"reactionId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.reactionRepo.findById((Object)reactionId).map(arg_0 -> ReactionService.deleteReaction$lambda-0(authContext, this, arg_0)).orElse(null);
    }

    @Unauthorized
    @NotNull
    public List<Reaction> findAllByItemId(@NotNull ItemId itemId) {
        Intrinsics.checkNotNullParameter((Object)itemId, (String)"itemId");
        return this.reactionRepo.findAllByItemId(itemId);
    }

    /*
     * WARNING - void declaration
     */
    @Unauthorized
    @NotNull
    public List<Reaction> findAllLikesByItemIds(@NotNull Collection<? extends ItemId> itemIds) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(itemIds, (String)"itemIds");
        Iterable $this$filter$iv = this.reactionRepo.findAllByItemIdIn(CollectionsKt.toSet((Iterable)itemIds));
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Reaction it = (Reaction)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getEmoji(), (Object)LIKE_EMOJI)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final Reaction deleteReaction$lambda-0(AuthorizationContext $authContext, ReactionService this$0, Reaction it) {
        Intrinsics.checkNotNullParameter((Object)$authContext, (String)"$authContext");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        $authContext.checkUserEqual(it.getProfileId());
        this$0.reactionRepo.deleteById((Object)it.getId());
        return it;
    }
}

