/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.domain.reaction;

import com.netflix.graphql.dgs.DgsComponent;
import com.netflix.graphql.dgs.DgsData;
import com.netflix.graphql.dgs.DgsDataFetchingEnvironment;
import com.netflix.graphql.dgs.DgsMutation;
import com.netflix.graphql.dgs.InputArgument;
import com.netflix.graphql.dgs.context.DgsContext;
import de.justsoftware.news.ItemId;
import de.justsoftware.news.ProfileId;
import de.justsoftware.news.ReactionId;
import de.justsoftware.news.auth.AuthorizationContext;
import de.justsoftware.news.domain.reaction.Reaction;
import de.justsoftware.news.domain.reaction.ReactionDataFetcherKt;
import de.justsoftware.news.domain.reaction.ReactionService;
import de.justsoftware.news.domain.user.ProfileDataLoader;
import de.justsoftware.news.graphql.generated.types.Like;
import de.justsoftware.news.graphql.generated.types.Profile;
import graphql.schema.DataFetchingEnvironment;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.dataloader.DataLoader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@DgsComponent
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0017J$\u0010\u000b\u001a\u00020\f2\b\b\u0001\u0010\r\u001a\u00020\b2\b\b\u0001\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0017J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\t\u001a\u00020\nH\u0017J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\t\u001a\u00020\nH\u0017J\u001c\u0010\u0012\u001a\u0004\u0018\u00010\u00062\b\b\u0001\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0017J\u001c\u0010\u0013\u001a\u0004\u0018\u00010\f2\b\b\u0001\u0010\u0014\u001a\u00020\u00152\u0006\u0010\t\u001a\u00020\nH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lde/justsoftware/news/domain/reaction/ReactionDataFetcher;", "", "reactionService", "Lde/justsoftware/news/domain/reaction/ReactionService;", "(Lde/justsoftware/news/domain/reaction/ReactionService;)V", "addLike", "Lde/justsoftware/news/graphql/generated/types/Like;", "itemId", "", "dfe", "Lcom/netflix/graphql/dgs/DgsDataFetchingEnvironment;", "addReaction", "Lde/justsoftware/news/graphql/generated/types/Reaction;", "emoji", "profileOnLikes", "Ljava/util/concurrent/CompletableFuture;", "Lde/justsoftware/news/graphql/generated/types/Profile;", "profileOnReactions", "removeLike", "removeReaction", "reactionId", "Lde/justsoftware/news/ReactionId;", "news-service"})
public class ReactionDataFetcher {
    @NotNull
    private final ReactionService reactionService;

    public ReactionDataFetcher(@NotNull ReactionService reactionService) {
        Intrinsics.checkNotNullParameter((Object)reactionService, (String)"reactionService");
        this.reactionService = reactionService;
    }

    @DgsMutation(field="addLike")
    @NotNull
    public Like addLike(@InputArgument @NotNull String itemId, @NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)itemId, (String)"itemId");
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        return ReactionDataFetcherKt.toLikeGql((Reaction)this.reactionService.addLike(ItemId.Companion.fromString(itemId), (AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe)));
    }

    @DgsMutation(field="removeLike")
    @Nullable
    public Like removeLike(@InputArgument @NotNull String itemId, @NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)itemId, (String)"itemId");
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        Reaction reaction = this.reactionService.deleteLike(ItemId.Companion.fromString(itemId), (AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe));
        return reaction != null ? ReactionDataFetcherKt.toLikeGql((Reaction)reaction) : null;
    }

    @DgsMutation(field="addReaction")
    @NotNull
    public de.justsoftware.news.graphql.generated.types.Reaction addReaction(@InputArgument @NotNull String emoji, @InputArgument @NotNull String itemId, @NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)emoji, (String)"emoji");
        Intrinsics.checkNotNullParameter((Object)itemId, (String)"itemId");
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        return ReactionDataFetcherKt.toGql((Reaction)this.reactionService.addReaction(emoji, ItemId.Companion.fromString(itemId), (AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe)));
    }

    @DgsMutation(field="removeReaction")
    @Nullable
    public de.justsoftware.news.graphql.generated.types.Reaction removeReaction(@InputArgument @NotNull ReactionId reactionId, @NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)reactionId, (String)"reactionId");
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        Reaction reaction = this.reactionService.deleteReaction(reactionId, (AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe));
        return reaction != null ? ReactionDataFetcherKt.toGql((Reaction)reaction) : null;
    }

    @DgsData(parentType="Reaction", field="profile")
    @NotNull
    public CompletableFuture<Profile> profileOnReactions(@NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        DataLoader dataLoader = dfe.getDataLoader(ProfileDataLoader.class);
        ProfileId profileId = ((de.justsoftware.news.graphql.generated.types.Reaction)dfe.getSource()).getProfileId();
        CompletableFuture completableFuture = dataLoader.load((Object)profileId);
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"dataLoader.load(profileId)");
        return completableFuture;
    }

    @DgsData(parentType="Like", field="profile")
    @NotNull
    public CompletableFuture<Profile> profileOnLikes(@NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        DataLoader dataLoader = dfe.getDataLoader(ProfileDataLoader.class);
        ProfileId profileId = ((Like)dfe.getSource()).getProfileId();
        CompletableFuture completableFuture = dataLoader.load((Object)profileId);
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"dataLoader.load(profileId)");
        return completableFuture;
    }
}

