/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.domain.post.readmark;

import de.justsoftware.news.PostId;
import de.justsoftware.news.PostReadMarkId;
import de.justsoftware.news.ProfileId;
import de.justsoftware.news.auth.AuthorizationContext;
import de.justsoftware.news.domain.post.readmark.PostReadMarkRepo;
import de.justsoftware.news.domain.subscription.ChannelSubscription;
import de.justsoftware.news.domain.subscription.SubscriptionRepoWrapper;
import de.justsoftware.news.events.PostPublishedEvent;
import de.justsoftware.news.util.Unauthorized;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.event.EventListener;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0017J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lde/justsoftware/news/domain/post/readmark/PostReadMarkService;", "", "postReadMarkRepo", "Lde/justsoftware/news/domain/post/readmark/PostReadMarkRepo;", "subscriptionRepoWrapper", "Lde/justsoftware/news/domain/subscription/SubscriptionRepoWrapper;", "(Lde/justsoftware/news/domain/post/readmark/PostReadMarkRepo;Lde/justsoftware/news/domain/subscription/SubscriptionRepoWrapper;)V", "cleanUpOldEntries", "", "deletionDelay", "Ljava/time/Duration;", "getNumberOfUnreadPosts", "", "authContext", "Lde/justsoftware/news/auth/AuthorizationContext;", "markAllPostsAsRead", "markPostAsRead", "postId", "Lde/justsoftware/news/PostId;", "markPostAsUnread", "event", "Lde/justsoftware/news/events/PostPublishedEvent;", "news-service"})
public class PostReadMarkService {
    @NotNull
    private final PostReadMarkRepo postReadMarkRepo;
    @NotNull
    private final SubscriptionRepoWrapper subscriptionRepoWrapper;

    public PostReadMarkService(@NotNull PostReadMarkRepo postReadMarkRepo, @NotNull SubscriptionRepoWrapper subscriptionRepoWrapper) {
        Intrinsics.checkNotNullParameter((Object)postReadMarkRepo, (String)"postReadMarkRepo");
        Intrinsics.checkNotNullParameter((Object)subscriptionRepoWrapper, (String)"subscriptionRepoWrapper");
        this.postReadMarkRepo = postReadMarkRepo;
        this.subscriptionRepoWrapper = subscriptionRepoWrapper;
    }

    public int getNumberOfUnreadPosts(@NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.postReadMarkRepo.countByProfileId(authContext.getUser());
    }

    public void markPostAsRead(@NotNull PostId postId, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        this.postReadMarkRepo.deleteByPostIdAndProfileId(postId, authContext.getUser());
    }

    public void markAllPostsAsRead(@NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        this.postReadMarkRepo.deleteByProfileId(authContext.getUser());
    }

    /*
     * WARNING - void declaration
     */
    @Async
    @EventListener
    public void markPostAsUnread(@NotNull PostPublishedEvent event) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Iterable $this$map$iv = this.subscriptionRepoWrapper.getSubscriptions(event.getPost().getChannelId());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ChannelSubscription channelSubscription = (ChannelSubscription)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getProfileId());
        }
        List subscribers = (List)destination$iv$iv;
        Iterable $this$forEach$iv = CollectionsKt.minus((Iterable)subscribers, (Object)event.getPost().getAuthorId());
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ProfileId it = (ProfileId)element$iv;
            boolean bl = false;
            this.postReadMarkRepo.insert(PostReadMarkId.Companion.random(), event.getPost().getId(), it, event.getPost().getPublishDate());
        }
    }

    @Unauthorized
    public void cleanUpOldEntries(@NotNull Duration deletionDelay) {
        Intrinsics.checkNotNullParameter((Object)deletionDelay, (String)"deletionDelay");
        Instant instant = Instant.now().minus(deletionDelay.toSeconds(), ChronoUnit.SECONDS);
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now().minus(deletionDela\u2026ds(), ChronoUnit.SECONDS)");
        this.postReadMarkRepo.deleteByPostPublishedDateLessThan(instant);
    }
}

