/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.domain.post;

import de.justsoftware.news.ChannelId;
import de.justsoftware.news.DocumentId;
import de.justsoftware.news.ItemId;
import de.justsoftware.news.PostId;
import de.justsoftware.news.ProfileId;
import de.justsoftware.news.TenantId;
import de.justsoftware.news.UserId;
import de.justsoftware.news.auth.AuthorizationContext;
import de.justsoftware.news.connector.drive.DriveApiConnector;
import de.justsoftware.news.connector.drive.DriveDocument;
import de.justsoftware.news.connector.notification.NotificationConnector;
import de.justsoftware.news.connector.permission.PermissionKafkaProducer;
import de.justsoftware.news.connector.translation.TranslationConnector;
import de.justsoftware.news.domain.attachment.Attachment;
import de.justsoftware.news.domain.attachment.AttachmentRepo;
import de.justsoftware.news.domain.channel.ChannelRepo;
import de.justsoftware.news.domain.poll.Poll;
import de.justsoftware.news.domain.poll.PollAnswer;
import de.justsoftware.news.domain.poll.PollAnswerRepo;
import de.justsoftware.news.domain.poll.PollRepo;
import de.justsoftware.news.domain.post.Post;
import de.justsoftware.news.domain.post.PostRepo;
import de.justsoftware.news.domain.post.PostService;
import de.justsoftware.news.domain.post.model.PostTranslation;
import de.justsoftware.news.domain.post.model.TranslationLanguage;
import de.justsoftware.news.domain.subscription.ChannelSubscription;
import de.justsoftware.news.domain.subscription.SubscriptionRepoWrapper;
import de.justsoftware.news.domain.tenant.TenantRepo;
import de.justsoftware.news.domain.user.Profile;
import de.justsoftware.news.domain.user.ProfileRepo;
import de.justsoftware.news.graphql.generated.types.AttachmentInput;
import de.justsoftware.news.util.PaginationSupportKt;
import de.justsoftware.news.util.QuillUtils;
import de.justsoftware.news.util.TransactionSupport;
import de.justsoftware.news.util.Unauthorized;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u00ea\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 ^2\u00020\u0001:\u0001^Bu\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u0012\u0006\u0010\u0016\u001a\u00020\u0017\u0012\u0006\u0010\u0018\u001a\u00020\u0019\u0012\u0006\u0010\u001a\u001a\u00020\u001b\u0012\u0006\u0010\u001c\u001a\u00020\u001d\u00a2\u0006\u0002\u0010\u001eJ\u0012\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0012J\u0081\u0001\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020(2\u0006\u0010*\u001a\u00020(2\b\b\u0002\u0010+\u001a\u00020,2\n\b\u0002\u0010-\u001a\u0004\u0018\u00010\"2\n\b\u0002\u0010.\u001a\u0004\u0018\u00010/2\n\b\u0002\u00100\u001a\u0004\u0018\u0001012\u0010\b\u0002\u00102\u001a\n\u0012\u0004\u0012\u000204\u0018\u0001032\n\b\u0002\u00105\u001a\u0004\u0018\u0001062\u0006\u00107\u001a\u000208H\u0017\u00a2\u0006\u0002\u00109J\u0087\u0001\u0010:\u001a\u00020$2\u0006\u0010+\u001a\u00020,2\b\u0010'\u001a\u0004\u0018\u00010(2\b\u0010)\u001a\u0004\u0018\u00010(2\b\u0010*\u001a\u0004\u0018\u00010(2\b\u0010-\u001a\u0004\u0018\u00010\"2\b\u0010.\u001a\u0004\u0018\u00010/2\b\u00100\u001a\u0004\u0018\u0001012\u000e\u00102\u001a\n\u0012\u0004\u0012\u000204\u0018\u0001032\b\u0010;\u001a\u0004\u0018\u00010/2\b\u00105\u001a\u0004\u0018\u0001062\b\u0010<\u001a\u0004\u0018\u00010/2\u0006\u00107\u001a\u000208H\u0017\u00a2\u0006\u0002\u0010=J\u001a\u0010>\u001a\u0004\u0018\u00010$2\u0006\u0010?\u001a\u00020,2\u0006\u00107\u001a\u000208H\u0016J\u001a\u0010@\u001a\u0004\u0018\u00010$2\u0006\u0010?\u001a\u00020,2\u0006\u00107\u001a\u000208H\u0016J8\u0010A\u001a\b\u0012\u0004\u0012\u00020$032\f\u0010B\u001a\b\u0012\u0004\u0012\u00020&0C2\u0006\u00107\u001a\u0002082\b\b\u0002\u0010D\u001a\u00020/2\b\b\u0002\u0010E\u001a\u00020FH\u0016J\u0018\u0010G\u001a\u00020$2\u0006\u0010?\u001a\u00020,2\u0006\u00107\u001a\u000208H\u0016J>\u0010H\u001a\b\u0012\u0004\u0012\u00020$032\u0006\u0010%\u001a\u00020&2\u0006\u0010I\u001a\u00020F2\u0006\u0010E\u001a\u00020F2\u0006\u0010J\u001a\u00020/2\u0006\u0010.\u001a\u00020/2\u0006\u00107\u001a\u000208H\u0016J.\u0010K\u001a\b\u0012\u0004\u0012\u00020$032\u0006\u0010I\u001a\u00020F2\u0006\u0010E\u001a\u00020F2\u0006\u0010.\u001a\u00020/2\u0006\u00107\u001a\u000208H\u0016J6\u0010L\u001a \u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020N\u0012\n\u0012\b\u0012\u0004\u0012\u00020$0O0M2\u0006\u0010J\u001a\u00020/2\u0006\u0010.\u001a\u00020/H\u0012J4\u0010P\u001a&\u0012\u0004\u0012\u00020\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020&03\u0012\u0004\u0012\u00020N\u0012\n\u0012\b\u0012\u0004\u0012\u00020$0O0M2\u0006\u0010.\u001a\u00020/H\u0012J&\u0010Q\u001a\u00020 2\u0006\u00100\u001a\u0002012\f\u00102\u001a\b\u0012\u0004\u0012\u000204032\u0006\u0010+\u001a\u00020,H\u0012J\u000e\u0010R\u001a\b\u0012\u0004\u0012\u00020$03H\u0017J&\u0010S\u001a\u00020 2\f\u0010T\u001a\b\u0012\u0004\u0012\u00020U0C2\u0006\u0010V\u001a\u00020$2\u0006\u0010W\u001a\u00020XH\u0012J\u0018\u0010Y\u001a\u00020 2\u0006\u0010V\u001a\u00020$2\u0006\u0010W\u001a\u00020XH\u0012J0\u0010Z\u001a\u00020[2\u0006\u0010+\u001a\u00020,2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020(2\u0006\u0010\\\u001a\u00020]2\u0006\u00107\u001a\u000208H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006_"}, d2={"Lde/justsoftware/news/domain/post/PostService;", "", "attachmentRepo", "Lde/justsoftware/news/domain/attachment/AttachmentRepo;", "channelRepo", "Lde/justsoftware/news/domain/channel/ChannelRepo;", "notificationConnector", "Lde/justsoftware/news/connector/notification/NotificationConnector;", "pollRepo", "Lde/justsoftware/news/domain/poll/PollRepo;", "pollAnswerRepo", "Lde/justsoftware/news/domain/poll/PollAnswerRepo;", "profileRepo", "Lde/justsoftware/news/domain/user/ProfileRepo;", "driveApiConnector", "Lde/justsoftware/news/connector/drive/DriveApiConnector;", "postRepo", "Lde/justsoftware/news/domain/post/PostRepo;", "permissionKafkaProducer", "Lde/justsoftware/news/connector/permission/PermissionKafkaProducer;", "subscriptionRepoWrapper", "Lde/justsoftware/news/domain/subscription/SubscriptionRepoWrapper;", "tenantRepo", "Lde/justsoftware/news/domain/tenant/TenantRepo;", "transactionSupport", "Lde/justsoftware/news/util/TransactionSupport;", "translationConnector", "Lde/justsoftware/news/connector/translation/TranslationConnector;", "eventPublisher", "Lorg/springframework/context/ApplicationEventPublisher;", "(Lde/justsoftware/news/domain/attachment/AttachmentRepo;Lde/justsoftware/news/domain/channel/ChannelRepo;Lde/justsoftware/news/connector/notification/NotificationConnector;Lde/justsoftware/news/domain/poll/PollRepo;Lde/justsoftware/news/domain/poll/PollAnswerRepo;Lde/justsoftware/news/domain/user/ProfileRepo;Lde/justsoftware/news/connector/drive/DriveApiConnector;Lde/justsoftware/news/domain/post/PostRepo;Lde/justsoftware/news/connector/permission/PermissionKafkaProducer;Lde/justsoftware/news/domain/subscription/SubscriptionRepoWrapper;Lde/justsoftware/news/domain/tenant/TenantRepo;Lde/justsoftware/news/util/TransactionSupport;Lde/justsoftware/news/connector/translation/TranslationConnector;Lorg/springframework/context/ApplicationEventPublisher;)V", "checkCoverInAttachments", "", "input", "Lde/justsoftware/news/graphql/generated/types/AttachmentInput;", "create", "Lde/justsoftware/news/domain/post/Post;", "channelId", "Lde/justsoftware/news/ChannelId;", "title", "", "text", "jsonContent", "postId", "Lde/justsoftware/news/PostId;", "attachmentInput", "pinned", "", "poll", "Lde/justsoftware/news/domain/poll/Poll;", "pollAnswers", "", "Lde/justsoftware/news/domain/poll/PollAnswer;", "publishDate", "Ljava/time/Instant;", "authContext", "Lde/justsoftware/news/auth/AuthorizationContext;", "(Lde/justsoftware/news/ChannelId;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lde/justsoftware/news/PostId;Lde/justsoftware/news/graphql/generated/types/AttachmentInput;Ljava/lang/Boolean;Lde/justsoftware/news/domain/poll/Poll;Ljava/util/List;Ljava/time/Instant;Lde/justsoftware/news/auth/AuthorizationContext;)Lde/justsoftware/news/domain/post/Post;", "edit", "deletePoll", "published", "(Lde/justsoftware/news/PostId;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lde/justsoftware/news/graphql/generated/types/AttachmentInput;Ljava/lang/Boolean;Lde/justsoftware/news/domain/poll/Poll;Ljava/util/List;Ljava/lang/Boolean;Ljava/time/Instant;Ljava/lang/Boolean;Lde/justsoftware/news/auth/AuthorizationContext;)Lde/justsoftware/news/domain/post/Post;", "findById", "id", "findByIdDeleted", "getByChannelIds", "channelIds", "", "pinnedOnly", "limit", "", "getById", "getChannelPosts", "offset", "scheduled", "getFeed", "getMatchingChannelQuery", "Lkotlin/Function3;", "Lorg/springframework/data/domain/Pageable;", "Lorg/springframework/data/domain/Page;", "getMatchingFeedQuery", "insertPoll", "publishScheduledPosts", "sendMentionNotifications", "mentions", "Lde/justsoftware/news/UserId;", "post", "tenantId", "Lde/justsoftware/news/TenantId;", "sendNotifications", "translatePost", "Lde/justsoftware/news/domain/post/model/PostTranslation;", "targetLanguage", "Lde/justsoftware/news/domain/post/model/TranslationLanguage;", "Companion", "news-service"})
public class PostService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AttachmentRepo attachmentRepo;
    @NotNull
    private final ChannelRepo channelRepo;
    @NotNull
    private final NotificationConnector notificationConnector;
    @NotNull
    private final PollRepo pollRepo;
    @NotNull
    private final PollAnswerRepo pollAnswerRepo;
    @NotNull
    private final ProfileRepo profileRepo;
    @NotNull
    private final DriveApiConnector driveApiConnector;
    @NotNull
    private final PostRepo postRepo;
    @NotNull
    private final PermissionKafkaProducer permissionKafkaProducer;
    @NotNull
    private final SubscriptionRepoWrapper subscriptionRepoWrapper;
    @NotNull
    private final TenantRepo tenantRepo;
    @NotNull
    private final TransactionSupport transactionSupport;
    @NotNull
    private final TranslationConnector translationConnector;
    @NotNull
    private final ApplicationEventPublisher eventPublisher;
    @NotNull
    private static final Logger log;

    public PostService(@NotNull AttachmentRepo attachmentRepo, @NotNull ChannelRepo channelRepo, @NotNull NotificationConnector notificationConnector, @NotNull PollRepo pollRepo, @NotNull PollAnswerRepo pollAnswerRepo, @NotNull ProfileRepo profileRepo, @NotNull DriveApiConnector driveApiConnector, @NotNull PostRepo postRepo, @NotNull PermissionKafkaProducer permissionKafkaProducer, @NotNull SubscriptionRepoWrapper subscriptionRepoWrapper, @NotNull TenantRepo tenantRepo, @NotNull TransactionSupport transactionSupport, @NotNull TranslationConnector translationConnector, @NotNull ApplicationEventPublisher eventPublisher) {
        Intrinsics.checkNotNullParameter((Object)attachmentRepo, (String)"attachmentRepo");
        Intrinsics.checkNotNullParameter((Object)channelRepo, (String)"channelRepo");
        Intrinsics.checkNotNullParameter((Object)notificationConnector, (String)"notificationConnector");
        Intrinsics.checkNotNullParameter((Object)pollRepo, (String)"pollRepo");
        Intrinsics.checkNotNullParameter((Object)pollAnswerRepo, (String)"pollAnswerRepo");
        Intrinsics.checkNotNullParameter((Object)profileRepo, (String)"profileRepo");
        Intrinsics.checkNotNullParameter((Object)driveApiConnector, (String)"driveApiConnector");
        Intrinsics.checkNotNullParameter((Object)postRepo, (String)"postRepo");
        Intrinsics.checkNotNullParameter((Object)permissionKafkaProducer, (String)"permissionKafkaProducer");
        Intrinsics.checkNotNullParameter((Object)subscriptionRepoWrapper, (String)"subscriptionRepoWrapper");
        Intrinsics.checkNotNullParameter((Object)tenantRepo, (String)"tenantRepo");
        Intrinsics.checkNotNullParameter((Object)transactionSupport, (String)"transactionSupport");
        Intrinsics.checkNotNullParameter((Object)translationConnector, (String)"translationConnector");
        Intrinsics.checkNotNullParameter((Object)eventPublisher, (String)"eventPublisher");
        this.attachmentRepo = attachmentRepo;
        this.channelRepo = channelRepo;
        this.notificationConnector = notificationConnector;
        this.pollRepo = pollRepo;
        this.pollAnswerRepo = pollAnswerRepo;
        this.profileRepo = profileRepo;
        this.driveApiConnector = driveApiConnector;
        this.postRepo = postRepo;
        this.permissionKafkaProducer = permissionKafkaProducer;
        this.subscriptionRepoWrapper = subscriptionRepoWrapper;
        this.tenantRepo = tenantRepo;
        this.transactionSupport = transactionSupport;
        this.translationConnector = translationConnector;
        this.eventPublisher = eventPublisher;
    }

    @Transactional
    @NotNull
    public Post create(@NotNull ChannelId channelId, @NotNull String title, @NotNull String text, @NotNull String jsonContent, @NotNull PostId postId, @Nullable AttachmentInput attachmentInput, @Nullable Boolean pinned, @Nullable Poll poll, @Nullable List<PollAnswer> pollAnswers, @Nullable Instant publishDate, @NotNull AuthorizationContext authContext) {
        Collection $this$forEach$iv;
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)jsonContent, (String)"jsonContent");
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        authContext.checkWrite((ItemId)channelId);
        this.checkCoverInAttachments(attachmentInput);
        Object object = attachmentInput;
        if (object == null || (object = object.getAttachmentIds()) == null) {
            object = CollectionsKt.emptyList();
        }
        Object attachments = object;
        AttachmentInput attachmentInput2 = attachmentInput;
        DocumentId coverElementId = attachmentInput2 != null ? attachmentInput2.getCoverElementId() : null;
        Instant now = Instant.now();
        if (publishDate != null && !publishDate.isAfter(now)) {
            boolean $i$a$-require-PostService$create$22 = false;
            String $i$a$-require-PostService$create$22 = "If provided, 'publishDate' must be a date in the future.";
            throw new IllegalArgumentException($i$a$-require-PostService$create$22.toString());
        }
        boolean isScheduled = publishDate != null && publishDate.isAfter(now);
        ProfileId profileId = authContext.getUser();
        Intrinsics.checkNotNullExpressionValue((Object)now, (String)"now");
        Boolean bl = pinned;
        PostRepo.insert$default((PostRepo)this.postRepo, (PostId)postId, (ProfileId)profileId, (ChannelId)channelId, (Instant)now, (Instant)now, (String)title, (String)text, (String)jsonContent, (DocumentId)coverElementId, (boolean)(bl != null ? bl : false), (Instant)(Intrinsics.areEqual((Object)pinned, (Object)true) ? now : null), (Instant)(publishDate != null && isScheduled ? publishDate : now), (!isScheduled ? 1 : 0) != 0, (boolean)false, (int)8192, null);
        if (!((Collection)attachments).isEmpty()) {
            Iterable $i$a$-require-PostService$create$22 = this.driveApiConnector.addFiles((List)attachments, postId, authContext.getUser());
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                DriveDocument it = (DriveDocument)element$iv;
                boolean bl2 = false;
                this.attachmentRepo.insert(it.getDocumentId(), postId, it.getMimeType(), it.getName(), it.getSize());
            }
        }
        if (poll != null && !(($this$forEach$iv = (Collection)pollAnswers) == null || $this$forEach$iv.isEmpty())) {
            this.insertPoll(poll, pollAnswers, postId);
        }
        Post post = this.postRepo.getByIdAndDeletedFalse(postId);
        this.transactionSupport.afterCommit((Function0)new /* Unavailable Anonymous Inner Class!! */);
        return post;
    }

    public static /* synthetic */ Post create$default(PostService postService, ChannelId channelId, String string, String string2, String string3, PostId postId, AttachmentInput attachmentInput, Boolean bl, Poll poll, List list, Instant instant, AuthorizationContext authorizationContext, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: create");
        }
        if ((n & 0x10) != 0) {
            postId = PostId.Companion.random();
        }
        if ((n & 0x20) != 0) {
            attachmentInput = null;
        }
        if ((n & 0x40) != 0) {
            bl = false;
        }
        if ((n & 0x80) != 0) {
            poll = null;
        }
        if ((n & 0x100) != 0) {
            list = null;
        }
        if ((n & 0x200) != 0) {
            instant = null;
        }
        return postService.create(channelId, string, string2, string3, postId, attachmentInput, bl, poll, list, instant, authorizationContext);
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    @NotNull
    public Post edit(@NotNull PostId postId, @Nullable String title, @Nullable String text, @Nullable String jsonContent, @Nullable AttachmentInput attachmentInput, @Nullable Boolean pinned, @Nullable Poll poll, @Nullable List<PollAnswer> pollAnswers, @Nullable Boolean deletePoll, @Nullable Instant publishDate, @Nullable Boolean published, @NotNull AuthorizationContext authContext) {
        Instant instant;
        String string;
        String string2;
        String string3;
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        authContext.checkManage((ItemId)postId);
        this.checkCoverInAttachments(attachmentInput);
        AttachmentInput attachmentInput2 = attachmentInput;
        List attachments = attachmentInput2 != null ? attachmentInput2.getAttachmentIds() : null;
        AttachmentInput attachmentInput3 = attachmentInput;
        DocumentId coverElementId = attachmentInput3 != null ? attachmentInput3.getCoverElementId() : null;
        boolean updateCoverElement = attachmentInput != null;
        Post origin = this.postRepo.getByIdAndDeletedFalse(postId);
        boolean publishNow = !origin.getPublished() && Intrinsics.areEqual((Object)published, (Object)true);
        Instant now = Instant.now();
        if (origin.getPublished() && publishDate != null && publishDate.compareTo(now) > 0 || Intrinsics.areEqual((Object)published, (Object)false)) {
            throw new IllegalArgumentException("Already published posts may not be planned again.");
        }
        Instant pinnedAt = null;
        if (Intrinsics.areEqual((Object)pinned, (Object)true) && origin.getPinned()) {
            pinnedAt = origin.getPinnedAt();
        }
        if (Intrinsics.areEqual((Object)pinned, (Object)true) && !origin.getPinned()) {
            pinnedAt = now;
        }
        if ((string3 = title) == null) {
            string3 = string2 = origin.getTitle();
        }
        if ((string = text) == null) {
            string = origin.getText();
        }
        Object object = string;
        DocumentId documentId = updateCoverElement ? coverElementId : origin.getCoverElementId();
        String string4 = jsonContent;
        if (string4 == null) {
            string4 = origin.getJsonContent();
        }
        String string5 = string4;
        Boolean bl = pinned;
        boolean bl2 = bl != null ? bl.booleanValue() : origin.getPinned();
        Object object2 = pinnedAt;
        if (publishNow) {
            instant = now;
        } else {
            instant = publishDate;
            if (instant == null) {
                instant = origin.getPublishDate();
            }
        }
        Instant instant2 = instant;
        Boolean bl3 = published;
        boolean bl4 = bl3 != null ? bl3.booleanValue() : origin.getPublished();
        Intrinsics.checkNotNullExpressionValue((Object)now, (String)"now");
        Intrinsics.checkNotNullExpressionValue((Object)instant2, (String)"if (publishNow) now else\u2026ate ?: origin.publishDate");
        Post update = Post.copy$default((Post)origin, null, null, null, null, (Instant)now, (String)string2, (String)object, (String)string5, (DocumentId)documentId, (boolean)false, (boolean)bl2, (Instant)object2, (Instant)instant2, (boolean)bl4, (int)527, null);
        List list = attachments;
        if (list != null) {
            void $this$forEach$iv;
            void $this$filterTo$iv$iv;
            Object element$iv2;
            Iterator $this$filterTo$iv$iv2;
            Object item$iv$iv2;
            void $this$mapTo$iv$iv;
            List it = list;
            boolean bl5 = false;
            Iterable $this$map$iv = this.attachmentRepo.findAllByPostId(postId);
            boolean $i$f$map = false;
            object2 = $this$map$iv;
            Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv) {
                void it2;
                Attachment attachment = (Attachment)item$iv$iv2;
                Collection collection = destination$iv$iv;
                boolean bl6 = false;
                collection.add(it2.getId());
            }
            List originAttachmentIds = (List)destination$iv$iv;
            Iterable $this$filter$iv = originAttachmentIds;
            boolean $i$f$filter = false;
            destination$iv$iv = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            item$iv$iv2 = $this$filterTo$iv$iv2.iterator();
            while (item$iv$iv2.hasNext()) {
                Object element$iv$iv = item$iv$iv2.next();
                DocumentId it3 = (DocumentId)element$iv$iv;
                boolean bl7 = false;
                if (!(!attachments.contains(it3))) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List toDelete = (List)destination$iv$iv2;
            Iterable $this$forEach$iv2 = toDelete;
            boolean $i$f$forEach = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                DocumentId it4 = (DocumentId)element$iv2;
                boolean bl8 = false;
                this.driveApiConnector.deleteFile(it4, authContext.getUser());
            }
            this.attachmentRepo.deleteAllById((Iterable)toDelete);
            Iterable $this$filter$iv2 = attachments;
            boolean $i$f$filter2 = false;
            element$iv2 = $this$filter$iv2;
            Collection destination$iv$iv3 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                DocumentId it5 = (DocumentId)element$iv$iv;
                boolean bl9 = false;
                if (!(!originAttachmentIds.contains(it5))) continue;
                destination$iv$iv3.add(element$iv$iv);
            }
            List toAdd = (List)destination$iv$iv3;
            $this$filter$iv2 = this.driveApiConnector.addFiles(toAdd, postId, authContext.getUser());
            boolean $i$f$forEach2 = false;
            for (Object element$iv3 : $this$forEach$iv) {
                DriveDocument it6 = (DriveDocument)element$iv3;
                boolean bl10 = false;
                this.attachmentRepo.insert(it6.getDocumentId(), postId, it6.getMimeType(), it6.getName(), it6.getSize());
            }
        }
        Poll originPoll = this.pollRepo.findByPostId(origin.getId());
        if (poll != null && !((object = (Collection)pollAnswers) == null || object.isEmpty())) {
            this.insertPoll(poll, pollAnswers, postId);
        }
        if (Intrinsics.areEqual((Object)deletePoll, (Object)true) && originPoll != null) {
            this.pollRepo.deleteById((Object)originPoll.getId());
        }
        this.transactionSupport.afterCommit((Function0)new /* Unavailable Anonymous Inner Class!! */);
        Object object3 = this.postRepo.save((Object)update);
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"postRepo.save(update)");
        return (Post)object3;
    }

    @NotNull
    public List<Post> getChannelPosts(@NotNull ChannelId channelId, int offset, int limit, boolean scheduled, boolean pinned, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return PaginationSupportKt.convertPaging((int)offset, (int)limit, (Function2)((Function2)new /* Unavailable Anonymous Inner Class!! */));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<Post> getFeed(int offset, int limit, boolean pinned, @NotNull AuthorizationContext authContext) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        ChannelId channelId;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        List channelIdsOfTenant = this.channelRepo.getIdsByTenant(authContext.getTenantId());
        Iterable iterable = this.subscriptionRepoWrapper.getSubscribedChannelIds(authContext.getUser());
        boolean $i$f$filter = false;
        void var9_10 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            channelId = (ChannelId)element$iv$iv;
            boolean bl = false;
            if (!channelIdsOfTenant.contains(channelId)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List it = (List)destination$iv$iv;
        boolean $i$a$-let-PostService$getFeed$subscribedChannelIds$32 = false;
        $this$filter$iv = authContext.filterReadable((Collection)it);
        boolean $i$f$map = false;
        void $i$a$-let-PostService$getFeed$subscribedChannelIds$32 = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            channelId = (ChannelId)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(ChannelId.Companion.fromString(it2.toTypedString()));
        }
        List subscribedChannelIds = (List)destination$iv$iv;
        Function3 feedQuery = this.getMatchingFeedQuery(pinned);
        return PaginationSupportKt.convertPaging((int)offset, (int)limit, (Function2)((Function2)new /* Unavailable Anonymous Inner Class!! */));
    }

    @NotNull
    public Post getById(@NotNull PostId id, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        Post post = this.postRepo.getByIdAndDeletedFalse(id);
        authContext.checkReadPost(post.getId(), !post.getPublished());
        return post;
    }

    @Nullable
    public Post findById(@NotNull PostId id, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        Post post = PostRepo.findByIdAndDeleted$default((PostRepo)this.postRepo, (PostId)id, (boolean)false, (int)2, null);
        if (post == null) {
            return null;
        }
        Post post2 = post;
        authContext.checkReadPost(post2.getId(), !post2.getPublished());
        return post2;
    }

    @Nullable
    public Post findByIdDeleted(@NotNull PostId id, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        authContext.checkManage((ItemId)id);
        return this.postRepo.findByIdAndDeleted(id, true);
    }

    @NotNull
    public List<Post> getByChannelIds(@NotNull Collection<ChannelId> channelIds, @NotNull AuthorizationContext authContext, boolean pinnedOnly, int limit) {
        Intrinsics.checkNotNullParameter(channelIds, (String)"channelIds");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        List channelIdsReadable = authContext.filterReadable(channelIds);
        if (pinnedOnly) {
            Collection collection = channelIdsReadable;
            PageRequest pageRequest = PageRequest.of((int)0, (int)limit);
            Intrinsics.checkNotNullExpressionValue((Object)pageRequest, (String)"of(\n                    0, limit\n                )");
            List list = this.postRepo.findByChannelIdInAndPinnedTrueAndPublishedTrueAndDeletedFalseOrderByPublishDateDesc(collection, (Pageable)pageRequest).getContent();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"postRepo.findByChannelId\u2026  )\n            ).content");
            return list;
        }
        Collection collection = channelIdsReadable;
        PageRequest pageRequest = PageRequest.of((int)0, (int)limit);
        Intrinsics.checkNotNullExpressionValue((Object)pageRequest, (String)"of(\n                0, limit\n            )");
        List list = this.postRepo.findByChannelIdInAndPublishedTrueAndDeletedFalseOrderByPublishDateDesc(collection, (Pageable)pageRequest).getContent();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"postRepo.findByChannelId\u2026      )\n        ).content");
        return list;
    }

    public static /* synthetic */ List getByChannelIds$default(PostService postService, Collection collection, AuthorizationContext authorizationContext, boolean bl, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getByChannelIds");
        }
        if ((n2 & 4) != 0) {
            bl = false;
        }
        if ((n2 & 8) != 0) {
            n = 8;
        }
        return postService.getByChannelIds(collection, authorizationContext, bl, n);
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    @Unauthorized
    @NotNull
    public List<Post> publishScheduledPosts() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.postRepo.findPostsToPublish();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Post post = (Post)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Post.copy$default((Post)it, null, null, null, null, null, null, null, null, null, (boolean)false, (boolean)false, null, null, (boolean)true, (int)8191, null));
        }
        List it = (List)destination$iv$iv;
        boolean bl = false;
        Iterable iterable2 = this.postRepo.saveAll((Iterable)it);
        Intrinsics.checkNotNullExpressionValue((Object)iterable2, (String)"postRepo\n            .fi\u2026 { postRepo.saveAll(it) }");
        List publishedPosts = CollectionsKt.toList((Iterable)iterable2);
        this.transactionSupport.afterCommit((Function0)new /* Unavailable Anonymous Inner Class!! */);
        return publishedPosts;
    }

    @NotNull
    public PostTranslation translatePost(@NotNull PostId postId, @NotNull String title, @NotNull String text, @NotNull TranslationLanguage targetLanguage, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)targetLanguage, (String)"targetLanguage");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        authContext.checkRead((ItemId)postId);
        String string = this.tenantRepo.getById(authContext.getTenantId()).getDeeplKey();
        if (string == null) {
            throw new IllegalArgumentException("This Tenant has no deeplKey.");
        }
        String deeplKey = string;
        String titleTranslated = this.translationConnector.translateText(title, targetLanguage, deeplKey);
        String textTranslated = this.translationConnector.translateHtml(text, targetLanguage, deeplKey);
        return new PostTranslation(postId, targetLanguage, text, textTranslated, title, titleTranslated);
    }

    /*
     * WARNING - void declaration
     */
    private void insertPoll(Poll poll, List<PollAnswer> pollAnswers, PostId postId) {
        void $this$mapTo$iv$iv;
        this.pollRepo.insert(poll.getId(), poll.getQuestion(), poll.getAllowMultipleAnswers(), postId);
        Iterable $this$map$iv = pollAnswers;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void answer;
            PollAnswer pollAnswer = (PollAnswer)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            this.pollAnswerRepo.insert(answer.getId(), answer.getText(), answer.getPosition(), answer.getPollId());
            collection.add(Unit.INSTANCE);
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private void sendNotifications(Post post, TenantId tenantId) {
        try {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            Iterable $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            ChannelSubscription it;
            Iterable $this$filterTo$iv$iv2;
            Iterable $this$filter$iv2;
            Iterable iterable = this.subscriptionRepoWrapper.getSubscriptions(post.getChannelId());
            boolean $i$f$filter = false;
            void var6_6 = $this$filter$iv2;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                it = (ChannelSubscription)element$iv$iv;
                boolean bl = false;
                if (!it.getNotificationsEnabled()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv2 = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv2 = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (ChannelSubscription)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getProfileId());
            }
            $this$map$iv = (List)destination$iv$iv;
            $i$f$filter = false;
            $this$mapTo$iv$iv = $this$filter$iv2;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                it = (ProfileId)element$iv$iv;
                boolean bl = false;
                if (!(!Intrinsics.areEqual((Object)it, (Object)post.getAuthorId()))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List channelSubscribers = (List)destination$iv$iv;
            Profile author = this.profileRepo.getById(post.getAuthorId());
            this.notificationConnector.newPost(tenantId, post, author, (Collection)channelSubscribers);
            $this$filterTo$iv$iv2 = QuillUtils.Companion.extractMentions(post.getJsonContent());
            boolean $i$f$filter2 = false;
            void $i$f$filterTo2 = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo3 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                UserId it2 = (UserId)element$iv$iv;
                boolean bl = false;
                if (!(!CollectionsKt.contains((Iterable)channelSubscribers, (Object)it2))) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List mentions = (List)destination$iv$iv2;
            this.notificationConnector.mentionedInPost(tenantId, post, author, (Collection)mentions);
        }
        catch (Exception exception) {
            log.error("Error sending notifications for Post.", (Throwable)exception);
        }
    }

    private void sendMentionNotifications(Collection<? extends UserId> mentions, Post post, TenantId tenantId) {
        try {
            Profile author = this.profileRepo.getById(post.getAuthorId());
            this.notificationConnector.mentionedInPost(tenantId, post, author, mentions);
        }
        catch (Exception exception) {
            log.error("Error sending notifications for mentions in Post.", (Throwable)exception);
        }
    }

    private Function3<PostRepo, ChannelId, Pageable, Page<Post>> getMatchingChannelQuery(boolean scheduled, boolean pinned) {
        return scheduled && pinned ? (Function3)getMatchingChannelQuery.1.INSTANCE : (scheduled && !pinned ? (Function3)getMatchingChannelQuery.2.INSTANCE : (!scheduled && pinned ? (Function3)getMatchingChannelQuery.3.INSTANCE : (Function3)getMatchingChannelQuery.4.INSTANCE));
    }

    private Function3<PostRepo, List<ChannelId>, Pageable, Page<Post>> getMatchingFeedQuery(boolean pinned) {
        return pinned ? (Function3)getMatchingFeedQuery.1.INSTANCE : (Function3)getMatchingFeedQuery.2.INSTANCE;
    }

    private void checkCoverInAttachments(AttachmentInput input) {
        DocumentId coverElementId;
        AttachmentInput attachmentInput = input;
        if ((attachmentInput != null ? attachmentInput.getCoverElementId() : null) == null) {
            return;
        }
        List attachmentIds = input.component1();
        if (!CollectionsKt.contains((Iterable)attachmentIds, (Object)(coverElementId = input.component2()))) {
            boolean bl = false;
            String string = StringsKt.trimMargin$default((String)("\n                |You tried to set attachment with id " + coverElementId + " as cover element,\n                |but this attachment was not included in the attachment array.\n                |Submitted attachment ids: " + attachmentIds + ". \n            "), null, (int)1, null);
            throw new IllegalArgumentException(string.toString());
        }
    }

    public static final /* synthetic */ PermissionKafkaProducer access$getPermissionKafkaProducer$p(PostService $this) {
        return $this.permissionKafkaProducer;
    }

    public static final /* synthetic */ ApplicationEventPublisher access$getEventPublisher$p(PostService $this) {
        return $this.eventPublisher;
    }

    public static final /* synthetic */ void access$sendNotifications(PostService $this, Post post, TenantId tenantId) {
        $this.sendNotifications(post, tenantId);
    }

    public static final /* synthetic */ void access$sendMentionNotifications(PostService $this, Collection mentions, Post post, TenantId tenantId) {
        $this.sendMentionNotifications(mentions, post, tenantId);
    }

    public static final /* synthetic */ Function3 access$getMatchingChannelQuery(PostService $this, boolean scheduled, boolean pinned) {
        return $this.getMatchingChannelQuery(scheduled, pinned);
    }

    public static final /* synthetic */ PostRepo access$getPostRepo$p(PostService $this) {
        return $this.postRepo;
    }

    public static final /* synthetic */ ChannelRepo access$getChannelRepo$p(PostService $this) {
        return $this.channelRepo;
    }

    static {
        Logger logger = LoggerFactory.getLogger(PostService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(PostService::class.java)");
        log = logger;
    }
}

