/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.domain.poll;

import de.justsoftware.news.PollAnswerId;
import de.justsoftware.news.PollId;
import de.justsoftware.news.PollVoteId;
import de.justsoftware.news.PostId;
import de.justsoftware.news.auth.AuthorizationContext;
import de.justsoftware.news.domain.poll.Poll;
import de.justsoftware.news.domain.poll.PollAnswer;
import de.justsoftware.news.domain.poll.PollAnswerRepo;
import de.justsoftware.news.domain.poll.PollRepo;
import de.justsoftware.news.domain.poll.PollVote;
import de.justsoftware.news.domain.poll.PollVoteRepo;
import de.justsoftware.news.util.Unauthorized;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0017J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\n2\u0006\u0010\u0014\u001a\u00020\u0015H\u0017J(\u0010\u0016\u001a\u0014\u0012\u0004\u0012\u00020\u0015\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\n0\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00150\u0019H\u0017J\u0010\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\rH\u0017J&\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00150\n2\u0006\u0010\u001f\u001a\u00020 H\u0017R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lde/justsoftware/news/domain/poll/PollService;", "", "pollRepo", "Lde/justsoftware/news/domain/poll/PollRepo;", "pollAnswerRepo", "Lde/justsoftware/news/domain/poll/PollAnswerRepo;", "pollVoteRepo", "Lde/justsoftware/news/domain/poll/PollVoteRepo;", "(Lde/justsoftware/news/domain/poll/PollRepo;Lde/justsoftware/news/domain/poll/PollAnswerRepo;Lde/justsoftware/news/domain/poll/PollVoteRepo;)V", "findAnswersByPollId", "", "Lde/justsoftware/news/domain/poll/PollAnswer;", "pollId", "Lde/justsoftware/news/PollId;", "findPollByPostId", "Lde/justsoftware/news/domain/poll/Poll;", "postId", "Lde/justsoftware/news/PostId;", "findVotesByAnswerId", "Lde/justsoftware/news/domain/poll/PollVote;", "pollAnswerId", "Lde/justsoftware/news/PollAnswerId;", "findVotesToAnswerIds", "", "pollAnswerIds", "", "getById", "id", "replaceVotesByPollIdAndProfileId", "", "yesAnswers", "authContext", "Lde/justsoftware/news/auth/AuthorizationContext;", "news-service"})
public class PollService {
    @NotNull
    private final PollRepo pollRepo;
    @NotNull
    private final PollAnswerRepo pollAnswerRepo;
    @NotNull
    private final PollVoteRepo pollVoteRepo;

    public PollService(@NotNull PollRepo pollRepo, @NotNull PollAnswerRepo pollAnswerRepo, @NotNull PollVoteRepo pollVoteRepo) {
        Intrinsics.checkNotNullParameter((Object)pollRepo, (String)"pollRepo");
        Intrinsics.checkNotNullParameter((Object)pollAnswerRepo, (String)"pollAnswerRepo");
        Intrinsics.checkNotNullParameter((Object)pollVoteRepo, (String)"pollVoteRepo");
        this.pollRepo = pollRepo;
        this.pollAnswerRepo = pollAnswerRepo;
        this.pollVoteRepo = pollVoteRepo;
    }

    @Transactional
    public void replaceVotesByPollIdAndProfileId(@NotNull PollId pollId, @NotNull List<PollAnswerId> yesAnswers, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)pollId, (String)"pollId");
        Intrinsics.checkNotNullParameter(yesAnswers, (String)"yesAnswers");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        this.pollVoteRepo.deleteAllByPollIdAndProfileId(pollId, authContext.getUser());
        Iterable $this$forEach$iv = yesAnswers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PollAnswerId it = (PollAnswerId)element$iv;
            boolean bl = false;
            this.pollVoteRepo.insert(PollVoteId.Companion.random(), pollId, it, authContext.getUser());
        }
    }

    @Unauthorized
    @NotNull
    public Poll getById(@NotNull PollId id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return this.pollRepo.getById(id);
    }

    @Unauthorized
    @Nullable
    public Poll findPollByPostId(@NotNull PostId postId) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        return this.pollRepo.findByPostId(postId);
    }

    @Unauthorized
    @NotNull
    public List<PollAnswer> findAnswersByPollId(@NotNull PollId pollId) {
        Intrinsics.checkNotNullParameter((Object)pollId, (String)"pollId");
        return this.pollAnswerRepo.findAllByPollId(pollId);
    }

    @Unauthorized
    @NotNull
    public List<PollVote> findVotesByAnswerId(@NotNull PollAnswerId pollAnswerId) {
        Intrinsics.checkNotNullParameter((Object)pollAnswerId, (String)"pollAnswerId");
        return this.pollVoteRepo.findByAnswerId(pollAnswerId);
    }

    /*
     * WARNING - void declaration
     */
    @Unauthorized
    @NotNull
    public Map<PollAnswerId, List<PollVote>> findVotesToAnswerIds(@NotNull Set<PollAnswerId> pollAnswerIds) {
        Intrinsics.checkNotNullParameter(pollAnswerIds, (String)"pollAnswerIds");
        Set pollVotes = this.pollVoteRepo.findByAnswerIdIn(pollAnswerIds);
        Iterable $this$associateWith$iv = pollAnswerIds;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void $this$filterTo$iv$iv;
            PollAnswerId pollAnswerId = (PollAnswerId)element$iv$iv;
            Object t = element$iv$iv;
            Map map = result$iv;
            boolean bl = false;
            Iterable $this$filter$iv = pollVotes;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
                void pollAnswerId2;
                PollVote it = (PollVote)element$iv$iv2;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)it.getAnswerId(), (Object)pollAnswerId2)) continue;
                destination$iv$iv.add(element$iv$iv2);
            }
            List list = (List)destination$iv$iv;
            map.put(t, list);
        }
        return result$iv;
    }
}

