/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.domain.poll;

import com.netflix.graphql.dgs.DgsComponent;
import com.netflix.graphql.dgs.DgsData;
import com.netflix.graphql.dgs.DgsDataFetchingEnvironment;
import com.netflix.graphql.dgs.DgsMutation;
import com.netflix.graphql.dgs.InputArgument;
import com.netflix.graphql.dgs.context.DgsContext;
import de.justsoftware.news.PollAnswerId;
import de.justsoftware.news.PollId;
import de.justsoftware.news.ProfileId;
import de.justsoftware.news.auth.AuthorizationContext;
import de.justsoftware.news.domain.poll.Poll;
import de.justsoftware.news.domain.poll.PollAnswerDataLoader;
import de.justsoftware.news.domain.poll.PollDataFetcherKt;
import de.justsoftware.news.domain.poll.PollService;
import de.justsoftware.news.domain.poll.PollVoteDataLoader;
import de.justsoftware.news.domain.poll.VotersDataLoader;
import de.justsoftware.news.graphql.generated.types.PollAnswer;
import de.justsoftware.news.graphql.generated.types.Profile;
import graphql.schema.DataFetchingEnvironment;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.dataloader.DataLoader;
import org.jetbrains.annotations.NotNull;

@DgsComponent
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0017J*\u0010\n\u001a\u00020\u000b2\b\b\u0001\u0010\f\u001a\u00020\r2\u000e\b\u0001\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\b\u001a\u00020\tH\u0017J\u001c\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u000f0\u00062\u0006\u0010\b\u001a\u00020\tH\u0017J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u00062\u0006\u0010\b\u001a\u00020\tH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lde/justsoftware/news/domain/poll/PollDataFetcher;", "", "pollService", "Lde/justsoftware/news/domain/poll/PollService;", "(Lde/justsoftware/news/domain/poll/PollService;)V", "answers", "Ljava/util/concurrent/CompletableFuture;", "Lde/justsoftware/news/graphql/generated/types/PollAnswer;", "dfe", "Lcom/netflix/graphql/dgs/DgsDataFetchingEnvironment;", "votePoll", "Lde/justsoftware/news/graphql/generated/types/Poll;", "pollId", "Lde/justsoftware/news/PollId;", "yesAnswers", "", "Lde/justsoftware/news/PollAnswerId;", "voters", "Lde/justsoftware/news/graphql/generated/types/Profile;", "votes", "Lde/justsoftware/news/ProfileId;", "news-service"})
public class PollDataFetcher {
    @NotNull
    private final PollService pollService;

    public PollDataFetcher(@NotNull PollService pollService) {
        Intrinsics.checkNotNullParameter((Object)pollService, (String)"pollService");
        this.pollService = pollService;
    }

    @DgsData(parentType="Poll", field="answers")
    @NotNull
    public CompletableFuture<PollAnswer> answers(@NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        DataLoader dataLoader = dfe.getDataLoader(PollAnswerDataLoader.class);
        PollId pollId = ((de.justsoftware.news.graphql.generated.types.Poll)dfe.getSource()).getId();
        CompletableFuture completableFuture = dataLoader.load((Object)pollId);
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"dataLoader.load(pollId)");
        return completableFuture;
    }

    @DgsData(parentType="PollAnswer", field="votes")
    @NotNull
    public CompletableFuture<ProfileId> votes(@NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        DataLoader dataLoader = dfe.getDataLoader(PollVoteDataLoader.class);
        PollAnswerId pollAnswerId = ((PollAnswer)dfe.getSource()).getId();
        CompletableFuture completableFuture = dataLoader.load((Object)pollAnswerId);
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"dataLoader.load(pollAnswerId)");
        return completableFuture;
    }

    @DgsData(parentType="PollAnswer", field="voters")
    @NotNull
    public CompletableFuture<List<Profile>> voters(@NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        PollAnswerId pollAnswerId = ((PollAnswer)dfe.getSource()).getId();
        DataLoader dataLoader = dfe.getDataLoader(VotersDataLoader.class);
        CompletableFuture completableFuture = dataLoader.load((Object)pollAnswerId);
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"dataLoader.load(pollAnswerId)");
        return completableFuture;
    }

    @DgsMutation(field="votePoll")
    @NotNull
    public de.justsoftware.news.graphql.generated.types.Poll votePoll(@InputArgument @NotNull PollId pollId, @InputArgument @NotNull List<PollAnswerId> yesAnswers, @NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)pollId, (String)"pollId");
        Intrinsics.checkNotNullParameter(yesAnswers, (String)"yesAnswers");
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        AuthorizationContext authContext = (AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe);
        this.pollService.replaceVotesByPollIdAndProfileId(pollId, yesAnswers, authContext);
        return PollDataFetcherKt.toGql((Poll)this.pollService.getById(pollId));
    }
}

