/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.domain.config;

import com.netflix.graphql.dgs.DgsComponent;
import com.netflix.graphql.dgs.DgsData;
import com.netflix.graphql.dgs.DgsDataFetchingEnvironment;
import com.netflix.graphql.dgs.DgsQuery;
import com.netflix.graphql.dgs.context.DgsContext;
import de.justsoftware.news.ProfileId;
import de.justsoftware.news.auth.AuthorizationContext;
import de.justsoftware.news.domain.tenant.Tenant;
import de.justsoftware.news.domain.tenant.TenantService;
import de.justsoftware.news.domain.user.ProfileDataLoader;
import de.justsoftware.news.graphql.UnresolvedPlaceholdersKt;
import de.justsoftware.news.graphql.generated.types.Config;
import de.justsoftware.news.graphql.generated.types.Profile;
import graphql.schema.DataFetchingEnvironment;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.dataloader.DataLoader;
import org.jetbrains.annotations.NotNull;

@DgsComponent
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0017J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0017J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0007\u001a\u00020\bH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lde/justsoftware/news/domain/config/ConfigDataFetcher;", "", "tenantService", "Lde/justsoftware/news/domain/tenant/TenantService;", "(Lde/justsoftware/news/domain/tenant/TenantService;)V", "config", "Lde/justsoftware/news/graphql/generated/types/Config;", "dfe", "Lcom/netflix/graphql/dgs/DgsDataFetchingEnvironment;", "translationEnabled", "", "user", "Ljava/util/concurrent/CompletableFuture;", "Lde/justsoftware/news/graphql/generated/types/Profile;", "news-service"})
public class ConfigDataFetcher {
    @NotNull
    private final TenantService tenantService;

    public ConfigDataFetcher(@NotNull TenantService tenantService) {
        Intrinsics.checkNotNullParameter((Object)tenantService, (String)"tenantService");
        this.tenantService = tenantService;
    }

    @DgsQuery(field="config")
    @NotNull
    public Config config(@NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        AuthorizationContext authContext = (AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe);
        return new Config("CONFIG", authContext.mayCreateChannel(), authContext.mayVisitNonActiveProfile(), false, UnresolvedPlaceholdersKt.getUNRESOLVED_PROFILE());
    }

    @DgsData(parentType="Config", field="translationEnabled")
    public boolean translationEnabled(@NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        AuthorizationContext authContext = (AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe);
        Tenant tenant = this.tenantService.findById(authContext.getTenantId());
        return (tenant != null ? tenant.getDeeplKey() : null) != null;
    }

    @DgsData(parentType="Config", field="user")
    @NotNull
    public CompletableFuture<Profile> user(@NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        DataLoader dataLoader = dfe.getDataLoader(ProfileDataLoader.class);
        ProfileId profileId = ((AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe)).getUser();
        CompletableFuture completableFuture = dataLoader.load((Object)profileId);
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"dataLoader.load(profileId)");
        return completableFuture;
    }
}

