/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.domain.comment;

import de.justsoftware.news.CommentId;
import de.justsoftware.news.ItemId;
import de.justsoftware.news.PostId;
import de.justsoftware.news.ProfileId;
import de.justsoftware.news.TenantId;
import de.justsoftware.news.UserId;
import de.justsoftware.news.auth.AuthorizationContext;
import de.justsoftware.news.connector.notification.NotificationConnector;
import de.justsoftware.news.domain.comment.PostComment;
import de.justsoftware.news.domain.comment.PostCommentRepo;
import de.justsoftware.news.domain.comment.PostCommentService;
import de.justsoftware.news.domain.post.Post;
import de.justsoftware.news.domain.post.PostRepo;
import de.justsoftware.news.domain.reaction.Reaction;
import de.justsoftware.news.domain.reaction.ReactionRepo;
import de.justsoftware.news.domain.user.Profile;
import de.justsoftware.news.domain.user.ProfileRepo;
import de.justsoftware.news.util.QuillUtils;
import de.justsoftware.news.util.Sort;
import de.justsoftware.news.util.Unauthorized;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Service
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u0000 02\u00020\u0001:\u00010B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ2\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J(\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u001e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020 H\u0017J0\u0010!\u001a\u0014\u0012\u0004\u0012\u00020\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\u001e0\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00120\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0017J\"\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020%0\"2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00100'H\u0017J&\u0010(\u001a\u00020)2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020,0+2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010-\u001a\u00020.H\u0012J*\u0010/\u001a\u00020)2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00142\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0012R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lde/justsoftware/news/domain/comment/PostCommentService;", "", "notificationConnector", "Lde/justsoftware/news/connector/notification/NotificationConnector;", "commentRepo", "Lde/justsoftware/news/domain/comment/PostCommentRepo;", "postRepo", "Lde/justsoftware/news/domain/post/PostRepo;", "profileRepo", "Lde/justsoftware/news/domain/user/ProfileRepo;", "reactionRepo", "Lde/justsoftware/news/domain/reaction/ReactionRepo;", "(Lde/justsoftware/news/connector/notification/NotificationConnector;Lde/justsoftware/news/domain/comment/PostCommentRepo;Lde/justsoftware/news/domain/post/PostRepo;Lde/justsoftware/news/domain/user/ProfileRepo;Lde/justsoftware/news/domain/reaction/ReactionRepo;)V", "createComment", "Lde/justsoftware/news/domain/comment/PostComment;", "postId", "Lde/justsoftware/news/PostId;", "parentId", "Lde/justsoftware/news/ItemId;", "text", "", "jsonContent", "authContext", "Lde/justsoftware/news/auth/AuthorizationContext;", "deleteComment", "Lde/justsoftware/news/CommentId;", "commentId", "editComment", "id", "findAllByPostId", "", "sort", "Lde/justsoftware/news/util/Sort;", "findNestedCommentsByParent", "", "parentIds", "getCommentCount", "", "postIds", "", "sendMentionNotifications", "", "mentions", "", "Lde/justsoftware/news/UserId;", "tenantId", "Lde/justsoftware/news/TenantId;", "sendNotifications", "Companion", "news-service"})
public class PostCommentService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final NotificationConnector notificationConnector;
    @NotNull
    private final PostCommentRepo commentRepo;
    @NotNull
    private final PostRepo postRepo;
    @NotNull
    private final ProfileRepo profileRepo;
    @NotNull
    private final ReactionRepo reactionRepo;
    @NotNull
    private static final Logger log;

    public PostCommentService(@NotNull NotificationConnector notificationConnector, @NotNull PostCommentRepo commentRepo, @NotNull PostRepo postRepo, @NotNull ProfileRepo profileRepo, @NotNull ReactionRepo reactionRepo) {
        Intrinsics.checkNotNullParameter((Object)notificationConnector, (String)"notificationConnector");
        Intrinsics.checkNotNullParameter((Object)commentRepo, (String)"commentRepo");
        Intrinsics.checkNotNullParameter((Object)postRepo, (String)"postRepo");
        Intrinsics.checkNotNullParameter((Object)profileRepo, (String)"profileRepo");
        Intrinsics.checkNotNullParameter((Object)reactionRepo, (String)"reactionRepo");
        this.notificationConnector = notificationConnector;
        this.commentRepo = commentRepo;
        this.postRepo = postRepo;
        this.profileRepo = profileRepo;
        this.reactionRepo = reactionRepo;
    }

    @NotNull
    public PostComment createComment(@NotNull PostId postId, @Nullable ItemId parentId, @NotNull String text, @NotNull String jsonContent, @NotNull AuthorizationContext authContext) {
        ItemId itemId;
        ItemId itemId2;
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)jsonContent, (String)"jsonContent");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        authContext.checkRead((ItemId)postId);
        CommentId commentId = CommentId.Companion.random();
        Instant now = Instant.now();
        PostCommentRepo postCommentRepo = this.commentRepo;
        ItemId itemId3 = parentId;
        if (itemId3 == null) {
            itemId3 = itemId2 = (ItemId)postId;
        }
        if ((itemId = parentId) == null) {
            itemId = (ItemId)postId;
        }
        ItemId itemId4 = itemId;
        ProfileId profileId = authContext.getUser();
        ProfileId profileId2 = authContext.getUser();
        Intrinsics.checkNotNullExpressionValue((Object)now, (String)"now");
        postCommentRepo.insert(commentId, postId, itemId2, itemId4, profileId, now, now, profileId2, jsonContent, text);
        CompletableFuture.runAsync(() -> PostCommentService.createComment$lambda-0(this, postId, jsonContent, parentId, authContext));
        return this.commentRepo.getById(commentId);
    }

    @NotNull
    public PostComment editComment(@NotNull CommentId id, @NotNull String text, @NotNull String jsonContent, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)jsonContent, (String)"jsonContent");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        PostComment origin = this.commentRepo.getById(id);
        authContext.checkUserEqual(origin.getAuthorId());
        Instant instant = Instant.now();
        ProfileId profileId = authContext.getUser();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now()");
        PostComment update = PostComment.copy$default((PostComment)origin, null, null, null, null, null, null, (Instant)instant, (ProfileId)profileId, (String)jsonContent, (String)text, (boolean)false, null, null, (int)7231, null);
        this.commentRepo.save((Object)update);
        CompletableFuture.runAsync(() -> PostCommentService.editComment$lambda-1(origin, update, this, authContext));
        return update;
    }

    @Unauthorized
    @NotNull
    public List<PostComment> findAllByPostId(@NotNull PostId postId, @NotNull Sort sort) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        Intrinsics.checkNotNullParameter((Object)sort, (String)"sort");
        return this.commentRepo.findAllByParentId((ItemId)postId, sort);
    }

    /*
     * WARNING - void declaration
     */
    @Unauthorized
    @NotNull
    public Map<ItemId, List<PostComment>> findNestedCommentsByParent(@NotNull List<? extends ItemId> parentIds, @NotNull Sort sort) {
        Intrinsics.checkNotNullParameter(parentIds, (String)"parentIds");
        Intrinsics.checkNotNullParameter((Object)sort, (String)"sort");
        if (parentIds.isEmpty()) {
            return MapsKt.emptyMap();
        }
        Set comments = this.commentRepo.findAllByParentIdIn(parentIds, sort);
        Iterable $this$associateWith$iv = parentIds;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void $this$filterTo$iv$iv;
            ItemId itemId = (ItemId)element$iv$iv;
            Object t = element$iv$iv;
            Map map = result$iv;
            boolean bl = false;
            Iterable $this$filter$iv = comments;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
                void id;
                PostComment it = (PostComment)element$iv$iv2;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)it.getParentId(), (Object)id)) continue;
                destination$iv$iv.add(element$iv$iv2);
            }
            List list = (List)destination$iv$iv;
            map.put(t, list);
        }
        return result$iv;
    }

    @NotNull
    public CommentId deleteComment(@NotNull CommentId commentId, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)commentId, (String)"commentId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        this.commentRepo.findById((Object)commentId).ifPresent(arg_0 -> PostCommentService.deleteComment$lambda-4(this, authContext, arg_0));
        return commentId;
    }

    /*
     * WARNING - void declaration
     */
    @Unauthorized
    @NotNull
    public Map<PostId, Integer> getCommentCount(@NotNull Set<PostId> postIds) {
        void $this$associateTo$iv$iv;
        void $this$associate$iv;
        Object object;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(postIds, (String)"postIds");
        Iterable $this$map$iv = postIds;
        boolean $i$f$map22 = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Iterator it;
            PostId postId = (PostId)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(it.toTypedString());
        }
        Set stringIds = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Iterable $i$f$map22 = this.commentRepo.commentCountByPostIds(stringIds);
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        void $i$f$mapTo22 = $this$associate$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv2 : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv2;
            Pair it = (Pair)element$iv$iv2;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)it.getFirst(), (Object)it.getSecond());
            map.put(pair.getFirst(), pair.getSecond());
        }
        Map counts = destination$iv$iv2;
        Iterable $this$associateWith$iv = postIds;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void it;
            PostId element$iv$iv2 = (PostId)element$iv$iv;
            Object t = element$iv$iv;
            object = result$iv;
            boolean bl = false;
            Integer n = ((Number)counts.getOrDefault(it, 0)).intValue();
            object.put(t, n);
        }
        return result$iv;
    }

    /*
     * WARNING - void declaration
     */
    private void sendNotifications(PostId postId, String jsonContent, ItemId parentId, AuthorizationContext authContext) {
        try {
            Post post = this.postRepo.getByIdAndDeletedFalse(postId);
            Profile commentAuthor = this.profileRepo.getById(authContext.getUser());
            if (parentId instanceof CommentId) {
                void $this$filterTo$iv$iv;
                void $this$filter$iv;
                void $this$filterTo$iv$iv2;
                void $this$filter$iv2;
                Collection collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                ProfileId initialCommentAuthor = this.commentRepo.getById((CommentId)parentId).getAuthorId();
                Iterable iterable = this.commentRepo.findAllByParentIdOrderByCreatedAtAsc(parentId);
                boolean $i$f$map22 = false;
                void var11_18 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    PostComment postComment = (PostComment)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.getAuthorId());
                }
                List otherAnsweringAuthors = (List)destination$iv$iv;
                Set receivers = SetsKt.plus((Set)SetsKt.setOf((Object)initialCommentAuthor), (Iterable)otherAnsweringAuthors);
                Iterable $i$f$map22 = receivers;
                Profile profile = commentAuthor;
                Post post2 = post;
                TenantId tenantId = authContext.getTenantId();
                collection = this.notificationConnector;
                boolean $i$f$filter22 = false;
                destination$iv$iv = $this$filter$iv2;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                    ProfileId it = (ProfileId)element$iv$iv;
                    boolean bl = false;
                    if (!(!Intrinsics.areEqual((Object)it, (Object)authContext.getUser()))) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                List list = (List)destination$iv$iv2;
                collection.newCommentResponse(tenantId, post2, profile, list);
                Iterable $i$f$filter22 = QuillUtils.Companion.extractMentions(jsonContent);
                boolean $i$f$filter = false;
                destination$iv$iv2 = $this$filter$iv;
                Collection destination$iv$iv3 = new ArrayList();
                boolean $i$f$filterTo2 = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    UserId it = (UserId)element$iv$iv;
                    boolean bl = false;
                    if (!(!CollectionsKt.contains((Iterable)receivers, (Object)it))) continue;
                    destination$iv$iv3.add(element$iv$iv);
                }
                List mentions = (List)destination$iv$iv3;
                this.notificationConnector.mentionedInComment(authContext.getTenantId(), post, commentAuthor, (Collection)mentions);
            } else {
                void $this$filterTo$iv$iv;
                void $this$filter$iv;
                void $this$filterTo$iv$iv3;
                void $this$filter$iv3;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Collection collection;
                void $this$mapTo$iv$iv2;
                Iterable $this$map$iv2 = this.reactionRepo.findAllByItemId((ItemId)postId);
                boolean $i$f$map32 = false;
                Iterable mentions = $this$map$iv2;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    void it;
                    Reaction $i$f$filterTo2 = (Reaction)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.getProfileId());
                }
                List likers = (List)destination$iv$iv;
                Iterable $i$f$map32 = this.commentRepo.findAllByParentIdOrderByCreatedAtAsc((ItemId)postId);
                boolean $i$f$map42 = false;
                destination$iv$iv = $this$map$iv;
                Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    PostComment bl = (PostComment)item$iv$iv;
                    collection = destination$iv$iv4;
                    boolean bl2 = false;
                    collection.add(it.getAuthorId());
                }
                List commentators = (List)destination$iv$iv4;
                List receivers = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)likers, (Iterable)commentators), (Iterable)SetsKt.setOf((Object)post.getAuthorId()));
                Iterable $i$f$map42 = receivers;
                Profile profile = commentAuthor;
                Post post3 = post;
                TenantId tenantId = authContext.getTenantId();
                collection = this.notificationConnector;
                boolean $i$f$filter32 = false;
                destination$iv$iv4 = $this$filter$iv3;
                Collection destination$iv$iv5 = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv3) {
                    ProfileId it = (ProfileId)element$iv$iv;
                    boolean bl = false;
                    if (!(!Intrinsics.areEqual((Object)it, (Object)authContext.getUser()))) continue;
                    destination$iv$iv5.add(element$iv$iv);
                }
                List list = (List)destination$iv$iv5;
                collection.newPostComment(tenantId, post3, profile, list);
                Iterable $i$f$filter32 = QuillUtils.Companion.extractMentions(jsonContent);
                boolean $i$f$filter = false;
                destination$iv$iv5 = $this$filter$iv;
                Collection destination$iv$iv6 = new ArrayList();
                boolean $i$f$filterTo3 = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    UserId it = (UserId)element$iv$iv;
                    boolean bl = false;
                    if (!(!CollectionsKt.contains((Iterable)receivers, (Object)it))) continue;
                    destination$iv$iv6.add(element$iv$iv);
                }
                List mentions2 = (List)destination$iv$iv6;
                this.notificationConnector.mentionedInComment(authContext.getTenantId(), post, commentAuthor, (Collection)mentions2);
            }
        }
        catch (Exception exception) {
            log.error("Error while sending Notification for new Comment.", (Throwable)exception);
        }
    }

    private void sendMentionNotifications(Collection<? extends UserId> mentions, PostId postId, TenantId tenantId) {
        try {
            Post post = this.postRepo.getByIdAndDeletedFalse(postId);
            Profile author = this.profileRepo.getById(post.getAuthorId());
            this.notificationConnector.mentionedInComment(tenantId, post, author, mentions);
        }
        catch (Exception exception) {
            log.error("Error sending notifications for mentions in Comment.", (Throwable)exception);
        }
    }

    private static final void createComment$lambda-0(PostCommentService this$0, PostId $postId, String $jsonContent, ItemId $parentId, AuthorizationContext $authContext) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$postId, (String)"$postId");
        Intrinsics.checkNotNullParameter((Object)$jsonContent, (String)"$jsonContent");
        Intrinsics.checkNotNullParameter((Object)$authContext, (String)"$authContext");
        this$0.sendNotifications($postId, $jsonContent, $parentId, $authContext);
    }

    private static final void editComment$lambda-1(PostComment $origin, PostComment $update, PostCommentService this$0, AuthorizationContext $authContext) {
        Intrinsics.checkNotNullParameter((Object)$origin, (String)"$origin");
        Intrinsics.checkNotNullParameter((Object)$update, (String)"$update");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$authContext, (String)"$authContext");
        Set originMentions = QuillUtils.Companion.extractMentions($origin.getJsonContent());
        Set updateMentions = QuillUtils.Companion.extractMentions($update.getJsonContent());
        Set newMentions = CollectionsKt.subtract((Iterable)updateMentions, (Iterable)originMentions);
        if (!((Collection)newMentions).isEmpty()) {
            this$0.sendMentionNotifications((Collection)newMentions, $update.getPostId(), $authContext.getTenantId());
        }
    }

    private static final void deleteComment$lambda-4(PostCommentService this$0, AuthorizationContext $authContext, PostComment it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$authContext, (String)"$authContext");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Post post = this$0.postRepo.getByIdAndDeletedFalse(it.getPostId());
        $authContext.checkDeleteComment(post.getChannelId(), it.getAuthorId());
        PostCommentRepo postCommentRepo = this$0.commentRepo;
        CommentId commentId = it.getId();
        ProfileId profileId = $authContext.getUser();
        Instant instant = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now()");
        postCommentRepo.delete(commentId, profileId, instant);
    }

    static {
        Logger logger = LoggerFactory.getLogger(PostCommentService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(PostCommentService::class.java)");
        log = logger;
    }
}

