/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.domain.comment;

import de.justsoftware.news.CommentId;
import de.justsoftware.news.ItemId;
import de.justsoftware.news.PostId;
import de.justsoftware.news.ProfileId;
import de.justsoftware.news.domain.comment.CountRowMapper;
import de.justsoftware.news.domain.comment.PostComment;
import de.justsoftware.news.util.Sort;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmDefault;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.data.jdbc.repository.query.Modifying;
import org.springframework.data.jdbc.repository.query.Query;
import org.springframework.data.repository.PagingAndSortingRepository;
import org.springframework.data.repository.query.Param;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\f\bf\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001J*\u0010\u0004\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00060\u00052\u000e\b\u0001\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0005H'J&\u0010\u000b\u001a\u00020\f2\b\b\u0001\u0010\r\u001a\u00020\u00032\b\b\u0001\u0010\u000e\u001a\u00020\u000f2\b\b\u0001\u0010\u0010\u001a\u00020\u0011H'J\u001e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0017J&\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00020\u00052\u000e\b\u0001\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00150\u00132\u0006\u0010\u0016\u001a\u00020\u0017H\u0017J\u0018\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00020\u00132\b\b\u0001\u0010\u0014\u001a\u00020\u0015H&J\u0018\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00020\u00132\b\b\u0001\u0010\u0014\u001a\u00020\u0015H&J\u0012\u0010\u001c\u001a\u00020\u00022\b\b\u0001\u0010\u001d\u001a\u00020\u0003H&Jl\u0010\u001e\u001a\u00020\u001f2\b\b\u0001\u0010\u001d\u001a\u00020\u00032\b\b\u0001\u0010 \u001a\u00020\u00072\b\b\u0001\u0010!\u001a\u00020\u00152\b\b\u0001\u0010\"\u001a\u00020\u00152\b\b\u0001\u0010#\u001a\u00020\u000f2\b\b\u0001\u0010$\u001a\u00020\u00112\b\b\u0001\u0010%\u001a\u00020\u00112\b\b\u0001\u0010&\u001a\u00020\u000f2\b\b\u0001\u0010'\u001a\u00020\n2\b\b\u0001\u0010(\u001a\u00020\nH'J\u001e\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00020\u00052\u000e\b\u0001\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00150\u0005H'J\u001e\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00020\u00052\u000e\b\u0001\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00150\u0005H'\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006+\u00c0\u0006\u0001"}, d2={"Lde/justsoftware/news/domain/comment/PostCommentRepo;", "Lorg/springframework/data/repository/PagingAndSortingRepository;", "Lde/justsoftware/news/domain/comment/PostComment;", "Lde/justsoftware/news/CommentId;", "commentCountByPostIds", "", "Lkotlin/Pair;", "Lde/justsoftware/news/PostId;", "", "ids", "", "delete", "", "commentId", "deletedBy", "Lde/justsoftware/news/ProfileId;", "deletedAt", "Ljava/time/Instant;", "findAllByParentId", "", "itemId", "Lde/justsoftware/news/ItemId;", "sort", "Lde/justsoftware/news/util/Sort;", "findAllByParentIdIn", "parentIds", "findAllByParentIdOrderByCreatedAtAsc", "findAllByParentIdOrderByCreatedAtDesc", "getById", "id", "insert", "", "postId", "parentId", "referenceId", "authorId", "createdAt", "updatedAt", "lastUpdatedBy", "jsonContent", "text", "queryAllByParentIdInOrderByCreatedAtAsc", "queryAllByParentIdInOrderByCreatedAtDesc", "news-service"})
public interface PostCommentRepo
extends PagingAndSortingRepository<PostComment, CommentId> {
    @Modifying
    @Query(value="\n        INSERT INTO post_comment (id, post_id, parent_id, reference_id, author_id, created_at, updated_at, last_updated_by, json_content, text)\n        VALUES(:id, :postId, :parentId, :referenceId, :authorId, :createdAt, :updatedAt, :lastUpdatedBy, :jsonContent, :text)\n        ")
    public void insert(@Param(value="id") @NotNull CommentId var1, @Param(value="postId") @NotNull PostId var2, @Param(value="parentId") @NotNull ItemId var3, @Param(value="referenceId") @NotNull ItemId var4, @Param(value="authorId") @NotNull ProfileId var5, @Param(value="createdAt") @NotNull Instant var6, @Param(value="updatedAt") @NotNull Instant var7, @Param(value="lastUpdatedBy") @NotNull ProfileId var8, @Param(value="jsonContent") @NotNull String var9, @Param(value="text") @NotNull String var10);

    @Query(value="\n        SELECT post_id as postId, COUNT(*) as count FROM post_comment\n        WHERE post_id in (:postIds) GROUP BY post_id\n        ", rowMapperClass=CountRowMapper.class)
    @NotNull
    public Set<Pair<PostId, Integer>> commentCountByPostIds(@Param(value="postIds") @NotNull Set<String> var1);

    @NotNull
    public PostComment getById(@Param(value="id") @NotNull CommentId var1);

    @JvmDefault
    @NotNull
    default public List<PostComment> findAllByParentId(@NotNull ItemId itemId, @NotNull Sort sort) {
        Intrinsics.checkNotNullParameter((Object)itemId, (String)"itemId");
        Intrinsics.checkNotNullParameter((Object)sort, (String)"sort");
        return sort == Sort.ASC ? this.findAllByParentIdOrderByCreatedAtAsc(itemId) : this.findAllByParentIdOrderByCreatedAtDesc(itemId);
    }

    @NotNull
    public List<PostComment> findAllByParentIdOrderByCreatedAtAsc(@Param(value="parentId") @NotNull ItemId var1);

    @NotNull
    public List<PostComment> findAllByParentIdOrderByCreatedAtDesc(@Param(value="parentId") @NotNull ItemId var1);

    @Deprecated(message="Do not use this function directly. Use {@link #findAllByParentIdIn(List)} instead.")
    @NotNull
    public Set<PostComment> queryAllByParentIdInOrderByCreatedAtAsc(@Param(value="parentIds") @NotNull Set<? extends ItemId> var1);

    @Deprecated(message="Do not use this function directly. Use {@link #findAllByParentIdIn(List)} instead.")
    @NotNull
    public Set<PostComment> queryAllByParentIdInOrderByCreatedAtDesc(@Param(value="parentIds") @NotNull Set<? extends ItemId> var1);

    /*
     * WARNING - void declaration
     */
    @JvmDefault
    @NotNull
    default public Set<PostComment> findAllByParentIdIn(@Param(value="parentIds") @NotNull List<? extends ItemId> parentIds, @NotNull Sort sort) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(parentIds, (String)"parentIds");
        Intrinsics.checkNotNullParameter((Object)sort, (String)"sort");
        Iterable $this$flatMap$iv = CollectionsKt.chunked((Iterable)parentIds, (int)1000);
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List it = (List)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = sort == Sort.ASC ? this.queryAllByParentIdInOrderByCreatedAtAsc(CollectionsKt.toSet((Iterable)it)) : this.queryAllByParentIdInOrderByCreatedAtDesc(CollectionsKt.toSet((Iterable)it));
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    @Modifying
    @Query(value="\n        UPDATE post_comment\n        SET deleted = '1', deleted_by = :deletedBy, deleted_at = :deletedAt\n        WHERE id = :commentId\n        ")
    public boolean delete(@Param(value="commentId") @NotNull CommentId var1, @Param(value="deletedBy") @NotNull ProfileId var2, @Param(value="deletedAt") @NotNull Instant var3);
}

