/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.domain.channel.permission;

import de.justsoftware.news.ChannelId;
import de.justsoftware.news.ItemId;
import de.justsoftware.news.UserId;
import de.justsoftware.news.auth.AuthorizationContext;
import de.justsoftware.news.connector.permission.PermissionItem;
import de.justsoftware.news.connector.permission.PermissionKafkaProducer;
import de.justsoftware.news.domain.channel.permission.ChannelPermission;
import de.justsoftware.news.domain.channel.permission.ChannelPermissionChanges;
import de.justsoftware.news.domain.channel.permission.ChannelPermissionRepo;
import de.justsoftware.news.events.GroupDeletedEvent;
import de.justsoftware.news.events.ProfileDeletedEvent;
import de.justsoftware.news.util.TransactionSupport;
import de.justsoftware.news.util.Unauthorized;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0017J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000fH\u0017J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0017J\u0018\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lde/justsoftware/news/domain/channel/permission/ChannelPermissionService;", "", "channelPermissionRepo", "Lde/justsoftware/news/domain/channel/permission/ChannelPermissionRepo;", "permissionKafkaProducer", "Lde/justsoftware/news/connector/permission/PermissionKafkaProducer;", "transactionSupport", "Lde/justsoftware/news/util/TransactionSupport;", "eventPublisher", "Lorg/springframework/context/ApplicationEventPublisher;", "(Lde/justsoftware/news/domain/channel/permission/ChannelPermissionRepo;Lde/justsoftware/news/connector/permission/PermissionKafkaProducer;Lde/justsoftware/news/util/TransactionSupport;Lorg/springframework/context/ApplicationEventPublisher;)V", "deletePermissions", "", "event", "Lde/justsoftware/news/events/GroupDeletedEvent;", "Lde/justsoftware/news/events/ProfileDeletedEvent;", "findAllByChannelId", "", "Lde/justsoftware/news/domain/channel/permission/ChannelPermission;", "channelId", "Lde/justsoftware/news/ChannelId;", "set", "changes", "Lde/justsoftware/news/domain/channel/permission/ChannelPermissionChanges;", "authContext", "Lde/justsoftware/news/auth/AuthorizationContext;", "news-service"})
public class ChannelPermissionService {
    @NotNull
    private final ChannelPermissionRepo channelPermissionRepo;
    @NotNull
    private final PermissionKafkaProducer permissionKafkaProducer;
    @NotNull
    private final TransactionSupport transactionSupport;
    @NotNull
    private final ApplicationEventPublisher eventPublisher;

    public ChannelPermissionService(@NotNull ChannelPermissionRepo channelPermissionRepo, @NotNull PermissionKafkaProducer permissionKafkaProducer, @NotNull TransactionSupport transactionSupport, @NotNull ApplicationEventPublisher eventPublisher) {
        Intrinsics.checkNotNullParameter((Object)channelPermissionRepo, (String)"channelPermissionRepo");
        Intrinsics.checkNotNullParameter((Object)permissionKafkaProducer, (String)"permissionKafkaProducer");
        Intrinsics.checkNotNullParameter((Object)transactionSupport, (String)"transactionSupport");
        Intrinsics.checkNotNullParameter((Object)eventPublisher, (String)"eventPublisher");
        this.channelPermissionRepo = channelPermissionRepo;
        this.permissionKafkaProducer = permissionKafkaProducer;
        this.transactionSupport = transactionSupport;
        this.eventPublisher = eventPublisher;
    }

    @Unauthorized
    @NotNull
    public List<ChannelPermission> findAllByChannelId(@NotNull ChannelId channelId) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        return this.channelPermissionRepo.findAllByChannelId(channelId);
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    public void set(@NotNull ChannelPermissionChanges changes, @NotNull AuthorizationContext authContext) {
        void $this$mapTo$iv$iv;
        void $this$mapTo$iv$iv2;
        void $this$mapTo$iv$iv3;
        Object element$iv2;
        Collection collection;
        Iterator $this$mapTo$iv$iv4;
        Intrinsics.checkNotNullParameter((Object)changes, (String)"changes");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        Iterable $this$map$iv = changes.getAll();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv4.iterator();
        while (iterator.hasNext()) {
            void it;
            Object item$iv$iv = iterator.next();
            ChannelPermission channelPermission = (ChannelPermission)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getChannelId());
        }
        Set channelIds = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        authContext.checkManageAll((Collection)channelIds);
        Iterable $this$forEach$iv = changes.getAdds();
        boolean $i$f$forEach = false;
        for (Object element$iv2 : $this$forEach$iv) {
            ChannelPermission it = (ChannelPermission)element$iv2;
            boolean bl = false;
            this.channelPermissionRepo.insert(it.getId(), it.getChannelId(), it.getGranteeId(), it.getRole());
        }
        this.channelPermissionRepo.saveAll((Iterable)changes.getUpdates());
        this.channelPermissionRepo.deleteAll((Iterable)changes.getDeletes());
        Iterable $this$map$iv2 = changes.getAdds();
        boolean $i$f$map2 = false;
        element$iv2 = $this$map$iv2;
        Iterable destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv3) {
            void it;
            ChannelPermission bl = (ChannelPermission)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            collection.add(new PermissionItem((ItemId)it.getChannelId(), it.getGranteeId(), it.getRole()));
        }
        List adds = (List)destination$iv$iv2;
        Iterable $this$map$iv3 = changes.getUpdates();
        boolean $i$f$map3 = false;
        destination$iv$iv2 = $this$map$iv3;
        Iterable destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
        boolean $i$f$mapTo3 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            ChannelPermission bl2 = (ChannelPermission)item$iv$iv;
            collection = destination$iv$iv3;
            boolean bl = false;
            collection.add(new PermissionItem((ItemId)it.getChannelId(), it.getGranteeId(), it.getRole()));
        }
        List updates = (List)destination$iv$iv3;
        Iterable $this$map$iv4 = changes.getDeletes();
        boolean $i$f$map4 = false;
        destination$iv$iv3 = $this$map$iv4;
        Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv4, (int)10));
        boolean $i$f$mapTo4 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ChannelPermission bl = (ChannelPermission)item$iv$iv;
            collection = destination$iv$iv4;
            boolean bl3 = false;
            collection.add(new PermissionItem((ItemId)it.getChannelId(), it.getGranteeId(), it.getRole()));
        }
        List deletes = (List)destination$iv$iv4;
        this.transactionSupport.afterCommit((Function0)new /* Unavailable Anonymous Inner Class!! */);
    }

    @EventListener
    public void deletePermissions(@NotNull ProfileDeletedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.channelPermissionRepo.deleteByGranteeId((UserId)event.getProfileId());
    }

    @EventListener
    public void deletePermissions(@NotNull GroupDeletedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.channelPermissionRepo.deleteByGranteeId((UserId)event.getUserGroupId());
    }

    public static final /* synthetic */ PermissionKafkaProducer access$getPermissionKafkaProducer$p(ChannelPermissionService $this) {
        return $this.permissionKafkaProducer;
    }

    public static final /* synthetic */ ApplicationEventPublisher access$getEventPublisher$p(ChannelPermissionService $this) {
        return $this.eventPublisher;
    }
}

