/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.domain.channel;

import de.justsoftware.news.ChannelId;
import de.justsoftware.news.ItemId;
import de.justsoftware.news.ManagedSubscriptionId;
import de.justsoftware.news.PermissionId;
import de.justsoftware.news.TenantId;
import de.justsoftware.news.UserId;
import de.justsoftware.news.auth.AuthorizationContext;
import de.justsoftware.news.connector.permission.PermissionKafkaProducer;
import de.justsoftware.news.domain.channel.Channel;
import de.justsoftware.news.domain.channel.ChannelRepo;
import de.justsoftware.news.domain.channel.permission.ChannelPermissionRepo;
import de.justsoftware.news.domain.channel.permission.PermissionRole;
import de.justsoftware.news.domain.subscription.managed.ManagedSubscriptionRepo;
import de.justsoftware.news.domain.subscription.managed.ManagedSubscriptionType;
import de.justsoftware.news.util.TransactionSupport;
import de.justsoftware.news.util.Unauthorized;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.data.repository.CrudRepository;
import org.springframework.data.repository.CrudRepositoryExtensionsKt;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u001e\n\u0000\b\u0017\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0017J \u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0017J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00100\u00192\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J$\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00100\u00192\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00170\u00192\u0006\u0010\u001c\u001a\u00020\u001dH\u0017J\u001a\u0010\u001e\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u001a\u0010\u001f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010 \u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J$\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00100\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00170$2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lde/justsoftware/news/domain/channel/ChannelService;", "", "channelRepo", "Lde/justsoftware/news/domain/channel/ChannelRepo;", "managedSubscriptionRepo", "Lde/justsoftware/news/domain/subscription/managed/ManagedSubscriptionRepo;", "channelPermissionRepo", "Lde/justsoftware/news/domain/channel/permission/ChannelPermissionRepo;", "permissionKafkaProducer", "Lde/justsoftware/news/connector/permission/PermissionKafkaProducer;", "transactionSupport", "Lde/justsoftware/news/util/TransactionSupport;", "eventPublisher", "Lorg/springframework/context/ApplicationEventPublisher;", "(Lde/justsoftware/news/domain/channel/ChannelRepo;Lde/justsoftware/news/domain/subscription/managed/ManagedSubscriptionRepo;Lde/justsoftware/news/domain/channel/permission/ChannelPermissionRepo;Lde/justsoftware/news/connector/permission/PermissionKafkaProducer;Lde/justsoftware/news/util/TransactionSupport;Lorg/springframework/context/ApplicationEventPublisher;)V", "create", "Lde/justsoftware/news/domain/channel/Channel;", "title", "", "authContext", "Lde/justsoftware/news/auth/AuthorizationContext;", "edit", "id", "Lde/justsoftware/news/ChannelId;", "findAll", "", "findAllByIds", "channelIds", "tenantId", "Lde/justsoftware/news/TenantId;", "findById", "findByIdDeleted", "getById", "getByIds", "", "ids", "", "news-service"})
public class ChannelService {
    @NotNull
    private final ChannelRepo channelRepo;
    @NotNull
    private final ManagedSubscriptionRepo managedSubscriptionRepo;
    @NotNull
    private final ChannelPermissionRepo channelPermissionRepo;
    @NotNull
    private final PermissionKafkaProducer permissionKafkaProducer;
    @NotNull
    private final TransactionSupport transactionSupport;
    @NotNull
    private final ApplicationEventPublisher eventPublisher;

    public ChannelService(@NotNull ChannelRepo channelRepo, @NotNull ManagedSubscriptionRepo managedSubscriptionRepo, @NotNull ChannelPermissionRepo channelPermissionRepo, @NotNull PermissionKafkaProducer permissionKafkaProducer, @NotNull TransactionSupport transactionSupport, @NotNull ApplicationEventPublisher eventPublisher) {
        Intrinsics.checkNotNullParameter((Object)channelRepo, (String)"channelRepo");
        Intrinsics.checkNotNullParameter((Object)managedSubscriptionRepo, (String)"managedSubscriptionRepo");
        Intrinsics.checkNotNullParameter((Object)channelPermissionRepo, (String)"channelPermissionRepo");
        Intrinsics.checkNotNullParameter((Object)permissionKafkaProducer, (String)"permissionKafkaProducer");
        Intrinsics.checkNotNullParameter((Object)transactionSupport, (String)"transactionSupport");
        Intrinsics.checkNotNullParameter((Object)eventPublisher, (String)"eventPublisher");
        this.channelRepo = channelRepo;
        this.managedSubscriptionRepo = managedSubscriptionRepo;
        this.channelPermissionRepo = channelPermissionRepo;
        this.permissionKafkaProducer = permissionKafkaProducer;
        this.transactionSupport = transactionSupport;
        this.eventPublisher = eventPublisher;
    }

    @Transactional
    @NotNull
    public Channel create(@NotNull String title, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        authContext.checkAppWriter();
        ChannelId channelId = ChannelId.Companion.random();
        Instant now = Instant.now();
        ChannelRepo channelRepo = this.channelRepo;
        TenantId tenantId = authContext.getTenantId();
        Intrinsics.checkNotNullExpressionValue((Object)now, (String)"now");
        ChannelRepo.insert$default((ChannelRepo)channelRepo, (ChannelId)channelId, (String)title, (TenantId)tenantId, (Instant)now, (Instant)now, (boolean)false, (int)32, null);
        Channel channel = this.channelRepo.getByIdAndDeletedFalse(channelId);
        this.channelPermissionRepo.insert(PermissionId.Companion.random(), channel.getId(), (UserId)authContext.getUser(), PermissionRole.MANAGER);
        this.managedSubscriptionRepo.insert(ManagedSubscriptionId.Companion.random(), channelId, ManagedSubscriptionType.RECOMMENDED, (UserId)authContext.getUser());
        this.transactionSupport.afterCommit((Function0)new /* Unavailable Anonymous Inner Class!! */);
        return channel;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<Channel> findAll(@NotNull AuthorizationContext authContext) {
        void $this$filterTo$iv$iv;
        Channel it;
        Iterable $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        List tenantChannels = ChannelRepo.findAllByTenantIdAndDeleted$default((ChannelRepo)this.channelRepo, (TenantId)authContext.getTenantId(), (boolean)false, (int)2, null);
        Iterable iterable = tenantChannels;
        AuthorizationContext authorizationContext = authContext;
        boolean $i$f$map = false;
        void var6_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Channel channel = (Channel)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getId());
        }
        List readableChannels = authorizationContext.filterReadable((Collection)((List)destination$iv$iv));
        Iterable $this$filter$iv = tenantChannels;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Channel)element$iv$iv;
            boolean bl = false;
            if (!readableChannels.contains(it.getId())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public Channel findById(@NotNull ChannelId id, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        authContext.checkRead((ItemId)id);
        return (Channel)CrudRepositoryExtensionsKt.findByIdOrNull((CrudRepository)((CrudRepository)this.channelRepo), (Object)id);
    }

    @Nullable
    public Channel findByIdDeleted(@NotNull ChannelId id, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        authContext.checkManage((ItemId)id);
        return this.channelRepo.findByIdAndDeletedTrue(id);
    }

    @NotNull
    public Channel getById(@NotNull ChannelId id, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        authContext.checkRead((ItemId)id);
        return this.channelRepo.getByIdAndDeletedFalse(id);
    }

    @NotNull
    public Set<Channel> getByIds(@NotNull Collection<ChannelId> ids, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        List readable = authContext.filterReadable(ids);
        return this.channelRepo.getByIdInAndDeletedFalse((Collection)readable);
    }

    @Transactional
    @NotNull
    public Channel edit(@NotNull ChannelId id, @NotNull String title, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        authContext.checkWrite((ItemId)id);
        Instant instant = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now()");
        this.channelRepo.updateTitle(id, title, instant);
        this.transactionSupport.afterCommit((Function0)new /* Unavailable Anonymous Inner Class!! */);
        return this.channelRepo.getByIdAndDeletedFalse(id);
    }

    /*
     * WARNING - void declaration
     */
    @Unauthorized
    @NotNull
    public List<Channel> findAllByIds(@NotNull List<ChannelId> channelIds, @NotNull TenantId tenantId) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(channelIds, (String)"channelIds");
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Set unsortedChannels = ChannelRepo.findAllByTenantIdAndDeletedAndIdIn$default((ChannelRepo)this.channelRepo, (TenantId)tenantId, (boolean)false, channelIds, (int)2, null);
        Iterable $this$map$iv = channelIds;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Object element$iv2;
            Collection collection;
            block2: {
                ChannelId channelId = (ChannelId)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                Iterable $this$first$iv = unsortedChannels;
                boolean $i$f$first = false;
                for (Object element$iv2 : $this$first$iv) {
                    void it;
                    Channel channel = (Channel)element$iv2;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)channel.getId(), (Object)it)) continue;
                    break block2;
                }
                throw new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            collection.add((Channel)element$iv2);
        }
        return (List)destination$iv$iv;
    }

    public static final /* synthetic */ PermissionKafkaProducer access$getPermissionKafkaProducer$p(ChannelService $this) {
        return $this.permissionKafkaProducer;
    }

    public static final /* synthetic */ ApplicationEventPublisher access$getEventPublisher$p(ChannelService $this) {
        return $this.eventPublisher;
    }
}

