/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.domain.channel;

import com.netflix.graphql.dgs.DgsComponent;
import com.netflix.graphql.dgs.DgsData;
import com.netflix.graphql.dgs.DgsDataFetchingEnvironment;
import com.netflix.graphql.dgs.DgsMutation;
import com.netflix.graphql.dgs.DgsQuery;
import com.netflix.graphql.dgs.InputArgument;
import com.netflix.graphql.dgs.context.DgsContext;
import de.justsoftware.news.ChannelId;
import de.justsoftware.news.auth.AuthorizationContext;
import de.justsoftware.news.domain.channel.Channel;
import de.justsoftware.news.domain.channel.ChannelDataFetcherKt;
import de.justsoftware.news.domain.channel.ChannelService;
import de.justsoftware.news.domain.channel.ManagedSubscriptionDataLoader;
import de.justsoftware.news.domain.channel.MayCreatePostDataLoader;
import de.justsoftware.news.domain.channel.MayEditOrDeleteChannelDataLoader;
import de.justsoftware.news.domain.channel.MayReadScheduledPostsDataLoader;
import de.justsoftware.news.domain.channel.PermissionsByChannelIdDataLoader;
import de.justsoftware.news.domain.channel.SubscribersDataLoader;
import de.justsoftware.news.domain.channel.SubscriptionDataLoader;
import de.justsoftware.news.domain.delete.DeleteService;
import de.justsoftware.news.domain.subscription.ChannelSubscription;
import de.justsoftware.news.domain.subscription.ChannelSubscriptionService;
import de.justsoftware.news.graphql.generated.types.ChannelPermission;
import de.justsoftware.news.graphql.generated.types.ManagedSubscription;
import de.justsoftware.news.graphql.generated.types.Profile;
import graphql.schema.DataFetchingEnvironment;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.dataloader.DataLoader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@DgsComponent
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001a\u0010\t\u001a\u00020\n2\b\b\u0001\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0017J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u000eH\u0017J\u0010\u0010\u0012\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0017J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\n0\u00142\u0006\u0010\r\u001a\u00020\u000eH\u0017J\u0018\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u000eH\u0017J \u0010\u0016\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0017J\u001c\u0010\u0017\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u00140\u00182\u0006\u0010\r\u001a\u00020\u000eH\u0017J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00182\u0006\u0010\r\u001a\u00020\u000eH\u0017J\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00182\u0006\u0010\r\u001a\u00020\u000eH\u0017J\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00182\u0006\u0010\r\u001a\u00020\u000eH\u0017J\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00182\u0006\u0010\r\u001a\u00020\u000eH\u0017J\u001c\u0010\u001f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020 0\u00140\u00182\u0006\u0010\r\u001a\u00020\u000eH\u0017J$\u0010!\u001a\u00020\"2\b\b\u0001\u0010#\u001a\u00020\u00112\b\b\u0001\u0010$\u001a\u00020\u001b2\u0006\u0010\r\u001a\u00020\u000eH\u0017J\u001c\u0010%\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020&0\u00140\u00182\u0006\u0010\r\u001a\u00020\u000eH\u0017J\u001e\u0010'\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\"0\u00140\u00182\u0006\u0010\r\u001a\u00020\u000eH\u0017J\u001a\u0010(\u001a\u00020\n2\b\b\u0001\u0010#\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u000eH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lde/justsoftware/news/domain/channel/ChannelDataFetcher;", "", "channelService", "Lde/justsoftware/news/domain/channel/ChannelService;", "deleteService", "Lde/justsoftware/news/domain/delete/DeleteService;", "channelSubscriptionService", "Lde/justsoftware/news/domain/subscription/ChannelSubscriptionService;", "(Lde/justsoftware/news/domain/channel/ChannelService;Lde/justsoftware/news/domain/delete/DeleteService;Lde/justsoftware/news/domain/subscription/ChannelSubscriptionService;)V", "addChannel", "Lde/justsoftware/news/graphql/generated/types/Channel;", "title", "", "dfe", "Lcom/netflix/graphql/dgs/DgsDataFetchingEnvironment;", "channel", "id", "Lde/justsoftware/news/ChannelId;", "channelOnSubscription", "channels", "", "deleteChannel", "editChannel", "managedSubscriptions", "Ljava/util/concurrent/CompletableFuture;", "Lde/justsoftware/news/graphql/generated/types/ManagedSubscription;", "mayCreatePost", "", "mayDelete", "mayEdit", "mayReadScheduledPosts", "permissions", "Lde/justsoftware/news/graphql/generated/types/ChannelPermission;", "subscribeChannel", "Lde/justsoftware/news/graphql/generated/types/ChannelSubscription;", "channelId", "notificationsEnabled", "subscribers", "Lde/justsoftware/news/graphql/generated/types/Profile;", "subscription", "unsubscribeChannel", "news-service"})
public class ChannelDataFetcher {
    @NotNull
    private final ChannelService channelService;
    @NotNull
    private final DeleteService deleteService;
    @NotNull
    private final ChannelSubscriptionService channelSubscriptionService;

    public ChannelDataFetcher(@NotNull ChannelService channelService, @NotNull DeleteService deleteService, @NotNull ChannelSubscriptionService channelSubscriptionService) {
        Intrinsics.checkNotNullParameter((Object)channelService, (String)"channelService");
        Intrinsics.checkNotNullParameter((Object)deleteService, (String)"deleteService");
        Intrinsics.checkNotNullParameter((Object)channelSubscriptionService, (String)"channelSubscriptionService");
        this.channelService = channelService;
        this.deleteService = deleteService;
        this.channelSubscriptionService = channelSubscriptionService;
    }

    @DgsMutation(field="addChannel")
    @NotNull
    public de.justsoftware.news.graphql.generated.types.Channel addChannel(@InputArgument @NotNull String title, @NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        return ChannelDataFetcherKt.toGql((Channel)this.channelService.create(title, (AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe)));
    }

    @DgsMutation(field="subscribeChannel")
    @NotNull
    public de.justsoftware.news.graphql.generated.types.ChannelSubscription subscribeChannel(@InputArgument @NotNull ChannelId channelId, @InputArgument boolean notificationsEnabled, @NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        AuthorizationContext authContext = (AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe);
        return ChannelDataFetcherKt.toGql((ChannelSubscription)this.channelSubscriptionService.subscribe(channelId, notificationsEnabled, authContext));
    }

    @DgsMutation(field="unsubscribeChannel")
    @NotNull
    public de.justsoftware.news.graphql.generated.types.Channel unsubscribeChannel(@InputArgument @NotNull ChannelId channelId, @NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        AuthorizationContext authContext = (AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe);
        this.channelSubscriptionService.unsubscribe(channelId, authContext);
        return ChannelDataFetcherKt.toGql((Channel)this.channelService.getById(channelId, authContext));
    }

    @DgsData(parentType="Channel", field="mayCreatePost")
    @NotNull
    public CompletableFuture<Boolean> mayCreatePost(@NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        DataLoader dataLoader = dfe.getDataLoader(MayCreatePostDataLoader.class);
        ChannelId channelId = ((de.justsoftware.news.graphql.generated.types.Channel)dfe.getSource()).getId();
        CompletableFuture completableFuture = dataLoader.load((Object)channelId);
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"dataLoader.load(channelId)");
        return completableFuture;
    }

    @DgsData(parentType="Channel", field="mayReadScheduledPosts")
    @NotNull
    public CompletableFuture<Boolean> mayReadScheduledPosts(@NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        DataLoader dataLoader = dfe.getDataLoader(MayReadScheduledPostsDataLoader.class);
        ChannelId channelId = ((de.justsoftware.news.graphql.generated.types.Channel)dfe.getSource()).getId();
        CompletableFuture completableFuture = dataLoader.load((Object)channelId);
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"dataLoader.load(channelId)");
        return completableFuture;
    }

    @DgsData(parentType="Channel", field="mayEdit")
    @NotNull
    public CompletableFuture<Boolean> mayEdit(@NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        DataLoader dataLoader = dfe.getDataLoader(MayEditOrDeleteChannelDataLoader.class);
        ChannelId channelId = ((de.justsoftware.news.graphql.generated.types.Channel)dfe.getSource()).getId();
        CompletableFuture completableFuture = dataLoader.load((Object)channelId);
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"dataLoader.load(channelId)");
        return completableFuture;
    }

    @DgsData(parentType="Channel", field="mayDelete")
    @NotNull
    public CompletableFuture<Boolean> mayDelete(@NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        DataLoader dataLoader = dfe.getDataLoader(MayEditOrDeleteChannelDataLoader.class);
        ChannelId channelId = ((de.justsoftware.news.graphql.generated.types.Channel)dfe.getSource()).getId();
        CompletableFuture completableFuture = dataLoader.load((Object)channelId);
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"dataLoader.load(channelId)");
        return completableFuture;
    }

    @DgsMutation(field="deleteChannel")
    @NotNull
    public ChannelId deleteChannel(@NotNull ChannelId id, @NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        return this.deleteService.markChannelForDeletion(id, (AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe));
    }

    @DgsMutation(field="editChannel")
    @NotNull
    public de.justsoftware.news.graphql.generated.types.Channel editChannel(@NotNull ChannelId id, @NotNull String title, @NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        return ChannelDataFetcherKt.toGql((Channel)this.channelService.edit(id, title, (AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe)));
    }

    @DgsQuery(field="channel")
    @Nullable
    public de.justsoftware.news.graphql.generated.types.Channel channel(@NotNull ChannelId id, @NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        Channel channel = this.channelService.findById(id, (AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe));
        return channel != null ? ChannelDataFetcherKt.toGql((Channel)channel) : null;
    }

    /*
     * WARNING - void declaration
     */
    @DgsQuery(field="channels")
    @NotNull
    public List<de.justsoftware.news.graphql.generated.types.Channel> channels(@NotNull DgsDataFetchingEnvironment dfe) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        Iterable $this$map$iv = this.channelService.findAll((AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe));
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Channel channel = (Channel)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(ChannelDataFetcherKt.toGql((Channel)it));
        }
        return (List)destination$iv$iv;
    }

    @DgsData(parentType="Channel", field="permissions")
    @NotNull
    public CompletableFuture<List<ChannelPermission>> permissions(@NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        DataLoader dataLoader = dfe.getDataLoader(PermissionsByChannelIdDataLoader.class);
        ChannelId channelId = ((de.justsoftware.news.graphql.generated.types.Channel)dfe.getSource()).getId();
        CompletableFuture completableFuture = dataLoader.load((Object)channelId);
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"dataLoader.load(channelId)");
        return completableFuture;
    }

    @DgsData(parentType="Channel", field="subscribers")
    @NotNull
    public CompletableFuture<List<Profile>> subscribers(@NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        DataLoader dataLoader = dfe.getDataLoader(SubscribersDataLoader.class);
        ChannelId channelId = ((de.justsoftware.news.graphql.generated.types.Channel)dfe.getSource()).getId();
        CompletableFuture completableFuture = dataLoader.load((Object)channelId);
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"dataLoader.load(channelId)");
        return completableFuture;
    }

    @DgsData(parentType="Channel", field="subscription")
    @NotNull
    public CompletableFuture<List<de.justsoftware.news.graphql.generated.types.ChannelSubscription>> subscription(@NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        DataLoader dataLoader = dfe.getDataLoader(SubscriptionDataLoader.class);
        ChannelId channelId = ((de.justsoftware.news.graphql.generated.types.Channel)dfe.getSource()).getId();
        CompletableFuture completableFuture = dataLoader.load((Object)channelId);
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"dataLoader.load(channelId)");
        return completableFuture;
    }

    @DgsData(parentType="Channel", field="managedSubscriptions")
    @NotNull
    public CompletableFuture<List<ManagedSubscription>> managedSubscriptions(@NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        DataLoader dataLoader = dfe.getDataLoader(ManagedSubscriptionDataLoader.class);
        ChannelId channelId = ((de.justsoftware.news.graphql.generated.types.Channel)dfe.getSource()).getId();
        CompletableFuture completableFuture = dataLoader.load((Object)channelId);
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"dataLoader.load(channelId)");
        return completableFuture;
    }

    @DgsData(parentType="ChannelSubscription", field="channel")
    @NotNull
    public de.justsoftware.news.graphql.generated.types.Channel channelOnSubscription(@NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        ChannelId channelId = ((de.justsoftware.news.graphql.generated.types.ChannelSubscription)dfe.getSource()).getChannelId();
        return ChannelDataFetcherKt.toGql((Channel)this.channelService.getById(channelId, (AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe)));
    }
}

