/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.connector.translation;

import de.justsoftware.news.connector.translation.TranslationException;
import de.justsoftware.news.domain.post.model.TranslationLanguage;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u0005\u001a\u00020\u00062\u0014\u0010\u0007\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\t0\bH\u0012J\u0010\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0006H\u0012J \u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\u0006H\u0016J \u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lde/justsoftware/news/connector/translation/TranslationConnector;", "", "restTemplate", "Lorg/springframework/web/client/RestTemplate;", "(Lorg/springframework/web/client/RestTemplate;)V", "extractTranslation", "", "deeplResponse", "Lorg/springframework/http/ResponseEntity;", "", "getHost", "deeplKey", "translateHtml", "html", "targetLanguage", "Lde/justsoftware/news/domain/post/model/TranslationLanguage;", "translateText", "text", "news-service"})
public class TranslationConnector {
    @NotNull
    private final RestTemplate restTemplate;

    public TranslationConnector(@NotNull RestTemplate restTemplate) {
        Intrinsics.checkNotNullParameter((Object)restTemplate, (String)"restTemplate");
        this.restTemplate = restTemplate;
    }

    public /* synthetic */ TranslationConnector(RestTemplate restTemplate, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            restTemplate = new RestTemplate();
        }
        this(restTemplate);
    }

    @NotNull
    public String translateHtml(@NotNull String html, @NotNull TranslationLanguage targetLanguage, @NotNull String deeplKey) {
        Intrinsics.checkNotNullParameter((Object)html, (String)"html");
        Intrinsics.checkNotNullParameter((Object)targetLanguage, (String)"targetLanguage");
        Intrinsics.checkNotNullParameter((Object)deeplKey, (String)"deeplKey");
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        MultiValueMap body = (MultiValueMap)new LinkedMultiValueMap();
        body.add((Object)"text", (Object)html);
        body.add((Object)"target_lang", (Object)targetLanguage.name());
        body.add((Object)"preserve_formatting", (Object)"1");
        body.add((Object)"auth_key", (Object)deeplKey);
        body.add((Object)"tag_handling", (Object)"xml");
        ResponseEntity it = this.restTemplate.postForEntity(this.getHost(deeplKey), (Object)new HttpEntity((Object)body, (MultiValueMap)headers), Map.class, new Object[0]);
        boolean bl = false;
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        return this.extractTranslation(it);
    }

    @NotNull
    public String translateText(@NotNull String text, @NotNull TranslationLanguage targetLanguage, @NotNull String deeplKey) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)targetLanguage, (String)"targetLanguage");
        Intrinsics.checkNotNullParameter((Object)deeplKey, (String)"deeplKey");
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        MultiValueMap body = (MultiValueMap)new LinkedMultiValueMap();
        body.add((Object)"text", (Object)text);
        body.add((Object)"target_lang", (Object)targetLanguage.name());
        body.add((Object)"preserve_formatting", (Object)"1");
        body.add((Object)"auth_key", (Object)deeplKey);
        body.add((Object)"split_sentences", (Object)"0");
        ResponseEntity it = this.restTemplate.postForEntity(this.getHost(deeplKey), (Object)new HttpEntity((Object)body, (MultiValueMap)headers), Map.class, new Object[0]);
        boolean bl = false;
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        return this.extractTranslation(it);
    }

    private String extractTranslation(ResponseEntity<Map<?, ?>> deeplResponse) {
        Object object;
        Map body = (Map)deeplResponse.getBody();
        if (deeplResponse.getStatusCode() != HttpStatus.OK || (object = body) == null || object.isEmpty()) {
            throw new TranslationException();
        }
        Object v = body.get("translations");
        Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type java.util.ArrayList<java.util.LinkedHashMap<kotlin.String, kotlin.String>>{ kotlin.collections.TypeAliasesKt.ArrayList<java.util.LinkedHashMap<kotlin.String, kotlin.String>{ kotlin.collections.TypeAliasesKt.LinkedHashMap<kotlin.String, kotlin.String> }> }");
        object = (String)((LinkedHashMap)((ArrayList)v).get(0)).get("text");
        if (object == null) {
            throw new TranslationException();
        }
        return object;
    }

    private String getHost(String deeplKey) {
        return StringsKt.endsWith$default((String)deeplKey, (String)":fx", (boolean)false, (int)2, null) ? "https://api-free.deepl.com/v2/translate" : "https://api.deepl.com/v2/translate";
    }

    public TranslationConnector() {
        this(null, 1, null);
    }
}

