/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.connector.search;

import de.justsoftware.news.ChannelId;
import de.justsoftware.news.PostId;
import de.justsoftware.news.TenantId;
import de.justsoftware.news.connector.permission.PermissionConnector;
import de.justsoftware.news.connector.search.SearchConnector;
import de.justsoftware.news.domain.channel.Channel;
import de.justsoftware.news.domain.post.Post;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.common.SolrInputDocument;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0000\n\u0002\u0010$\n\u0002\b\u0004\b\u0017\u0018\u0000 $2\u00020\u0001:\u0001$B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0012J&\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0010\u001a\u00020\nH\u0012J\u0016\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\fH\u0016J\b\u0010\u0015\u001a\u00020\u0012H\u0016J\u0010\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0016\u0010\u0019\u001a\u00020\u00122\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\fH\u0016J\b\u0010\u001c\u001a\u00020\u0012H\u0016J,\u0010\u001d\u001a\u00020\u00122\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001f2\u0014\u0010 \u001a\u0010\u0012\u0004\u0012\u00020\u0014\u0012\u0006\u0012\u0004\u0018\u00010\n0!H\u0016J\u0016\u0010\"\u001a\u00020\u00122\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\n0\u001fH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lde/justsoftware/news/connector/search/SearchConnector;", "", "solrClient", "Lorg/apache/solr/client/solrj/SolrClient;", "permissionConnector", "Lde/justsoftware/news/connector/permission/PermissionConnector;", "(Lorg/apache/solr/client/solrj/SolrClient;Lde/justsoftware/news/connector/permission/PermissionConnector;)V", "createSolrDocument", "Lorg/apache/solr/common/SolrInputDocument;", "channel", "Lde/justsoftware/news/domain/channel/Channel;", "visibleForRoles", "", "", "post", "Lde/justsoftware/news/domain/post/Post;", "parentChannel", "delete", "", "postIds", "Lde/justsoftware/news/PostId;", "deleteAll", "deleteAllForTenant", "tenantId", "Lde/justsoftware/news/TenantId;", "deleteChannels", "channelIds", "Lde/justsoftware/news/ChannelId;", "ping", "upsert", "posts", "", "channelMap", "", "upsertChannels", "channels", "Companion", "news-service"})
public class SearchConnector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SolrClient solrClient;
    @NotNull
    private final PermissionConnector permissionConnector;
    @NotNull
    private static final Logger log;
    @NotNull
    private static final String SEARCH_TYPE_POST = "POST";
    @NotNull
    private static final String SEARCH_TYPE_CHANNEL = "CHANNEL";
    @NotNull
    private static final String JUST_NEWS_SEARCH_APP_ID = "NEWS";

    public SearchConnector(@NotNull SolrClient solrClient, @NotNull PermissionConnector permissionConnector) {
        Intrinsics.checkNotNullParameter((Object)solrClient, (String)"solrClient");
        Intrinsics.checkNotNullParameter((Object)permissionConnector, (String)"permissionConnector");
        this.solrClient = solrClient;
        this.permissionConnector = permissionConnector;
    }

    /*
     * WARNING - void declaration
     */
    public void upsert(@NotNull Set<Post> posts, @NotNull Map<PostId, Channel> channelMap) {
        Intrinsics.checkNotNullParameter(posts, (String)"posts");
        Intrinsics.checkNotNullParameter(channelMap, (String)"channelMap");
        if (posts.isEmpty()) {
            return;
        }
        try {
            void $this$mapTo$iv$iv;
            void $this$mapTo$iv$iv2;
            void $this$map$iv;
            Iterable iterable = posts;
            Object object = this.permissionConnector;
            boolean $i$f$map = false;
            void var6_7 = $this$map$iv;
            Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it;
                Post post = (Post)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getId());
            }
            Map postsToVisibleRoles = object.getRolesWhoRead((Collection)((List)destination$iv$iv));
            Iterable $this$map$iv2 = posts;
            boolean $i$f$map2 = false;
            destination$iv$iv = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Post bl = (Post)item$iv$iv;
                object = destination$iv$iv2;
                boolean bl2 = false;
                Object v = postsToVisibleRoles.get(it.getId());
                if (v == null) {
                    String string = "Required value was null.";
                    throw new IllegalArgumentException(string.toString());
                }
                Channel channel = channelMap.get(it.getId());
                if (channel == null) {
                    String string = "Required value was null.";
                    throw new IllegalArgumentException(string.toString());
                }
                object.add(this.createSolrDocument((Post)it, (Collection)v, channel));
            }
            List solarDocs = (List)destination$iv$iv2;
            this.solrClient.add((Collection)solarDocs);
            log.info("Success upserting " + solarDocs.size() + " Posts.");
        }
        catch (Exception exception) {
            log.error("Error upserting Posts.", (Throwable)exception);
            throw exception;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void upsertChannels(@NotNull Set<Channel> channels) {
        Intrinsics.checkNotNullParameter(channels, (String)"channels");
        if (channels.isEmpty()) {
            return;
        }
        try {
            void $this$mapTo$iv$iv;
            void $this$mapTo$iv$iv2;
            void $this$map$iv;
            Iterable iterable = channels;
            Object object = this.permissionConnector;
            boolean $i$f$map = false;
            void var5_6 = $this$map$iv;
            Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it;
                Channel channel = (Channel)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getId());
            }
            Map channelToVisibleRoles = object.getRolesWhoRead((Collection)((List)destination$iv$iv));
            Iterable $this$map$iv2 = channels;
            boolean $i$f$map2 = false;
            destination$iv$iv = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Channel bl = (Channel)item$iv$iv;
                object = destination$iv$iv2;
                boolean bl2 = false;
                Object v = channelToVisibleRoles.get(it.getId());
                if (v == null) {
                    String string = "Required value was null.";
                    throw new IllegalArgumentException(string.toString());
                }
                object.add(this.createSolrDocument((Channel)it, (Collection)v));
            }
            List solarDocs = (List)destination$iv$iv2;
            this.solrClient.add((Collection)solarDocs);
            log.info("Success upserting " + solarDocs.size() + " Channels.");
        }
        catch (Exception exception) {
            log.error("Error upserting channels.", (Throwable)exception);
            throw exception;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void delete(@NotNull Collection<PostId> postIds) {
        Intrinsics.checkNotNullParameter(postIds, (String)"postIds");
        if (postIds.isEmpty()) {
            return;
        }
        try {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = postIds;
            SolrClient solrClient = this.solrClient;
            boolean $i$f$map = false;
            void var4_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                PostId postId = (PostId)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.toTypedString());
            }
            solrClient.deleteById((List)destination$iv$iv);
            log.info("Success deleting Posts.");
        }
        catch (Exception exception) {
            log.error("Error deleting Posts.", (Throwable)exception);
            throw exception;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void deleteChannels(@NotNull Collection<ChannelId> channelIds) {
        Intrinsics.checkNotNullParameter(channelIds, (String)"channelIds");
        if (channelIds.isEmpty()) {
            return;
        }
        try {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = channelIds;
            SolrClient solrClient = this.solrClient;
            boolean $i$f$map = false;
            void var4_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ChannelId channelId = (ChannelId)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.toTypedString());
            }
            solrClient.deleteById((List)destination$iv$iv);
            log.info("Success deleting Channels.");
        }
        catch (Exception exception) {
            log.error("Error deleting Channels.", (Throwable)exception);
            throw exception;
        }
    }

    public void deleteAllForTenant(@NotNull TenantId tenantId) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        this.solrClient.deleteByQuery("just_app_id:NEWS AND tenant_id:" + tenantId.toTypedString());
        log.info("Success deleted all NEWS data for tenant " + tenantId + "..");
    }

    public void deleteAll() {
        this.solrClient.deleteByQuery("just_app_id:NEWS");
        log.info("Success deleted all NEWS data.");
    }

    public void ping() {
        try {
            this.solrClient.ping();
        }
        catch (Exception e) {
            log.info("solr not available", (Throwable)e);
            throw e;
        }
    }

    private SolrInputDocument createSolrDocument(Post post, Collection<String> visibleForRoles, Channel parentChannel) {
        SolrInputDocument solrInputDocument;
        SolrInputDocument $this$createSolrDocument_u24lambda_u2d6 = solrInputDocument = new SolrInputDocument(new String[0]);
        boolean bl = false;
        $this$createSolrDocument_u24lambda_u2d6.setField("id", (Object)post.getId().toTypedString());
        $this$createSolrDocument_u24lambda_u2d6.setField("name", (Object)post.getTitle());
        $this$createSolrDocument_u24lambda_u2d6.setField("name_sort", (Object)post.getTitle());
        $this$createSolrDocument_u24lambda_u2d6.setField("content", (Object)post.getText());
        $this$createSolrDocument_u24lambda_u2d6.setField("type", (Object)SEARCH_TYPE_POST);
        $this$createSolrDocument_u24lambda_u2d6.setField("direct_parent_ids", (Object)post.getChannelId());
        $this$createSolrDocument_u24lambda_u2d6.setField("parent_ids", (Object)post.getChannelId().toTypedString());
        $this$createSolrDocument_u24lambda_u2d6.setField("parent_name", (Object)parentChannel.getTitle());
        $this$createSolrDocument_u24lambda_u2d6.setField("tenant_id", (Object)parentChannel.getTenantId());
        $this$createSolrDocument_u24lambda_u2d6.setField("modify_date", (Object)Date.from(post.getModifyDate()));
        $this$createSolrDocument_u24lambda_u2d6.setField("publication_date", (Object)Date.from(post.getPublishDate()));
        $this$createSolrDocument_u24lambda_u2d6.setField("just_app_id", (Object)JUST_NEWS_SEARCH_APP_ID);
        $this$createSolrDocument_u24lambda_u2d6.setField("visible_for_roles", visibleForRoles);
        return solrInputDocument;
    }

    private SolrInputDocument createSolrDocument(Channel channel, Collection<String> visibleForRoles) {
        SolrInputDocument solrInputDocument;
        SolrInputDocument $this$createSolrDocument_u24lambda_u2d7 = solrInputDocument = new SolrInputDocument(new String[0]);
        boolean bl = false;
        $this$createSolrDocument_u24lambda_u2d7.setField("id", (Object)channel.getId().toTypedString());
        $this$createSolrDocument_u24lambda_u2d7.setField("name", (Object)channel.getTitle());
        $this$createSolrDocument_u24lambda_u2d7.setField("name_sort", (Object)channel.getTitle());
        $this$createSolrDocument_u24lambda_u2d7.setField("content", (Object)channel.getTitle());
        $this$createSolrDocument_u24lambda_u2d7.setField("type", (Object)SEARCH_TYPE_CHANNEL);
        $this$createSolrDocument_u24lambda_u2d7.setField("tenant_id", (Object)channel.getTenantId());
        $this$createSolrDocument_u24lambda_u2d7.setField("modify_date", (Object)Date.from(channel.getModifyDate()));
        $this$createSolrDocument_u24lambda_u2d7.setField("publication_date", (Object)Date.from(channel.getCreateDate()));
        $this$createSolrDocument_u24lambda_u2d7.setField("just_app_id", (Object)JUST_NEWS_SEARCH_APP_ID);
        $this$createSolrDocument_u24lambda_u2d7.setField("visible_for_roles", visibleForRoles);
        return solrInputDocument;
    }

    static {
        Logger logger = LoggerFactory.getLogger(SearchConnector.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(SearchConnector::class.java)");
        log = logger;
    }
}

