/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.connector.notification;

import de.justsoftware.news.TenantId;
import de.justsoftware.news.UserId;
import de.justsoftware.news.domain.post.Post;
import de.justsoftware.news.domain.user.Profile;
import de.justsoftware.notificationclient.NotificationProducer;
import de.justsoftware.notificationclient.model.Notification;
import de.justsoftware.notificationclient.model.NotificationBuilder;
import de.justsoftware.notificationclient.model.NotificationType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J.\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016J.\u0010\u0012\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016J.\u0010\u0013\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016J.\u0010\u0014\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016J.\u0010\u0015\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016JB\u0010\u0016\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0017\u001a\u00020\u00182\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u00060\u001aH\u0012R\u000e\u0010\u0005\u001a\u00020\u0006X\u0092D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lde/justsoftware/news/connector/notification/NotificationConnector;", "", "notificationProducer", "Lde/justsoftware/notificationclient/NotificationProducer;", "(Lde/justsoftware/notificationclient/NotificationProducer;)V", "appId", "", "mentionedInComment", "", "tenantId", "Lde/justsoftware/news/TenantId;", "post", "Lde/justsoftware/news/domain/post/Post;", "author", "Lde/justsoftware/news/domain/user/Profile;", "receiverIds", "", "Lde/justsoftware/news/UserId;", "mentionedInPost", "newCommentResponse", "newPost", "newPostComment", "sendNotifications", "notificationType", "Lde/justsoftware/notificationclient/model/NotificationType;", "localText", "", "Ljava/util/Locale;", "news-service"})
public class NotificationConnector {
    @NotNull
    private final NotificationProducer notificationProducer;
    @NotNull
    private final String appId;

    public NotificationConnector(@NotNull NotificationProducer notificationProducer) {
        Intrinsics.checkNotNullParameter((Object)notificationProducer, (String)"notificationProducer");
        this.notificationProducer = notificationProducer;
        this.appId = "snowball";
    }

    public void mentionedInComment(@NotNull TenantId tenantId, @NotNull Post post, @NotNull Profile author, @NotNull Collection<? extends UserId> receiverIds) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter((Object)post, (String)"post");
        Intrinsics.checkNotNullParameter((Object)author, (String)"author");
        Intrinsics.checkNotNullParameter(receiverIds, (String)"receiverIds");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)Locale.GERMAN, (Object)(author.getName() + " hat dich in einem Kommentar erw\u00e4hnt.")), TuplesKt.to((Object)Locale.ENGLISH, (Object)(author.getName() + " mentioned you in a comment."))};
        Map localText = MapsKt.mapOf((Pair[])pairArray);
        this.sendNotifications(tenantId, post, receiverIds, NotificationType.COMMENT_ON_WORKSTREAM_WITH_MENTION, localText);
    }

    public void mentionedInPost(@NotNull TenantId tenantId, @NotNull Post post, @NotNull Profile author, @NotNull Collection<? extends UserId> receiverIds) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter((Object)post, (String)"post");
        Intrinsics.checkNotNullParameter((Object)author, (String)"author");
        Intrinsics.checkNotNullParameter(receiverIds, (String)"receiverIds");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)Locale.GERMAN, (Object)(author.getName() + " hat dich in einem Beitrag erw\u00e4hnt.")), TuplesKt.to((Object)Locale.ENGLISH, (Object)(author.getName() + " mentioned you in a post."))};
        Map localText = MapsKt.mapOf((Pair[])pairArray);
        this.sendNotifications(tenantId, post, receiverIds, NotificationType.POSTING_WITH_MENTION, localText);
    }

    public void newCommentResponse(@NotNull TenantId tenantId, @NotNull Post post, @NotNull Profile author, @NotNull Collection<? extends UserId> receiverIds) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter((Object)post, (String)"post");
        Intrinsics.checkNotNullParameter((Object)author, (String)"author");
        Intrinsics.checkNotNullParameter(receiverIds, (String)"receiverIds");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)Locale.GERMAN, (Object)(author.getName() + " hat einen Kommentar des Beitrages beantwortet.")), TuplesKt.to((Object)Locale.ENGLISH, (Object)(author.getName() + " answered a comment of this post."))};
        Map localText = MapsKt.mapOf((Pair[])pairArray);
        this.sendNotifications(tenantId, post, receiverIds, NotificationType.COMMENT_ON_ENTITY_SUBSCRIPTION, localText);
    }

    public void newPostComment(@NotNull TenantId tenantId, @NotNull Post post, @NotNull Profile author, @NotNull Collection<? extends UserId> receiverIds) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter((Object)post, (String)"post");
        Intrinsics.checkNotNullParameter((Object)author, (String)"author");
        Intrinsics.checkNotNullParameter(receiverIds, (String)"receiverIds");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)Locale.GERMAN, (Object)(author.getName() + " hat den Beitrag kommentiert.")), TuplesKt.to((Object)Locale.ENGLISH, (Object)(author.getName() + " commented on this post."))};
        Map localText = MapsKt.mapOf((Pair[])pairArray);
        this.sendNotifications(tenantId, post, receiverIds, NotificationType.COMMENT_ON_ENTITY_SUBSCRIPTION, localText);
    }

    public void newPost(@NotNull TenantId tenantId, @NotNull Post post, @NotNull Profile author, @NotNull Collection<? extends UserId> receiverIds) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter((Object)post, (String)"post");
        Intrinsics.checkNotNullParameter((Object)author, (String)"author");
        Intrinsics.checkNotNullParameter(receiverIds, (String)"receiverIds");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)Locale.GERMAN, (Object)(author.getName() + " hat den Beitrag ver\u00f6ffentlicht.")), TuplesKt.to((Object)Locale.ENGLISH, (Object)(author.getName() + " has published a post."))};
        Map localText = MapsKt.mapOf((Pair[])pairArray);
        this.sendNotifications(tenantId, post, receiverIds, NotificationType.POSTING_ON_SUBSCRIPTION, localText);
    }

    /*
     * WARNING - void declaration
     */
    private void sendNotifications(TenantId tenantId, Post post, Collection<? extends UserId> receiverIds, NotificationType notificationType, Map<Locale, String> localText) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        if (receiverIds.isEmpty()) {
            return;
        }
        UUID uUID = tenantId.getValue();
        String string = post.getTitle();
        Locale locale = Locale.GERMAN;
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"GERMAN");
        Iterable iterable = receiverIds;
        NotificationBuilder notificationBuilder = Notification.builder((UUID)uUID, (String)this.appId, (String)string, (String)((String)MapsKt.getValue(localText, (Object)locale)), (NotificationType)notificationType).withLocalizedText(localText);
        boolean $i$f$map = false;
        void var8_10 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            UserId userId = (UserId)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.toTypedString());
        }
        iterable = notificationBuilder.withReceivers(CollectionsKt.toSet((Iterable)((List)destination$iv$iv))).withPayload(this.appId).withTargetId(post.getId().toTypedString()).build();
        NotificationProducer notificationProducer = this.notificationProducer;
        Iterable p0 = iterable;
        boolean bl = false;
        notificationProducer.dispatchNotification((Notification)p0);
    }
}

