/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.auth;

import de.justsoftware.news.ChannelId;
import de.justsoftware.news.ItemId;
import de.justsoftware.news.PostId;
import de.justsoftware.news.ProfileId;
import de.justsoftware.news.TenantId;
import de.justsoftware.news.UserId;
import de.justsoftware.news.auth.exceptions.NotAuthorizedException;
import de.justsoftware.news.connector.permission.PermissionConnector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\r\u001a\u00020\u000eJ\u0016\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0005J\u000e\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015J\u0014\u0010\u0016\u001a\u00020\u000e2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00150\u0018J\u000e\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015J\u0014\u0010\u001a\u001a\u00020\u000e2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00150\u0018J\u0016\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u001dJ\u0016\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u001c\u001a\u00020\u001dJ\u0006\u0010!\u001a\u00020\u000eJ\u000e\u0010\"\u001a\u00020\u000e2\u0006\u0010#\u001a\u00020\u0005J\u000e\u0010$\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015J$\u0010%\u001a\b\u0012\u0004\u0012\u0002H'0&\"\b\b\u0000\u0010'*\u00020\u00152\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H'0\u0018J\u0006\u0010(\u001a\u00020\u001dJ \u0010)\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u001d0*2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00110\u0018J \u0010,\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u001d0*2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00150\u0018J\u000e\u0010-\u001a\u00020\u001d2\u0006\u0010\u0014\u001a\u00020\u0015J\u0014\u0010.\u001a\u00020\u001d2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00150\u0018J \u0010/\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u001d0*2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00110\u0018J\u0006\u00100\u001a\u00020\u001dR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u00061"}, d2={"Lde/justsoftware/news/auth/AuthorizationContext;", "", "tenantId", "Lde/justsoftware/news/TenantId;", "user", "Lde/justsoftware/news/ProfileId;", "permissionConnector", "Lde/justsoftware/news/connector/permission/PermissionConnector;", "(Lde/justsoftware/news/TenantId;Lde/justsoftware/news/ProfileId;Lde/justsoftware/news/connector/permission/PermissionConnector;)V", "getTenantId", "()Lde/justsoftware/news/TenantId;", "getUser", "()Lde/justsoftware/news/ProfileId;", "checkAppWriter", "", "checkDeleteComment", "channelId", "Lde/justsoftware/news/ChannelId;", "commentAuthorId", "checkManage", "itemId", "Lde/justsoftware/news/ItemId;", "checkManageAll", "itemIds", "", "checkRead", "checkReadAll", "checkReadChannelPosts", "scheduled", "", "checkReadPost", "postId", "Lde/justsoftware/news/PostId;", "checkSuperAdmin", "checkUserEqual", "profileId", "checkWrite", "filterReadable", "", "T", "mayCreateChannel", "mayCreatePosts", "", "channelIds", "mayEditOrDelete", "mayManage", "mayManageAll", "mayReadScheduledPosts", "mayVisitNonActiveProfile", "news-service"})
public final class AuthorizationContext {
    @NotNull
    private final TenantId tenantId;
    @NotNull
    private final ProfileId user;
    @NotNull
    private final PermissionConnector permissionConnector;

    public AuthorizationContext(@NotNull TenantId tenantId, @NotNull ProfileId user, @NotNull PermissionConnector permissionConnector) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)permissionConnector, (String)"permissionConnector");
        this.tenantId = tenantId;
        this.user = user;
        this.permissionConnector = permissionConnector;
    }

    @NotNull
    public final TenantId getTenantId() {
        return this.tenantId;
    }

    @NotNull
    public final ProfileId getUser() {
        return this.user;
    }

    @NotNull
    public final Map<ItemId, Boolean> mayEditOrDelete(@NotNull Collection<? extends ItemId> itemIds) {
        Intrinsics.checkNotNullParameter(itemIds, (String)"itemIds");
        return this.permissionConnector.mayManage(itemIds, (UserId)this.user);
    }

    public final boolean mayCreateChannel() {
        return this.permissionConnector.mayWriteAppNews(this.tenantId, (UserId)this.user);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<ChannelId, Boolean> mayCreatePosts(@NotNull Collection<ChannelId> channelIds) {
        void $this$mapKeysTo$iv$iv;
        Intrinsics.checkNotNullParameter(channelIds, (String)"channelIds");
        Map $this$mapKeys$iv = this.permissionConnector.mayWrite(channelIds, (UserId)this.user);
        boolean $i$f$mapKeys = false;
        Map map = $this$mapKeys$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
        boolean $i$f$mapKeysTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            void it;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            ChannelId channelId = ChannelId.Companion.fromString(((ItemId)it.getKey()).toTypedString());
            Map map3 = map2;
            boolean bl2 = false;
            entry = it$iv$iv.getValue();
            map3.put(channelId, entry);
        }
        return destination$iv$iv;
    }

    @NotNull
    public final Map<ItemId, Boolean> mayReadScheduledPosts(@NotNull Collection<ChannelId> channelIds) {
        Intrinsics.checkNotNullParameter(channelIds, (String)"channelIds");
        return this.permissionConnector.mayWrite(channelIds, (UserId)this.user);
    }

    public final boolean mayVisitNonActiveProfile() {
        return this.permissionConnector.isSuperAdmin((UserId)this.user);
    }

    public final void checkReadPost(@NotNull PostId postId, boolean scheduled) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        if (scheduled) {
            this.checkWrite((ItemId)postId);
        } else {
            this.checkRead((ItemId)postId);
        }
    }

    public final void checkReadChannelPosts(@NotNull ChannelId channelId, boolean scheduled) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        if (scheduled) {
            this.checkWrite((ItemId)channelId);
        } else {
            this.checkRead((ItemId)channelId);
        }
    }

    public final void checkRead(@NotNull ItemId itemId) {
        Intrinsics.checkNotNullParameter((Object)itemId, (String)"itemId");
        this.permissionConnector.checkRead(itemId, (UserId)this.user);
    }

    public final void checkReadAll(@NotNull Collection<? extends ItemId> itemIds) {
        Intrinsics.checkNotNullParameter(itemIds, (String)"itemIds");
        this.permissionConnector.checkReadAll(itemIds, (UserId)this.user);
    }

    public final void checkWrite(@NotNull ItemId itemId) {
        Intrinsics.checkNotNullParameter((Object)itemId, (String)"itemId");
        this.permissionConnector.checkWrite(itemId, (UserId)this.user);
    }

    public final void checkManage(@NotNull ItemId itemId) {
        Intrinsics.checkNotNullParameter((Object)itemId, (String)"itemId");
        this.permissionConnector.checkManage(itemId, (UserId)this.user);
    }

    public final void checkManageAll(@NotNull Collection<? extends ItemId> itemIds) {
        Intrinsics.checkNotNullParameter(itemIds, (String)"itemIds");
        this.permissionConnector.checkManageAll(itemIds, (UserId)this.user);
    }

    public final boolean mayManage(@NotNull ItemId itemId) {
        Intrinsics.checkNotNullParameter((Object)itemId, (String)"itemId");
        return this.permissionConnector.mayManage(itemId, (UserId)this.user);
    }

    public final boolean mayManageAll(@NotNull Collection<? extends ItemId> itemIds) {
        Intrinsics.checkNotNullParameter(itemIds, (String)"itemIds");
        return this.permissionConnector.mayManageAll(itemIds, (UserId)this.user);
    }

    public final void checkSuperAdmin() {
        this.permissionConnector.checkSuperAdmin((UserId)this.user);
    }

    public final void checkAppWriter() {
        this.permissionConnector.checkAppWriterNews(this.tenantId, (UserId)this.user);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <T extends ItemId> List<T> filterReadable(@NotNull Collection<? extends T> itemIds) {
        void $this$mapTo$iv$iv;
        Map.Entry it;
        Map $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(itemIds, (String)"itemIds");
        Map $this$filter$iv = this.permissionConnector.mayRead(itemIds, (UserId)this.user);
        boolean $i$f$filter = false;
        Map map = $this$filter$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            it = element$iv$iv = iterator.next();
            boolean bl = false;
            if (!((Boolean)it.getValue()).booleanValue()) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map $this$map$iv = destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        for (Map.Entry item$iv$iv : $this$mapTo$iv$iv.entrySet()) {
            it = item$iv$iv;
            Object object = destination$iv$iv;
            boolean bl = false;
            Object k = it.getKey();
            Intrinsics.checkNotNull(k, (String)"null cannot be cast to non-null type T of de.justsoftware.news.auth.AuthorizationContext.filterReadable$lambda-2");
            object.add((ItemId)k);
        }
        return (List)destination$iv$iv;
    }

    public final void checkDeleteComment(@NotNull ChannelId channelId, @NotNull ProfileId commentAuthorId) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter((Object)commentAuthorId, (String)"commentAuthorId");
        if (Intrinsics.areEqual((Object)this.user, (Object)commentAuthorId)) {
            return;
        }
        this.checkManage((ItemId)channelId);
    }

    public final void checkUserEqual(@NotNull ProfileId profileId) {
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        if (!Intrinsics.areEqual((Object)profileId, (Object)this.user)) {
            throw new NotAuthorizedException("User '" + this.user + "' is not allowed to perform operations for user '" + profileId + "'!");
        }
    }
}

