/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news;

import de.justsoftware.news.ChannelId;
import de.justsoftware.news.DevDatabaseSeed;
import de.justsoftware.news.auth.AuthorizationContext;
import de.justsoftware.news.domain.channel.Channel;
import de.justsoftware.news.domain.channel.ChannelService;
import de.justsoftware.news.domain.comment.PostCommentService;
import de.justsoftware.news.domain.post.Post;
import de.justsoftware.news.domain.post.PostService;
import de.justsoftware.news.domain.subscription.ChannelSubscriptionService;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0017\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u000eH\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lde/justsoftware/news/DevDatabaseSeed;", "", "channelService", "Lde/justsoftware/news/domain/channel/ChannelService;", "channelSubscriptionService", "Lde/justsoftware/news/domain/subscription/ChannelSubscriptionService;", "postCommentService", "Lde/justsoftware/news/domain/comment/PostCommentService;", "postService", "Lde/justsoftware/news/domain/post/PostService;", "(Lde/justsoftware/news/domain/channel/ChannelService;Lde/justsoftware/news/domain/subscription/ChannelSubscriptionService;Lde/justsoftware/news/domain/comment/PostCommentService;Lde/justsoftware/news/domain/post/PostService;)V", "create", "", "authCtx", "Lde/justsoftware/news/auth/AuthorizationContext;", "doCreate", "authContext", "Companion", "news-service"})
public class DevDatabaseSeed {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ChannelService channelService;
    @NotNull
    private final ChannelSubscriptionService channelSubscriptionService;
    @NotNull
    private final PostCommentService postCommentService;
    @NotNull
    private final PostService postService;
    @NotNull
    private static final Logger log;

    public DevDatabaseSeed(@NotNull ChannelService channelService, @NotNull ChannelSubscriptionService channelSubscriptionService, @NotNull PostCommentService postCommentService, @NotNull PostService postService) {
        Intrinsics.checkNotNullParameter((Object)channelService, (String)"channelService");
        Intrinsics.checkNotNullParameter((Object)channelSubscriptionService, (String)"channelSubscriptionService");
        Intrinsics.checkNotNullParameter((Object)postCommentService, (String)"postCommentService");
        Intrinsics.checkNotNullParameter((Object)postService, (String)"postService");
        this.channelService = channelService;
        this.channelSubscriptionService = channelSubscriptionService;
        this.postCommentService = postCommentService;
        this.postService = postService;
    }

    public void create(@NotNull AuthorizationContext authCtx) {
        Intrinsics.checkNotNullParameter((Object)authCtx, (String)"authCtx");
        try {
            this.doCreate(authCtx);
            log.info("Finished creating test data!");
        }
        catch (Exception exception) {
            log.error("CRITICAL HIT: spaceship took severe hit during test data creation!");
            log.error(ExceptionsKt.stackTraceToString((Throwable)exception));
            throw exception;
        }
    }

    private void doCreate(AuthorizationContext authContext) {
        Channel channel = this.channelService.create("Fuchs Nachrichten " + Random.Default.nextInt(1000), authContext);
        this.channelSubscriptionService.subscribe(channel.getId(), true, authContext);
        PostService postService = this.postService;
        ChannelId channelId = channel.getId();
        Post post = PostService.create$default((PostService)postService, (ChannelId)channelId, (String)"Kaikhosru Shapurji Sorabji", (String)"Kaikhosru Shapurji Sorabji (1892\u20131988) was an English composer, music critic, pianist and writer whose music, written over a period of seventy years, ranges from sets of miniatures to works lasting several hours. One of the most prolific 20th-century composers, he is best known for his piano pieces, notably nocturnes such as Gulist\u0101n, and large-scale, technically intricate works like Sequentia cyclica. He had a lifelong tendency to seclusion and felt alienated from English society by reason of his homosexuality and ancestry; his mother was English and his father a Parsi businessman and industrialist from India. After playing his music publicly between 1920 and 1936, Sorabji imposed restrictions on its performance, which he lifted in 1976.", (String)"Kaikhosru Shapurji Sorabji (1892\u20131988) was an English composer, music critic, pianist and writer whose music, written over a period of seventy years, ranges from sets of miniatures to works lasting several hours. One of the most prolific 20th-century composers, he is best known for his piano pieces, notably nocturnes such as Gulist\u0101n, and large-scale, technically intricate works like Sequentia cyclica. He had a lifelong tendency to seclusion and felt alienated from English society by reason of his homosexuality and ancestry; his mother was English and his father a Parsi businessman and industrialist from India. After playing his music publicly between 1920 and 1936, Sorabji imposed restrictions on its performance, which he lifted in 1976.", null, null, (Boolean)false, null, null, null, (AuthorizationContext)authContext, (int)560, null);
        this.postCommentService.createComment(post.getId(), null, "Count Johann Adam von Questenberg (baptized 24 February 1678 \u2013 10 May 1752)[1] was an Austrian nobleman, Reichshofrat, amateur musician, and patron of the arts. He was a councilor of the Imperial Court in Vienna from 1702 to 1735. He organised concerts at his palaces in Vienna and Jarmeritz, and commissioned compositions by contemporary composers. He made his palace a music centre of Central Europe.", "{ string: 'Count Johann Adam von Questenberg (baptized 24 February 1678 \u2013 10 May 1752)[1] was an Austrian nobleman, Reichshofrat, amateur musician, and patron of the arts. He was a councilor of the Imperial Court in Vienna from 1702 to 1735. He organised concerts at his palaces in Vienna and Jarmeritz, and commissioned compositions by contemporary composers. He made his palace a music centre of Central Europe.' }", authContext);
        postService = this.postService;
        channelId = channel.getId();
        PostService.create$default((PostService)postService, (ChannelId)channelId, (String)"NEG Micon", (String)"NEG Micon was a Danish wind turbine manufacturer. It was formed in 1997 as a result of a merger between Nordtank Energy Group (NEG) and Moerup Industrial Windmill Construction Company (Micon).[1] The company was merged with another Danish wind turbine manufacturer, Vestas, in 2004, and it is now operating under that name. The company produced wind turbines for many different countries including Canada, Denmark, Germany, Sri Lanka and United States. NEG Micon turbine had 35 different models,[2] and were very popular in the wind power industry, particularly the NM-48, NM-52, NM-72, and NM-82 turbines; and can be seen throughout major wind farms around the world.", (String)"NEG Micon was a Danish wind turbine manufacturer. It was formed in 1997 as a result of a merger between Nordtank Energy Group (NEG) and Moerup Industrial Windmill Construction Company (Micon).[1] The company was merged with another Danish wind turbine manufacturer, Vestas, in 2004, and it is now operating under that name. The company produced wind turbines for many different countries including Canada, Denmark, Germany, Sri Lanka and United States. NEG Micon turbine had 35 different models,[2] and were very popular in the wind power industry, particularly the NM-48, NM-52, NM-72, and NM-82 turbines; and can be seen throughout major wind farms around the world.", null, null, (Boolean)false, null, null, null, (AuthorizationContext)authContext, (int)560, null);
        postService = this.postService;
        channelId = channel.getId();
        PostService.create$default((PostService)postService, (ChannelId)channelId, (String)"Junichi Kakizaki", (String)"Junichi Kakizaki (\u67ff\u5d0e \u9806\u4e00, Kakizaki Jun'ichi, born January 4, 1971) is a Japanese artist, sculptor, floral artist, land and environmental artist. He exhibits regularly both in Japan and internationally. Since 1992, he has mainly worked on scenography. He brought a floral design representation in area of contemporary art. His daughter, Memi, is a former member of Japanese idol group Hinatazaka46.", (String)"Junichi Kakizaki (\u67ff\u5d0e \u9806\u4e00, Kakizaki Jun'ichi, born January 4, 1971) is a Japanese artist, sculptor, floral artist, land and environmental artist. He exhibits regularly both in Japan and internationally. Since 1992, he has mainly worked on scenography. He brought a floral design representation in area of contemporary art. His daughter, Memi, is a former member of Japanese idol group Hinatazaka46.", null, null, (Boolean)false, null, null, null, (AuthorizationContext)authContext, (int)560, null);
        postService = this.postService;
        channelId = channel.getId();
        PostService.create$default((PostService)postService, (ChannelId)channelId, (String)"USA-177", (String)"USA-177, also known as GPS IIR-11 and GPS SVN-59, is an American navigation satellite which forms part of the Global Positioning System. It was the eleventh Block IIR GPS satellite to be launched, out of thirteen in the original configuration, and twenty one overall. It was built by Lockheed Martin, using the AS-4000 satellite bus.[2] USA-177 was launched at 17:53:00 UTC on 20 March 2004, atop a Delta II carrier rocket, flight number D303, flying in the 7925-9.5 configuration.[3] The launch took place from Space Launch Complex 17B at the Cape Canaveral Air Force Station,[5] and placed USA-177 into a transfer orbit. The satellite raised itself into medium Earth orbit using a Star-37FM apogee motor.[2]By 20 May 2004, USA-177 was in an orbit with a perigee of 20,095 kilometres (12,486 mi), an apogee of 20,271 kilometres (12,596 mi), a period of 718 minutes, and 55 degrees of inclination to the equator.[4] It is used to broadcast the PRN 19 signal, and operates in slot 3 of plane C of the GPS constellation. The satellite has a mass of 2,032 kilograms (4,480 lb), and a design life of 10 years.[2] As of 2012 it remains in service.", (String)"USA-177, also known as GPS IIR-11 and GPS SVN-59, is an American navigation satellite which forms part of the Global Positioning System. It was the eleventh Block IIR GPS satellite to be launched, out of thirteen in the original configuration, and twenty one overall. It was built by Lockheed Martin, using the AS-4000 satellite bus.[2] USA-177 was launched at 17:53:00 UTC on 20 March 2004, atop a Delta II carrier rocket, flight number D303, flying in the 7925-9.5 configuration.[3] The launch took place from Space Launch Complex 17B at the Cape Canaveral Air Force Station,[5] and placed USA-177 into a transfer orbit. The satellite raised itself into medium Earth orbit using a Star-37FM apogee motor.[2]By 20 May 2004, USA-177 was in an orbit with a perigee of 20,095 kilometres (12,486 mi), an apogee of 20,271 kilometres (12,596 mi), a period of 718 minutes, and 55 degrees of inclination to the equator.[4] It is used to broadcast the PRN 19 signal, and operates in slot 3 of plane C of the GPS constellation. The satellite has a mass of 2,032 kilograms (4,480 lb), and a design life of 10 years.[2] As of 2012 it remains in service.", null, null, (Boolean)false, null, null, null, (AuthorizationContext)authContext, (int)560, null);
        postService = this.postService;
        channelId = channel.getId();
        PostService.create$default((PostService)postService, (ChannelId)channelId, (String)"Tom Adelson", (String)"Tom Adelson is an American politician from Oklahoma. He was an Oklahoma State Senator representing the 33 Senate District, located in Tulsa County, from 2004 to 2012. Adelson is a Democrat who was first elected in 2004. Prior to his election, Adelson served Governor of Oklahoma Brad Henry's first Oklahoma Secretary of Health from 2003 to 2004. Adelson was the Democratic nominee for mayor of Tulsa in the 2009 election, but lost the general election to Republican nominee Dewey F. Bartlett Jr.", (String)"Tom Adelson is an American politician from Oklahoma. He was an Oklahoma State Senator representing the 33 Senate District, located in Tulsa County, from 2004 to 2012. Adelson is a Democrat who was first elected in 2004. Prior to his election, Adelson served Governor of Oklahoma Brad Henry's first Oklahoma Secretary of Health from 2003 to 2004. Adelson was the Democratic nominee for mayor of Tulsa in the 2009 election, but lost the general election to Republican nominee Dewey F. Bartlett Jr.", null, null, (Boolean)false, null, null, null, (AuthorizationContext)authContext, (int)560, null);
        postService = this.postService;
        channelId = channel.getId();
        PostService.create$default((PostService)postService, (ChannelId)channelId, (String)"Walter Storp", (String)"Walter Storp (2 February 1910 \u2013 9 August 1981) was a German bomber pilot and commander of several bomber wings during World War II. He was a recipient of the Knight's Cross of the Iron Cross with Oak Leaves. Storp reached the rank of Generalmajor and ended the war as commander of the 5th Air Division in Norway. Storp was born on 2 February 1910 in Schnecken, East Prussia, the son of a forester. After he received his Abitur (diploma) in 1928 he joined the military service and served in the navy.[1] Holding the rank of Oberleutnant he served in the Bordfliegerstaffel 1./106 (on board flyers squadron) until February 1936. From May to September he was a pilot aboard the heavy cruiser Admiral Scheer, participating in the ship's first cruise of the Spanish Civil War in August 1936.[2] Storp was assigned to the Reich Ministry of Aviation on 1 October 1938 and at the same time became the chief pilot of general Hans Jeschonnek. Serving briefly with KG 30 in early 1940, Storp became temporary Gruppenkommandeur of III gruppe, KG 4 between May and August 1940.[citation needed] He was then appointed group commander of II./Kampfgeschwader 76 (II./KG 76\u20142nd Group of the 76th Bomber Wing) on 12 September 1940. He and his crew performed a successful low-altitude attack over the English Midlands on 27 September 1940.[3]In April 1941 Storp was appointed commander of Schnellkampfgeschwader 210, leading the unit during operations against the Soviet Union during 1941. He then was transferred to a RLM staff appointment in October 1941, before a further move in September 1942, as Geschwaderkommodore of Kampfgeschwader 6. A return to KG 76 occurred in June 1944, while in February 1945 he became Commander of the 5th Flieger-Division until the end of the war.", (String)"Walter Storp (2 February 1910 \u2013 9 August 1981) was a German bomber pilot and commander of several bomber wings during World War II. He was a recipient of the Knight's Cross of the Iron Cross with Oak Leaves. Storp reached the rank of Generalmajor and ended the war as commander of the 5th Air Division in Norway. Storp was born on 2 February 1910 in Schnecken, East Prussia, the son of a forester. After he received his Abitur (diploma) in 1928 he joined the military service and served in the navy.[1] Holding the rank of Oberleutnant he served in the Bordfliegerstaffel 1./106 (on board flyers squadron) until February 1936. From May to September he was a pilot aboard the heavy cruiser Admiral Scheer, participating in the ship's first cruise of the Spanish Civil War in August 1936.[2] Storp was assigned to the Reich Ministry of Aviation on 1 October 1938 and at the same time became the chief pilot of general Hans Jeschonnek. Serving briefly with KG 30 in early 1940, Storp became temporary Gruppenkommandeur of III gruppe, KG 4 between May and August 1940.[citation needed] He was then appointed group commander of II./Kampfgeschwader 76 (II./KG 76\u20142nd Group of the 76th Bomber Wing) on 12 September 1940. He and his crew performed a successful low-altitude attack over the English Midlands on 27 September 1940.[3]In April 1941 Storp was appointed commander of Schnellkampfgeschwader 210, leading the unit during operations against the Soviet Union during 1941. He then was transferred to a RLM staff appointment in October 1941, before a further move in September 1942, as Geschwaderkommodore of Kampfgeschwader 6. A return to KG 76 occurred in June 1944, while in February 1945 he became Commander of the 5th Flieger-Division until the end of the war.", null, null, (Boolean)false, null, null, null, (AuthorizationContext)authContext, (int)560, null);
        postService = this.postService;
        channelId = channel.getId();
        PostService.create$default((PostService)postService, (ChannelId)channelId, (String)"Kalkaji Mandir metro station", (String)"Kalkaji Mandir Metro Station is an interchange station of the Delhi Metro between Violet Line and Magenta Line. The interchange is situated in two levels - underground and elevated. There is seamless connection between the two lines, which allows commuters to change lines without requiring to exit from the ticketed area. There is a five minutes walking tunnel between these two lines to interchange. This is located between Nehru Place and Govind Puri stations of the Violet Line, and between Nehru Enclave and Okhla NSIC stations of the Magenta Line. It provides access to tourist sites such as Kalkaji Mandir, Lotus Temple, Prachin Bhairav Mandir and ISKCON Temple which are situated very near to the station. The station was opened with the first section of the Line from Central Secretariat - Sarita Vihar on 3 October 2010, in time for the Commonwealth Games opening ceremony on the same day. The metro station also houses a departmental store. The interchange with Magenta Line was opened on 25 December 2017. Big Bazaar is also available in the basement of this metro station.", (String)"Kalkaji Mandir Metro Station is an interchange station of the Delhi Metro between Violet Line and Magenta Line. The interchange is situated in two levels - underground and elevated. There is seamless connection between the two lines, which allows commuters to change lines without requiring to exit from the ticketed area. There is a five minutes walking tunnel between these two lines to interchange. This is located between Nehru Place and Govind Puri stations of the Violet Line, and between Nehru Enclave and Okhla NSIC stations of the Magenta Line. It provides access to tourist sites such as Kalkaji Mandir, Lotus Temple, Prachin Bhairav Mandir and ISKCON Temple which are situated very near to the station. The station was opened with the first section of the Line from Central Secretariat - Sarita Vihar on 3 October 2010, in time for the Commonwealth Games opening ceremony on the same day. The metro station also houses a departmental store. The interchange with Magenta Line was opened on 25 December 2017. Big Bazaar is also available in the basement of this metro station.", null, null, (Boolean)false, null, null, null, (AuthorizationContext)authContext, (int)560, null);
    }

    static {
        Logger logger = LoggerFactory.getLogger(DevDatabaseSeed.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(DevDatabaseSeed::class.java)");
        log = logger;
    }
}

