/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.mobile.gateway.people.controller;

import de.justsoftware.mobile.gateway.authorization.model.AuthorizationContext;
import de.justsoftware.mobile.gateway.people.model.Profile;
import de.justsoftware.mobile.gateway.people.model.UserGroup;
import de.justsoftware.mobile.gateway.people.model.UserGroupDetails;
import de.justsoftware.mobile.gateway.people.service.PeopleService;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/people"})
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J6\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\n\b\u0001\u0010\b\u001a\u0004\u0018\u00010\t2\b\b\u0001\u0010\n\u001a\u00020\u000b2\b\b\u0001\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0017J\u0012\u0010\u000f\u001a\u00020\u00102\b\b\u0001\u0010\u0011\u001a\u00020\tH\u0017J,\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\b\b\u0001\u0010\u0011\u001a\u00020\t2\b\b\u0001\u0010\n\u001a\u00020\u000b2\b\b\u0001\u0010\f\u001a\u00020\u000bH\u0017J*\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u00062\b\b\u0001\u0010\n\u001a\u00020\u000b2\b\b\u0001\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lde/justsoftware/mobile/gateway/people/controller/PeopleController;", "", "peopleService", "Lde/justsoftware/mobile/gateway/people/service/PeopleService;", "(Lde/justsoftware/mobile/gateway/people/service/PeopleService;)V", "getProfiles", "", "Lde/justsoftware/mobile/gateway/people/model/Profile;", "query", "", "offset", "", "limit", "authContext", "Lde/justsoftware/mobile/gateway/authorization/model/AuthorizationContext;", "getUserGroupDetails", "Lde/justsoftware/mobile/gateway/people/model/UserGroupDetails;", "groupId", "getUserGroupMembers", "getUserGroups", "Lde/justsoftware/mobile/gateway/people/model/UserGroup;", "mobile-gateway"})
public class PeopleController {
    @NotNull
    private final PeopleService peopleService;

    public PeopleController(@NotNull PeopleService peopleService) {
        Intrinsics.checkNotNullParameter((Object)peopleService, (String)"peopleService");
        this.peopleService = peopleService;
    }

    @GetMapping
    @NotNull
    public List<Profile> getProfiles(@RequestParam(value="query", required=false) @Nullable String query, @RequestParam(name="offset", required=false, defaultValue="0") int offset, @RequestParam(name="limit", required=false, defaultValue="20") int limit, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.peopleService.getProfiles(authContext.getTenantId(), query, offset, limit);
    }

    @GetMapping(value={"/groups"})
    @NotNull
    public List<UserGroup> getUserGroups(@RequestParam(name="offset", required=false, defaultValue="0") int offset, @RequestParam(name="limit", required=false, defaultValue="20") int limit, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.peopleService.getUserGroups(authContext.getTenantId(), offset, limit);
    }

    @GetMapping(value={"/groups/{id}"})
    @NotNull
    public UserGroupDetails getUserGroupDetails(@PathVariable(value="id") @NotNull String groupId) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        return this.peopleService.getUserGroupDetails(groupId);
    }

    @GetMapping(value={"/groups/{id}/members"})
    @NotNull
    public List<Profile> getUserGroupMembers(@PathVariable(value="id") @NotNull String groupId, @RequestParam(name="offset", required=false, defaultValue="0") int offset, @RequestParam(name="limit", required=false, defaultValue="20") int limit) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        return this.peopleService.getUserGroupMembers(groupId, offset, limit);
    }
}

