/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.mobile.gateway.notification.service;

import de.justsoftware.mobile.gateway.notification.model.Notification;
import de.justsoftware.mobile.gateway.notification.service.NotificationApiGatewayService$getNotifications$;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.util.UriComponentsBuilder;

@Service
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\n\b\u0017\u0018\u00002\u00020\u0001B\u0017\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0012J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0003H\u0016J\u0010\u0010\u000e\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u0003H\u0012J.\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\b2\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0003H\u0016J\u0018\u0010\u0016\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0003H\u0016J\u0018\u0010\u0018\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0003H\u0012J(\u0010\u0019\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0003H\u0012J\u0016\u0010\u001a\u001a\u00020\f2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00030\bH\u0016J\b\u0010\u001c\u001a\u00020\nH\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lde/justsoftware/mobile/gateway/notification/service/NotificationApiGatewayService;", "", "notificationApiUrl", "", "webClient", "Lorg/springframework/web/reactive/function/client/WebClient$Builder;", "(Ljava/lang/String;Lorg/springframework/web/reactive/function/client/WebClient$Builder;)V", "archiveAllNotifications", "", "archiveAllNotificationsUri", "Ljava/net/URI;", "archiveNotification", "", "notificationId", "archiveNotificationUri", "getNotifications", "Lde/justsoftware/mobile/gateway/notification/model/Notification;", "state", "limit", "", "date", "locale", "markNotification", "action", "markNotificationUri", "notificationsUri", "openNotifications", "notificationIds", "openNotificationsUri", "mobile-gateway"})
public class NotificationApiGatewayService {
    @NotNull
    private final String notificationApiUrl;
    @NotNull
    private final WebClient.Builder webClient;

    public NotificationApiGatewayService(@Value(value="${just.notification.api.url}") @NotNull String notificationApiUrl, @NotNull WebClient.Builder webClient) {
        Intrinsics.checkNotNullParameter((Object)notificationApiUrl, (String)"notificationApiUrl");
        Intrinsics.checkNotNullParameter((Object)webClient, (String)"webClient");
        this.notificationApiUrl = notificationApiUrl;
        this.webClient = webClient;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<Notification> getNotifications(@NotNull String state, int limit, @NotNull String date, @NotNull String locale) {
        void uri$iv;
        void $this$get$iv;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        WebClient.Builder builder = this.webClient;
        URI uRI = this.notificationsUri(state, limit, date, locale);
        boolean $i$f$get = false;
        return (List)BuildersKt.runBlocking$default(null, (Function2)((Function2)new getNotifications$$inlined$get$1((WebClient.Builder)$this$get$iv, (URI)uri$iv, null)), (int)1, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<String> archiveAllNotifications() {
        void $this$put$iv;
        WebClient.Builder builder = this.webClient;
        URI uri$iv = this.archiveAllNotificationsUri();
        boolean $i$f$put = false;
        return (List)BuildersKt.runBlocking$default(null, (Function2)((Function2)new /* Unavailable Anonymous Inner Class!! */), (int)1, null);
    }

    /*
     * WARNING - void declaration
     */
    public void archiveNotification(@NotNull String notificationId) {
        void $this$put$iv;
        Intrinsics.checkNotNullParameter((Object)notificationId, (String)"notificationId");
        WebClient.Builder builder = this.webClient;
        URI uri$iv = this.archiveNotificationUri(notificationId);
        boolean $i$f$put = false;
        BuildersKt.runBlocking$default(null, (Function2)((Function2)new /* Unavailable Anonymous Inner Class!! */), (int)1, null);
    }

    /*
     * WARNING - void declaration
     */
    public void openNotifications(@NotNull List<String> notificationIds) {
        void $this$put$iv;
        Intrinsics.checkNotNullParameter(notificationIds, (String)"notificationIds");
        WebClient.Builder builder = this.webClient;
        URI uri$iv = this.openNotificationsUri();
        boolean $i$f$put = false;
        BuildersKt.runBlocking$default(null, (Function2)((Function2)new /* Unavailable Anonymous Inner Class!! */), (int)1, null);
    }

    /*
     * WARNING - void declaration
     */
    public void markNotification(@NotNull String notificationId, @NotNull String action) {
        void uri$iv;
        void $this$put$iv;
        Intrinsics.checkNotNullParameter((Object)notificationId, (String)"notificationId");
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        WebClient.Builder builder = this.webClient;
        URI uRI = this.markNotificationUri(notificationId, action);
        boolean $i$f$put = false;
        BuildersKt.runBlocking$default(null, (Function2)((Function2)new /* Unavailable Anonymous Inner Class!! */), (int)1, null);
    }

    private URI notificationsUri(String state, int limit, String date, String locale) {
        UriComponentsBuilder uriComponentsBuilder;
        String baseUrl$iv = this.notificationApiUrl + "/notification";
        boolean $i$f$buildUri = false;
        UriComponentsBuilder uriComponentsBuilder2 = UriComponentsBuilder.fromHttpUrl((String)baseUrl$iv);
        Intrinsics.checkNotNullExpressionValue((Object)uriComponentsBuilder2, (String)"fromHttpUrl(baseUrl)");
        UriComponentsBuilder $this$notificationsUri_u24lambda_u2d0 = uriComponentsBuilder = uriComponentsBuilder2;
        boolean bl = false;
        Object[] objectArray = new Object[]{state};
        $this$notificationsUri_u24lambda_u2d0.queryParam("status", objectArray);
        objectArray = new Object[]{limit};
        $this$notificationsUri_u24lambda_u2d0.queryParam("maxElements", objectArray);
        objectArray = new Object[]{date};
        $this$notificationsUri_u24lambda_u2d0.queryParam("date", objectArray);
        objectArray = new Object[]{locale};
        $this$notificationsUri_u24lambda_u2d0.queryParam("locale", objectArray);
        URI uRI = uriComponentsBuilder.encode(StandardCharsets.UTF_8).build().toUri();
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"fromHttpUrl(baseUrl).app\u2026de(UTF_8).build().toUri()");
        return uRI;
    }

    private URI archiveAllNotificationsUri() {
        UriComponentsBuilder uriComponentsBuilder;
        String baseUrl$iv = this.notificationApiUrl + "/notification/archive";
        boolean $i$f$buildUri = false;
        UriComponentsBuilder uriComponentsBuilder2 = UriComponentsBuilder.fromHttpUrl((String)baseUrl$iv);
        Intrinsics.checkNotNullExpressionValue((Object)uriComponentsBuilder2, (String)"fromHttpUrl(baseUrl)");
        UriComponentsBuilder $this$null = uriComponentsBuilder = uriComponentsBuilder2;
        URI uRI = uriComponentsBuilder.encode(StandardCharsets.UTF_8).build().toUri();
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"fromHttpUrl(baseUrl).app\u2026de(UTF_8).build().toUri()");
        return uRI;
    }

    private URI archiveNotificationUri(String notificationId) {
        UriComponentsBuilder uriComponentsBuilder;
        String baseUrl$iv = this.notificationApiUrl + "/notification/archive/" + notificationId;
        boolean $i$f$buildUri = false;
        UriComponentsBuilder uriComponentsBuilder2 = UriComponentsBuilder.fromHttpUrl((String)baseUrl$iv);
        Intrinsics.checkNotNullExpressionValue((Object)uriComponentsBuilder2, (String)"fromHttpUrl(baseUrl)");
        UriComponentsBuilder $this$null = uriComponentsBuilder = uriComponentsBuilder2;
        URI uRI = uriComponentsBuilder.encode(StandardCharsets.UTF_8).build().toUri();
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"fromHttpUrl(baseUrl).app\u2026de(UTF_8).build().toUri()");
        return uRI;
    }

    private URI openNotificationsUri() {
        UriComponentsBuilder uriComponentsBuilder;
        String baseUrl$iv = this.notificationApiUrl + "/notification/open";
        boolean $i$f$buildUri = false;
        UriComponentsBuilder uriComponentsBuilder2 = UriComponentsBuilder.fromHttpUrl((String)baseUrl$iv);
        Intrinsics.checkNotNullExpressionValue((Object)uriComponentsBuilder2, (String)"fromHttpUrl(baseUrl)");
        UriComponentsBuilder $this$null = uriComponentsBuilder = uriComponentsBuilder2;
        URI uRI = uriComponentsBuilder.encode(StandardCharsets.UTF_8).build().toUri();
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"fromHttpUrl(baseUrl).app\u2026de(UTF_8).build().toUri()");
        return uRI;
    }

    private URI markNotificationUri(String notificationId, String action) {
        UriComponentsBuilder uriComponentsBuilder;
        String baseUrl$iv = this.notificationApiUrl + "/notification/" + notificationId + "/" + action;
        boolean $i$f$buildUri = false;
        UriComponentsBuilder uriComponentsBuilder2 = UriComponentsBuilder.fromHttpUrl((String)baseUrl$iv);
        Intrinsics.checkNotNullExpressionValue((Object)uriComponentsBuilder2, (String)"fromHttpUrl(baseUrl)");
        UriComponentsBuilder $this$null = uriComponentsBuilder = uriComponentsBuilder2;
        URI uRI = uriComponentsBuilder.encode(StandardCharsets.UTF_8).build().toUri();
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"fromHttpUrl(baseUrl).app\u2026de(UTF_8).build().toUri()");
        return uRI;
    }
}

