/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.mobile.gateway.news.service;

import com.expediagroup.graphql.client.types.GraphQLClientError;
import com.expediagroup.graphql.client.types.GraphQLClientRequest;
import com.expediagroup.graphql.client.types.GraphQLClientResponse;
import de.justsoftware.mobile.gateway.exception.GraphQLException;
import de.justsoftware.mobile.gateway.generated.AddCommentMutation;
import de.justsoftware.mobile.gateway.generated.AddPostMutation;
import de.justsoftware.mobile.gateway.generated.ChannelQuery;
import de.justsoftware.mobile.gateway.generated.ChannelsQuery;
import de.justsoftware.mobile.gateway.generated.DeleteCommentMutation;
import de.justsoftware.mobile.gateway.generated.DeletePostMutation;
import de.justsoftware.mobile.gateway.generated.FeedQuery;
import de.justsoftware.mobile.gateway.generated.LikeMutation;
import de.justsoftware.mobile.gateway.generated.MarkFeedAsReadMutation;
import de.justsoftware.mobile.gateway.generated.MarkPostAsReadMutation;
import de.justsoftware.mobile.gateway.generated.PostQuery;
import de.justsoftware.mobile.gateway.generated.PostsQuery;
import de.justsoftware.mobile.gateway.generated.SubscribeChannelMutation;
import de.justsoftware.mobile.gateway.generated.UnlikeMutation;
import de.justsoftware.mobile.gateway.generated.UnsubscribeChannelMutation;
import de.justsoftware.mobile.gateway.generated.UpdateCommentMutation;
import de.justsoftware.mobile.gateway.generated.UpdatePostMutation;
import de.justsoftware.mobile.gateway.generated.VotePollMutation;
import de.justsoftware.mobile.gateway.generated.addpostmutation.Post;
import de.justsoftware.mobile.gateway.generated.channelsquery.Channel;
import de.justsoftware.mobile.gateway.generated.inputs.AddCommentInput;
import de.justsoftware.mobile.gateway.generated.inputs.AddPostInput;
import de.justsoftware.mobile.gateway.generated.inputs.AttachmentInput;
import de.justsoftware.mobile.gateway.generated.inputs.EditCommentInput;
import de.justsoftware.mobile.gateway.generated.inputs.EditPostInput;
import de.justsoftware.mobile.gateway.generated.unlikemutation.Like;
import de.justsoftware.mobile.gateway.generated.updatecommentmutation.Comment;
import de.justsoftware.mobile.gateway.generated.votepollmutation.Poll;
import de.justsoftware.mobile.gateway.news.model.AddPostData;
import de.justsoftware.mobile.gateway.news.model.CommentContent;
import de.justsoftware.mobile.gateway.news.model.UpdatePostData;
import de.justsoftware.mobile.gateway.news.service.NewsApiGatewayService;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.reactive.function.client.WebClient;

@Service
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0017\u0018\u0000 ?2\u00020\u0001:\u0001?B\u0017\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\"\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00032\b\u0010\n\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u0003H\u0016J\u0010\u0010\u0014\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\u0003H\u0016J%\u0010\u0015\u001a\u0002H\u0016\"\b\b\u0000\u0010\u0016*\u00020\u00012\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00160\u0018H\u0012\u00a2\u0006\u0002\u0010\u0019J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u000f\u001a\u00020\u0003H\u0016J\u000e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dH\u0016J&\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u001d2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\"2\u0006\u0010$\u001a\u00020%H\u0016J\u0012\u0010&\u001a\u0004\u0018\u00010'2\u0006\u0010\t\u001a\u00020\u0003H\u0016J6\u0010(\u001a\b\u0012\u0004\u0012\u00020)0\u001d2\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\"2\u0006\u0010*\u001a\u00020%2\u0006\u0010$\u001a\u00020%H\u0016J\u0010\u0010+\u001a\u00020\u00032\u0006\u0010,\u001a\u00020\u0003H\u0016J\b\u0010-\u001a\u00020\u0013H\u0016J\u0010\u0010.\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0018\u0010/\u001a\u0002002\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u00101\u001a\u00020%H\u0016J\u0012\u00102\u001a\u0004\u0018\u00010\u00032\u0006\u0010,\u001a\u00020\u0003H\u0016J\u0010\u00103\u001a\u0002042\u0006\u0010\u000f\u001a\u00020\u0003H\u0016J\u0018\u00105\u001a\u0002062\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u00107\u001a\u0002082\u0006\u0010\t\u001a\u00020\u00032\u0006\u00109\u001a\u00020:H\u0016J\u001e\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020\u00032\f\u0010>\u001a\b\u0012\u0004\u0012\u00020\u00030\u001dH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"Lde/justsoftware/mobile/gateway/news/service/NewsApiGatewayService;", "", "newsApiUrl", "", "webClient", "Lorg/springframework/web/reactive/function/client/WebClient$Builder;", "(Ljava/lang/String;Lorg/springframework/web/reactive/function/client/WebClient$Builder;)V", "addComment", "Lde/justsoftware/mobile/gateway/generated/addcommentmutation/Comment;", "postId", "commentId", "content", "Lde/justsoftware/mobile/gateway/news/model/CommentContent;", "addPost", "Lde/justsoftware/mobile/gateway/generated/addpostmutation/Post;", "channelId", "addPostData", "Lde/justsoftware/mobile/gateway/news/model/AddPostData;", "deleteComment", "", "deletePost", "execute", "T", "request", "Lcom/expediagroup/graphql/client/types/GraphQLClientRequest;", "(Lcom/expediagroup/graphql/client/types/GraphQLClientRequest;)Ljava/lang/Object;", "getChannel", "Lde/justsoftware/mobile/gateway/generated/channelquery/Channel;", "getChannels", "", "Lde/justsoftware/mobile/gateway/generated/channelsquery/Channel;", "getFeed", "Lde/justsoftware/mobile/gateway/generated/feedquery/Post;", "offset", "", "limit", "pinned", "", "getPost", "Lde/justsoftware/mobile/gateway/generated/postquery/Post;", "getPosts", "Lde/justsoftware/mobile/gateway/generated/postsquery/Post;", "scheduled", "like", "itemId", "markFeedAsRead", "markPostAsRead", "subscribe", "Lde/justsoftware/mobile/gateway/generated/subscribechannelmutation/Channel;", "notificationsEnabled", "unlike", "unsubscribe", "Lde/justsoftware/mobile/gateway/generated/unsubscribechannelmutation/Channel;", "updateComment", "Lde/justsoftware/mobile/gateway/generated/updatecommentmutation/Comment;", "updatePost", "Lde/justsoftware/mobile/gateway/generated/updatepostmutation/Post;", "updatePostData", "Lde/justsoftware/mobile/gateway/news/model/UpdatePostData;", "voteForPoll", "Lde/justsoftware/mobile/gateway/generated/votepollmutation/Poll;", "pollId", "answerIds", "Companion", "mobile-gateway"})
public class NewsApiGatewayService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String newsApiUrl;
    @NotNull
    private final WebClient.Builder webClient;
    private static final Logger LOG = LoggerFactory.getLogger(NewsApiGatewayService.class);

    public NewsApiGatewayService(@Value(value="${just.news.graphql.url}") @NotNull String newsApiUrl, @NotNull WebClient.Builder webClient) {
        Intrinsics.checkNotNullParameter((Object)newsApiUrl, (String)"newsApiUrl");
        Intrinsics.checkNotNullParameter((Object)webClient, (String)"webClient");
        this.newsApiUrl = newsApiUrl;
        this.webClient = webClient;
    }

    @NotNull
    public List<de.justsoftware.mobile.gateway.generated.feedquery.Post> getFeed(int offset, int limit, boolean pinned) {
        FeedQuery query = new FeedQuery(new FeedQuery.Variables(offset, limit, pinned));
        return ((FeedQuery.Result)this.execute((GraphQLClientRequest)query)).getPosts();
    }

    public void markFeedAsRead() {
        MarkFeedAsReadMutation query = new MarkFeedAsReadMutation();
        this.execute((GraphQLClientRequest)query);
    }

    @NotNull
    public List<Channel> getChannels() {
        ChannelsQuery query = new ChannelsQuery();
        return ((ChannelsQuery.Result)this.execute((GraphQLClientRequest)query)).getChannels();
    }

    @NotNull
    public de.justsoftware.mobile.gateway.generated.subscribechannelmutation.Channel subscribe(@NotNull String channelId, boolean notificationsEnabled) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        SubscribeChannelMutation query = new SubscribeChannelMutation(new SubscribeChannelMutation.Variables(channelId, notificationsEnabled));
        return ((SubscribeChannelMutation.Result)this.execute((GraphQLClientRequest)query)).getSubscribeChannel().getChannel();
    }

    @NotNull
    public de.justsoftware.mobile.gateway.generated.unsubscribechannelmutation.Channel unsubscribe(@NotNull String channelId) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        UnsubscribeChannelMutation query = new UnsubscribeChannelMutation(new UnsubscribeChannelMutation.Variables(channelId));
        return ((UnsubscribeChannelMutation.Result)this.execute((GraphQLClientRequest)query)).getUnsubscribeChannel();
    }

    @Nullable
    public de.justsoftware.mobile.gateway.generated.channelquery.Channel getChannel(@NotNull String channelId) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        ChannelQuery query = new ChannelQuery(new ChannelQuery.Variables(channelId));
        return ((ChannelQuery.Result)this.execute((GraphQLClientRequest)query)).getChannel();
    }

    @NotNull
    public List<de.justsoftware.mobile.gateway.generated.postsquery.Post> getPosts(@NotNull String channelId, int offset, int limit, boolean scheduled, boolean pinned) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        PostsQuery query = new PostsQuery(new PostsQuery.Variables(channelId, offset, limit, scheduled, pinned));
        return ((PostsQuery.Result)this.execute((GraphQLClientRequest)query)).getPosts();
    }

    @Nullable
    public de.justsoftware.mobile.gateway.generated.postquery.Post getPost(@NotNull String postId) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        PostQuery query = new PostQuery(new PostQuery.Variables(postId));
        return ((PostQuery.Result)this.execute((GraphQLClientRequest)query)).getPost();
    }

    @NotNull
    public Post addPost(@NotNull String channelId, @NotNull AddPostData addPostData) {
        AttachmentInput attachmentInput;
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter((Object)addPostData, (String)"addPostData");
        if (addPostData.getAttachments().isEmpty()) {
            attachmentInput = null;
        } else {
            List list = addPostData.getAttachments();
            String string = addPostData.getCoverAttachment();
            if (string == null) {
                string = (String)addPostData.getAttachments().get(0);
            }
            attachmentInput = new AttachmentInput(list, string);
        }
        AttachmentInput attachmentInput2 = attachmentInput;
        AddPostMutation query = new AddPostMutation(new AddPostMutation.Variables(new AddPostInput(channelId, addPostData.getTitle(), addPostData.getText(), addPostData.getQuillDelta(), attachmentInput2, Boolean.valueOf(false), null, null, 192, null)));
        return ((AddPostMutation.Result)this.execute((GraphQLClientRequest)query)).getAddPost();
    }

    @NotNull
    public de.justsoftware.mobile.gateway.generated.updatepostmutation.Post updatePost(@NotNull String postId, @NotNull UpdatePostData updatePostData) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        Intrinsics.checkNotNullParameter((Object)updatePostData, (String)"updatePostData");
        UpdatePostMutation query = new UpdatePostMutation(new UpdatePostMutation.Variables(new EditPostInput(postId, updatePostData.getTitle(), updatePostData.getText(), updatePostData.getQuillDelta(), new AttachmentInput(updatePostData.getAttachments(), updatePostData.getCoverAttachment()), null, null, Boolean.valueOf(updatePostData.getRemovedPoll() != null), null, null, 864, null)));
        return ((UpdatePostMutation.Result)this.execute((GraphQLClientRequest)query)).getEditPost();
    }

    public void deletePost(@NotNull String postId) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        DeletePostMutation query = new DeletePostMutation(new DeletePostMutation.Variables(postId));
        this.execute((GraphQLClientRequest)query);
    }

    @NotNull
    public String like(@NotNull String itemId) {
        Intrinsics.checkNotNullParameter((Object)itemId, (String)"itemId");
        LikeMutation query = new LikeMutation(new LikeMutation.Variables(itemId));
        return ((LikeMutation.Result)this.execute((GraphQLClientRequest)query)).getAddLike().getId();
    }

    @Nullable
    public String unlike(@NotNull String itemId) {
        Intrinsics.checkNotNullParameter((Object)itemId, (String)"itemId");
        UnlikeMutation query = new UnlikeMutation(new UnlikeMutation.Variables(itemId));
        Like like = ((UnlikeMutation.Result)this.execute((GraphQLClientRequest)query)).getRemoveLike();
        return like != null ? like.getId() : null;
    }

    @NotNull
    public Poll voteForPoll(@NotNull String pollId, @NotNull List<String> answerIds) {
        Intrinsics.checkNotNullParameter((Object)pollId, (String)"pollId");
        Intrinsics.checkNotNullParameter(answerIds, (String)"answerIds");
        VotePollMutation query = new VotePollMutation(new VotePollMutation.Variables(pollId, answerIds));
        return ((VotePollMutation.Result)this.execute((GraphQLClientRequest)query)).getVotePoll();
    }

    @NotNull
    public de.justsoftware.mobile.gateway.generated.addcommentmutation.Comment addComment(@NotNull String postId, @Nullable String commentId, @NotNull CommentContent content) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        AddCommentMutation query = new AddCommentMutation(new AddCommentMutation.Variables(new AddCommentInput(postId, commentId, content.getText(), content.getQuillDelta())));
        return ((AddCommentMutation.Result)this.execute((GraphQLClientRequest)query)).getAddComment();
    }

    @NotNull
    public Comment updateComment(@NotNull String commentId, @NotNull CommentContent content) {
        Intrinsics.checkNotNullParameter((Object)commentId, (String)"commentId");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        UpdateCommentMutation query = new UpdateCommentMutation(new UpdateCommentMutation.Variables(new EditCommentInput(commentId, content.getText(), content.getQuillDelta())));
        return ((UpdateCommentMutation.Result)this.execute((GraphQLClientRequest)query)).getEditComment();
    }

    public void deleteComment(@NotNull String commentId) {
        Intrinsics.checkNotNullParameter((Object)commentId, (String)"commentId");
        DeleteCommentMutation query = new DeleteCommentMutation(new DeleteCommentMutation.Variables(commentId));
        this.execute((GraphQLClientRequest)query);
    }

    public void markPostAsRead(@NotNull String postId) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        MarkPostAsReadMutation query = new MarkPostAsReadMutation(new MarkPostAsReadMutation.Variables(postId));
        this.execute((GraphQLClientRequest)query);
    }

    private <T> T execute(GraphQLClientRequest<T> request) {
        GraphQLClientResponse result2 = (GraphQLClientResponse)BuildersKt.runBlocking$default(null, (Function2)((Function2)new /* Unavailable Anonymous Inner Class!! */), (int)1, null);
        List errors = result2.getErrors();
        Collection collection = errors;
        if (!(collection == null || collection.isEmpty())) {
            Iterable $this$forEach$iv = errors;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                GraphQLClientError it = (GraphQLClientError)element$iv;
                boolean bl = false;
                LOG.error("Error while executing GraphQL-Query " + request.getOperationName() + ": " + it.getMessage());
            }
            throw new GraphQLException("Error(s) occurred executing GraphQL-Query. See server log for details.");
        }
        Object object = result2.getData();
        if (object == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        return (T)object;
    }

    public static final /* synthetic */ String access$getNewsApiUrl$p(NewsApiGatewayService $this) {
        return $this.newsApiUrl;
    }

    public static final /* synthetic */ WebClient.Builder access$getWebClient$p(NewsApiGatewayService $this) {
        return $this.webClient;
    }
}

