/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.justimport.transaction.impl;

import de.justsoftware.justimport.transaction.TransactionSupport;
import de.justsoftware.justimport.transaction.impl.FlushMapper;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.support.TransactionOperations;

@Service
@ParametersAreNonnullByDefault
public class TransactionSupportImpl
implements TransactionSupport {
    private final TransactionOperations _transactionOperations;
    private final FlushMapper _flushMapper;

    @Autowired
    public TransactionSupportImpl(TransactionOperations transactionOperations, FlushMapper flushMapper) {
        this._transactionOperations = transactionOperations;
        this._flushMapper = flushMapper;
    }

    public <T> T doInTransaction(Supplier<T> callback) {
        return (T)this._transactionOperations.execute(status -> callback.get());
    }

    public void doInTransaction(Runnable action) {
        this._transactionOperations.execute(status -> {
            action.run();
            return null;
        });
    }

    public void flushBatchStatements() {
        this._flushMapper.flush();
    }
}

