/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.justimport.domain.impl.externalid;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.justimport.domain.externalid.ExternalIdMappingRepository;
import de.justsoftware.justimport.domain.impl.externalid.ExternalIdMappingMapper;
import de.justsoftware.justimport.domain.model.common.TenantId;
import de.justsoftware.justimport.domain.model.externalid.ExternalId;
import de.justsoftware.justimport.domain.model.externalid.ExternalIdMapping;
import de.justsoftware.justimport.domain.model.externalid.ExternalSystemId;
import de.justsoftware.justimport.domain.model.externalid.InternalId;
import de.justsoftware.toolbox.mybatis.DAOSupport;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@ParametersAreNonnullByDefault
@Repository
public class ExternalIdMappingRepositoryImpl
implements ExternalIdMappingRepository {
    private final ExternalIdMappingMapper _mapper;
    private final DAOSupport _daoSupport;

    @Autowired
    public ExternalIdMappingRepositoryImpl(ExternalIdMappingMapper mapper, DAOSupport daoSupport) {
        this._mapper = mapper;
        this._daoSupport = daoSupport;
    }

    public void store(List<ExternalIdMapping> mappings) {
        mappings.forEach(arg_0 -> ((ExternalIdMappingMapper)this._mapper).insert(arg_0));
        mappings.forEach(arg_0 -> ((ExternalIdMappingMapper)this._mapper).update(arg_0));
    }

    public void delete(TenantId tenantId, ExternalSystemId systemId, Set<? extends InternalId> toDelete) {
        if (!toDelete.isEmpty()) {
            this._mapper.delete(tenantId, systemId, toDelete);
        }
    }

    public void deleteAllForInternalIds(Set<? extends InternalId> toDelete) {
        if (!toDelete.isEmpty()) {
            this._mapper.deleteAllForInternalIds(toDelete);
        }
    }

    public Optional<ExternalIdMapping> getByExternalId(TenantId tenantId, ExternalSystemId systemId, ExternalId externalId) {
        return Optional.ofNullable((ExternalIdMapping)this.getByExternalId(tenantId, systemId, (Set)ImmutableSet.of((Object)externalId)).get((Object)externalId));
    }

    public ImmutableMap<ExternalId, ExternalIdMapping> getByExternalId(TenantId tenantId, ExternalSystemId systemId, Set<ExternalId> externalIds) {
        return (ImmutableMap)this._daoSupport.partition(externalIds).index(ExternalIdMapping::getExternalId).asMap().query((resultHandler, ids) -> this._mapper.getByExternalId(resultHandler, tenantId, systemId, ids));
    }
}

