/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.justimport.domain;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.ldap.LdapName;
import org.springframework.ldap.core.LdapTemplate;
import org.springframework.ldap.core.support.BaseLdapPathSource;
import org.springframework.ldap.support.LdapUtils;

@ParametersAreNonnullByDefault
public final class JustLdapUtils {
    @Nonnull
    public static LdapName determineLdapBase(LdapTemplate ldapTemplate) {
        if (ldapTemplate.getContextSource() instanceof BaseLdapPathSource) {
            return ((BaseLdapPathSource)ldapTemplate.getContextSource()).getBaseLdapName();
        }
        return LdapUtils.emptyLdapName();
    }

    @Nonnull
    public static Name normalizeDn(Name dn, Name base) throws InvalidNameException {
        return dn.startsWith(base) ? dn : dn.addAll(0, base);
    }
}

