/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.justimport.business.usergroup.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.google.common.annotations.VisibleForTesting;
import de.justsoftware.justimport.business.usergroup.UserGroupImportPublisher;
import de.justsoftware.justimport.domain.model.common.TenantId;
import de.justsoftware.justimport.domain.model.profile.ProfileId;
import de.justsoftware.justimport.domain.model.usergroup.UserGroupId;
import de.justsoftware.toolbox.kafka.client.KafkaCleaningProducer;
import de.justsoftware.toolbox.kafka.client.KafkaCleaningProducerState;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class UserGroupImportKafkaProducer
implements UserGroupImportPublisher {
    protected static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    @VisibleForTesting
    static final String TOPIC = "just.people.import.userGroup";
    @VisibleForTesting
    static final String MEMBER_TOPIC = "just.people.import.userGroupMembers";
    private static final Logger LOG = LoggerFactory.getLogger(UserGroupImportKafkaProducer.class);
    private static final ObjectNode EMPTY_JSON_OBJECT = OBJECT_MAPPER.createObjectNode();
    private final KafkaCleaningProducer<String, String> _kafkaProducer;

    public UserGroupImportKafkaProducer(@Nullable KafkaCleaningProducer<String, String> kafkaProducer) {
        this._kafkaProducer = kafkaProducer;
    }

    private void logErrorCallback(RecordMetadata metadata, @Nullable Exception exception) {
        if (exception != null) {
            LOG.error("Could not publish group data to topic " + metadata.topic(), (Throwable)exception);
        }
    }

    public boolean publishImportedUserGroup(TenantId tenantId, UserGroupId userGroupId, String usergroupName) {
        if (this._kafkaProducer == null) {
            return false;
        }
        try {
            ObjectNode groupValue = OBJECT_MAPPER.createObjectNode();
            groupValue.set("name", (JsonNode)TextNode.valueOf((String)usergroupName));
            groupValue.set("tenantId", (JsonNode)TextNode.valueOf((String)tenantId.asString()));
            this._kafkaProducer.send(new ProducerRecord(TOPIC, (Object)userGroupId.asString(), (Object)OBJECT_MAPPER.writeValueAsString((Object)groupValue)), (arg_0, arg_1) -> this.logErrorCallback(arg_0, arg_1));
            return true;
        }
        catch (JsonProcessingException e) {
            LOG.error("Failed to create record for user group", (Throwable)e);
            return false;
        }
    }

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"}, justification="https://github.com/spotbugs/spotbugs/issues/756")
    public void publishAllUserGroupMembers(UserGroupId userGroupId, Set<ProfileId> members, Consumer<Boolean> publishResult) {
        if (this._kafkaProducer == null) {
            return;
        }
        try (KafkaCleaningProducerState state = this._kafkaProducer.beginRefill(new String[]{MEMBER_TOPIC});){
            members.forEach(member -> this.publishImportedUserGroupMember(userGroupId, member, publishResult));
            state.finishRefill(key -> key.endsWith("@" + userGroupId.asString()));
        }
    }

    private void publishImportedUserGroupMember(UserGroupId userGroupId, ProfileId member, Consumer<Boolean> publishResult) {
        if (this._kafkaProducer == null) {
            return;
        }
        try {
            this._kafkaProducer.send(new ProducerRecord(MEMBER_TOPIC, (Object)(member.asString() + "@" + userGroupId.asString()), (Object)OBJECT_MAPPER.writeValueAsString((Object)EMPTY_JSON_OBJECT)), (arg_0, arg_1) -> this.logErrorCallback(arg_0, arg_1));
            publishResult.accept(Boolean.TRUE);
        }
        catch (JsonProcessingException e) {
            LOG.error("Failed to create record for user group membership (usergroup: " + userGroupId + ", member: " + member + ")", (Throwable)e);
            publishResult.accept(Boolean.FALSE);
        }
    }
}

