/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.justimport.business.usergroup.impl;

import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import de.justsoftware.justimport.business.usergroup.UserGroupImportDataProvider;
import de.justsoftware.justimport.domain.model.common.ExternalIdField;
import de.justsoftware.justimport.domain.model.externalid.ExternalId;
import de.justsoftware.justimport.domain.model.usergroup.UserGroupImportModel;
import de.justsoftware.justimport.domain.profile.ldap.LdapProfile;
import de.justsoftware.justimport.domain.profile.ldap.LdapProfileRepository;
import de.justsoftware.justimport.domain.usergroup.ldap.LdapUserGroup;
import de.justsoftware.justimport.domain.usergroup.ldap.LdapUserGroupRepository;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.ldap.query.LdapQuery;
import org.springframework.ldap.query.LdapQueryBuilder;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class LdapUserGroupImportDataProvider
implements UserGroupImportDataProvider {
    private static final Logger LOG = LoggerFactory.getLogger(LdapUserGroupImportDataProvider.class);
    private final LdapUserGroupRepository _userGroupRepository;
    private final LdapProfileRepository _profileRepository;
    @CheckForNull
    private final String _filter;
    private final String _externalIdAttribute;
    @CheckForNull
    private final String _searchBaseDn;
    private final Function<LdapUserGroup, Optional<String>> _externalIdSupplier;

    @Autowired
    LdapUserGroupImportDataProvider(LdapUserGroupRepository userGroupRepository, LdapProfileRepository profileRepository, @Nullable @Value(value="${just.import.usergroup.ldap.filter}") String filter, @Value(value="${just.import.usergroup.externalId}") String externalIdAttribute, @Nullable @Value(value="${just.import.usergroup.ldap.searchBaseDn:}") String searchBaseDn, @Value(value="${just.import.usergroup.externalIdIsGUID}") boolean externalIdIsGUID) {
        this._userGroupRepository = userGroupRepository;
        this._profileRepository = profileRepository;
        this._filter = filter;
        this._externalIdAttribute = externalIdAttribute;
        this._externalIdSupplier = LdapUserGroup.externalIdAccessor((ExternalIdField)new ExternalIdField(externalIdAttribute, externalIdIsGUID));
        this._searchBaseDn = searchBaseDn;
    }

    public Stream<UserGroupImportModel> getImportModels() {
        if (Strings.isNullOrEmpty((String)this._filter) && Strings.isNullOrEmpty((String)this._searchBaseDn)) {
            return this.toImportModelStream((Iterable)this._userGroupRepository.findAll());
        }
        LdapQueryBuilder queryBuilder = LdapQueryBuilder.query();
        if (!Strings.isNullOrEmpty((String)this._searchBaseDn)) {
            queryBuilder.base(this._searchBaseDn);
        }
        if (Strings.isNullOrEmpty((String)this._filter)) {
            throw new IllegalArgumentException("You must always use searchBaseDn and filter together! No filter defined.");
        }
        LdapQuery ldapQuery = queryBuilder.filter(this._filter);
        Iterable groups = this._userGroupRepository.findAll(ldapQuery);
        return this.toImportModelStream(groups);
    }

    @Nonnull
    private Stream<UserGroupImportModel> toImportModelStream(Iterable<LdapUserGroup> ldapUserUserGroups) {
        return Streams.stream(ldapUserUserGroups).map(arg_0 -> this.resolveImportModel(arg_0)).filter(Objects::nonNull);
    }

    @CheckForNull
    private UserGroupImportModel resolveImportModel(LdapUserGroup ldapGroup) {
        Optional externalId = (Optional)this._externalIdSupplier.apply(ldapGroup);
        return externalId.map(it -> {
            try {
                Set allMembers = this._userGroupRepository.getAllMembers(ldapGroup.getDn());
                return new UserGroupImportModel(it, (String)MoreObjects.firstNonNull((Object)ldapGroup.getDescription(), (Object)ldapGroup.getName()), (Set)this.resolveMembers(allMembers));
            }
            catch (InvalidNameException e) {
                LOG.error("Group name or base are invalid.", (Throwable)e);
                return null;
            }
        }).orElseGet(() -> {
            LOG.warn("Failed to extract external id of imported ldap group {}. Skipping import.", (Object)ldapGroup.getDn());
            return null;
        });
    }

    @Nonnull
    private ImmutableSet<ExternalId> resolveMembers(Set<Name> members) {
        return (ImmutableSet)this._profileRepository.findAllById(members, this._externalIdAttribute).stream().map(LdapProfile::getExternalId).collect(ImmutableSet.toImmutableSet());
    }
}

