/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.justimport.business.profile.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import de.justsoftware.justimport.business.profile.impl.KafkaPersonExternalId;
import de.justsoftware.justimport.domain.externalid.ExternalIdMappingRepository;
import de.justsoftware.justimport.domain.model.common.ItemType;
import de.justsoftware.justimport.domain.model.common.TenantId;
import de.justsoftware.justimport.domain.model.externalid.ExternalId;
import de.justsoftware.justimport.domain.model.externalid.ExternalIdMapping;
import de.justsoftware.justimport.domain.model.externalid.ExternalSystemId;
import de.justsoftware.justimport.domain.model.externalid.InternalId;
import de.justsoftware.justimport.domain.model.profile.ProfileId;
import de.justsoftware.justimport.kafka.AbstractKafkaConsumer;
import de.justsoftware.justimport.kafka.KafkaConfigurationProvider;
import de.justsoftware.justimport.transaction.TransactionSupport;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@ParametersAreNonnullByDefault
@Service
public class ProfileExternalIdKafkaConsumer
extends AbstractKafkaConsumer<String, String> {
    @VisibleForTesting
    static final String TOPIC = "just.persons.externalId";
    private final ExternalIdMappingRepository _externalIdMappingRepository;
    private final ExternalSystemId _externalSystemId;

    @Autowired
    public ProfileExternalIdKafkaConsumer(KafkaConfigurationProvider kafkaConfigurationProvider, TransactionSupport transactionSupport, ExternalIdMappingRepository externalIdMappingRepository, @Value(value="${just.import.externalSystemId}") String externalSystemId) {
        this(kafkaConfigurationProvider.stringConsumer("just.import.profile.exernalIdConsumer"), kafkaConfigurationProvider, transactionSupport, externalIdMappingRepository, new ExternalSystemId(externalSystemId));
    }

    @VisibleForTesting
    ProfileExternalIdKafkaConsumer(@Nullable Consumer<String, String> consumer, KafkaConfigurationProvider kafkaConfigurationProvider, TransactionSupport transactionSupport, ExternalIdMappingRepository externalIdMappingRepository, ExternalSystemId externalSystemId) {
        super(consumer, kafkaConfigurationProvider, transactionSupport, TOPIC);
        this._externalSystemId = externalSystemId;
        this._externalIdMappingRepository = externalIdMappingRepository;
    }

    protected void process(ConsumerRecords<String, String> records) {
        HashSet mappingsToDelete = new HashSet();
        HashMap externalIdMapping = new HashMap();
        records.forEach(record -> this.consumeRecord(record, mappingsToDelete, externalIdMapping));
        this._externalIdMappingRepository.deleteAllForInternalIds(mappingsToDelete);
        this._externalIdMappingRepository.store((List)externalIdMapping.values().stream().filter(Objects::nonNull).collect(ImmutableList.toImmutableList()));
    }

    private void consumeRecord(ConsumerRecord<String, String> record, HashSet<ProfileId> mappingsToDelete, HashMap<ProfileId, ExternalIdMapping> externalIdMappings) {
        try {
            String key = (String)record.key();
            if (key == null || key.isEmpty()) {
                return;
            }
            ProfileId profileId = new ProfileId(key);
            String value = (String)record.value();
            if (value == null) {
                mappingsToDelete.add(profileId);
                externalIdMappings.remove(profileId);
                return;
            }
            KafkaPersonExternalId externalId = (KafkaPersonExternalId)OBJECT_MAPPER.readValue(value, KafkaPersonExternalId.class);
            String tenantId = externalId.getTenantId();
            if (tenantId == null) {
                this.getLog().warn("Skipping record for profile {} without tenant id - maybe old one", (Object)profileId.asString());
                return;
            }
            externalIdMappings.put(profileId, new ExternalIdMapping(TenantId.parse((String)tenantId), this._externalSystemId, (InternalId)profileId, new ExternalId(externalId.getExternalId(), externalId.getDomain(), ItemType.PROFILE)));
            mappingsToDelete.remove(profileId);
        }
        catch (IOException | RuntimeException e) {
            this.getLog().error("Failed to parse record: " + record, (Throwable)e);
        }
    }
}

