/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.gateway.security;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.time.Duration;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.oauth2.core.OAuth2AuthenticatedPrincipal;
import org.springframework.security.oauth2.server.resource.InvalidBearerTokenException;
import org.springframework.security.oauth2.server.resource.introspection.NimbusOpaqueTokenIntrospector;
import org.springframework.security.oauth2.server.resource.introspection.OAuth2IntrospectionException;
import org.springframework.security.oauth2.server.resource.introspection.OpaqueTokenIntrospector;
import org.springframework.security.oauth2.server.resource.introspection.ReactiveOpaqueTokenIntrospector;
import org.springframework.stereotype.Service;
import org.springframework.web.client.HttpClientErrorException;
import reactor.core.publisher.Mono;

@ParametersAreNonnullByDefault
@Service
public class ToroOpaqueTokenIntrospector
implements ReactiveOpaqueTokenIntrospector {
    private final LoadingCache<String, OAuth2AuthenticatedPrincipal> _tokenCache;

    public ToroOpaqueTokenIntrospector(@Value(value="${just.login.oauth2.resource.client_id}") String clientId, @Value(value="${just.login.oauth2.resource.client_secret}") String clientSecret, @Value(value="${just.login.oauth2.resource.check_token_endpoint}") String checkTokenEndpoint, @Value(value="${just.login.oauth2.resource.accessTokenCache.maxSize:1000}") int maxAccessTokenCacheSize) {
        NimbusOpaqueTokenIntrospector introspector = new NimbusOpaqueTokenIntrospector(checkTokenEndpoint, clientId, clientSecret);
        this._tokenCache = Caffeine.newBuilder().expireAfterWrite(Duration.ofMinutes(1L)).refreshAfterWrite(Duration.ofSeconds(10L)).maximumSize((long)maxAccessTokenCacheSize).recordStats().build(arg_0 -> ((OpaqueTokenIntrospector)introspector).introspect(arg_0));
    }

    public Mono<OAuth2AuthenticatedPrincipal> introspect(String token) {
        try {
            return Mono.justOrEmpty((Object)((OAuth2AuthenticatedPrincipal)this._tokenCache.get((Object)token)));
        }
        catch (OAuth2IntrospectionException e) {
            HttpClientErrorException serverError;
            Throwable cause = e.getCause();
            if (cause instanceof HttpClientErrorException && (serverError = (HttpClientErrorException)cause).getStatusCode().is4xxClientError()) {
                throw new InvalidBearerTokenException(e.getMessage(), (Throwable)e);
            }
            throw e;
        }
    }
}

