/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.gateway.security;

import de.justsoftware.gateway.security.AuthenticationToJwtStringConverter;
import de.justsoftware.gateway.security.JustAuthToken;
import de.justsoftware.gateway.security.JustAuthenticationManager;
import java.time.Duration;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.http.ResponseCookie;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.server.WebFilterExchange;
import org.springframework.security.web.server.authentication.ServerAuthenticationSuccessHandler;
import org.springframework.stereotype.Service;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@ParametersAreNonnullByDefault
public class LoginCookieHandler
implements ServerAuthenticationSuccessHandler {
    public static final String JUST_ID = "just-id";
    public static final Duration EXPIRE_NOW = Duration.ofSeconds(-1L);
    private final JustAuthenticationManager _manager;
    private final AuthenticationToJwtStringConverter _converter;

    public LoginCookieHandler(JustAuthenticationManager manager, AuthenticationToJwtStringConverter converter) {
        this._manager = manager;
        this._converter = converter;
    }

    public Mono<Void> onAuthenticationSuccess(WebFilterExchange webFilterExchange, Authentication originalAuthentication) {
        Mono convertedAuthentation = this._manager.authenticate(originalAuthentication);
        return convertedAuthentation.filter(auth -> auth instanceof JustAuthToken).cast(JustAuthToken.class).map(arg_0 -> ((AuthenticationToJwtStringConverter)this._converter).convert(arg_0)).filter(Objects::nonNull).flatMap(jwt -> {
            ServerWebExchange exchange = webFilterExchange.getExchange();
            ServerHttpResponse response = exchange.getResponse();
            response.addCookie(LoginCookieHandler.createJustIdCookie((String)jwt, (Duration)EXPIRE_NOW));
            exchange.mutate().response(response);
            return Mono.empty();
        });
    }

    @Nonnull
    private static ResponseCookie createJustIdCookie(String jwt, Duration maxAge) {
        return ResponseCookie.from((String)"just-id", (String)jwt).httpOnly(true).sameSite("Lax").path("/").secure(true).maxAge(maxAge).build();
    }

    @Nonnull
    public static ServerWebExchange removeJustIdCookie(ServerWebExchange exchange) {
        ServerHttpResponse response = exchange.getResponse();
        response.addCookie(LoginCookieHandler.createJustIdCookie((String)"", (Duration)Duration.ZERO));
        return exchange.mutate().response(response).build();
    }
}

