/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.gateway.security;

import de.justsoftware.gateway.ids.ProfileId;
import de.justsoftware.gateway.kafka.JustPersonDto;
import de.justsoftware.toolbox.ObjectUtil;
import java.util.HashMap;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.kafka.annotation.PartitionOffset;
import org.springframework.kafka.annotation.TopicPartition;
import org.springframework.messaging.handler.annotation.Header;
import org.springframework.messaging.handler.annotation.Payload;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class EmailToProfileMapper {
    private static final String JUST_PERSONS_TOPIC = "just.persons";
    private final HashMap<String, ProfileId> _emailToProfileIdMap = new HashMap();

    @KafkaListener(topics={"just.persons"}, containerFactory="justPersonsContainerFactory", topicPartitions={@TopicPartition(topic="just.persons", partitions={"0"}, partitionOffsets={@PartitionOffset(partition="*", initialOffset="0")})})
    public void listenForJustPersons(@Header(value="kafka_receivedMessageKey") ProfileId internalId, @Payload(required=false) @Nullable JustPersonDto personDto) {
        this.removeMapping(internalId);
        if (personDto != null && personDto.isActive() && personDto.getEmail() != null) {
            ProfileId currentMapping = this.findByEmail((String)ObjectUtil.checkNotNull((Object)personDto.getEmail()));
            if (currentMapping != null) {
                this.removeMapping(currentMapping);
            }
            this.addMapping((String)ObjectUtil.checkNotNull((Object)personDto.getEmail()), personDto.getProfileId());
        }
    }

    private void addMapping(String email, ProfileId profileId) {
        this._emailToProfileIdMap.put(email, profileId);
    }

    private void removeMapping(ProfileId profileId) {
        this._emailToProfileIdMap.values().removeAll(Set.of(profileId));
    }

    @CheckForNull
    public ProfileId findByEmail(String email) {
        return (ProfileId)this._emailToProfileIdMap.get(email);
    }
}

