/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.rest.controllers;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.SetMultimap;
import com.google.common.io.ByteSource;
import com.google.common.net.MediaType;
import de.justsoftware.drive.business.authorization.AuthorizationContext;
import de.justsoftware.drive.business.authorization.AuthorizationContextProvider;
import de.justsoftware.drive.business.authorization.PersonAuthorizationContext;
import de.justsoftware.drive.business.document.DocumentTreeModificationService;
import de.justsoftware.drive.business.document.DocumentVersionCountService;
import de.justsoftware.drive.business.exception.PermissionDeniedException;
import de.justsoftware.drive.business.file.FileService;
import de.justsoftware.drive.business.sync.FileSyncService;
import de.justsoftware.drive.business.sync.OpenDocumentTokenContent;
import de.justsoftware.drive.common.authorization.model.StaticAction;
import de.justsoftware.drive.common.document.model.DocumentId;
import de.justsoftware.drive.common.document.model.DocumentVersionId;
import de.justsoftware.drive.common.document.model.PublishedFilter;
import de.justsoftware.drive.common.file.model.FileVersionBO;
import de.justsoftware.drive.common.model.AbstractId;
import de.justsoftware.drive.common.person.model.PersonId;
import de.justsoftware.drive.rest.document.DocumentFrontendService;
import de.justsoftware.drive.rest.exceptions.DocumentVersionConflictException;
import de.justsoftware.drive.rest.exceptions.UnknownResourceException;
import de.justsoftware.drive.rest.file.FileLockFrontendService;
import de.justsoftware.drive.rest.models.FileLock;
import de.justsoftware.drive.rest.models.FileVersionUploadInfo;
import de.justsoftware.drive.rest.util.MultipartUtil;
import de.justsoftware.toolbox.http.ContentDispositionUtil;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sync"}, produces={"application/json"})
@Schema(description="JUST FILESYNC")
@ParametersAreNonnullByDefault
public class FileSyncController {
    private static final String REQUESTED_FILE_WAS_NOT_FOUND = "Requested file was not found";
    private static final String INVALID_JWT_TOKEN_MSG = "Failed to parse or validate the provided JWT token. ";
    private static final Logger LOG = LoggerFactory.getLogger(FileSyncController.class);
    private final FileSyncService _fileSyncService;
    private final AuthorizationContextProvider _authorizationContextProvider;
    private final FileService _fileService;
    private final DocumentTreeModificationService _documentTreeModificationService;
    private final FileItemFactory _fileItemFactory;
    private final DocumentFrontendService _documentFrontendService;
    private final FileLockFrontendService _fileLockFrontendService;
    private final DocumentVersionCountService _documentVersionCountService;

    @Autowired
    public FileSyncController(FileSyncService fileSyncService, AuthorizationContextProvider authorizationContextProvider, FileService fileService, DocumentTreeModificationService documentTreeModificationService, FileItemFactory fileItemFactory, DocumentFrontendService documentFrontendService, FileLockFrontendService fileLockFrontendService, DocumentVersionCountService documentVersionCountService) {
        this._fileSyncService = fileSyncService;
        this._authorizationContextProvider = authorizationContextProvider;
        this._fileService = fileService;
        this._documentTreeModificationService = documentTreeModificationService;
        this._fileItemFactory = fileItemFactory;
        this._documentFrontendService = documentFrontendService;
        this._fileLockFrontendService = fileLockFrontendService;
        this._documentVersionCountService = documentVersionCountService;
    }

    @Operation(description="Returns the binary content of the requested file version for download.")
    @RequestMapping(value={"fileversion/{jwtToken:.+}/download"}, method={RequestMethod.GET})
    public void downloadFileVersion(HttpServletResponse response, @PathVariable String jwtToken) {
        OpenDocumentTokenContent parsedToken = this._fileSyncService.validateAndParseJWT(jwtToken);
        if (parsedToken == null) {
            response.setStatus(HttpStatus.FORBIDDEN.value());
            return;
        }
        DocumentVersionId fileVersionId = parsedToken.getVersionId();
        this._fileSyncService.markFileSyncUsage(parsedToken.getPersonId(), fileVersionId);
        PersonAuthorizationContext authCtx = this._authorizationContextProvider.forPerson(parsedToken.getPersonId());
        PublishedFilter publishedFilter = this._documentFrontendService.checkRead((AuthorizationContext)authCtx, fileVersionId);
        FileVersionBO fileVersion = this._fileService.getSingleVersionById(fileVersionId);
        if (fileVersion == null) {
            throw new UnknownResourceException(REQUESTED_FILE_WAS_NOT_FOUND);
        }
        if (!fileVersion.isPublic() && publishedFilter != PublishedFilter.PUBLISHED_OR_PRIVATE) {
            throw new PermissionDeniedException("not allowed");
        }
        ByteSource fileSource = this._fileService.getFileByteSource(fileVersion);
        try {
            response.setContentType(fileVersion.getMimeType());
            response.setContentLengthLong(fileVersion.getFileSize());
            ContentDispositionUtil.setContentDispositionAttachment((arg_0, arg_1) -> ((HttpServletResponse)response).setHeader(arg_0, arg_1), (String)fileVersion.getName());
            fileSource.copyTo((OutputStream)response.getOutputStream());
            this._documentVersionCountService.increment((Set)ImmutableSet.of((Object)fileVersionId));
        }
        catch (IOException e) {
            LOG.warn("Could not send file to just-filesync", (Throwable)e);
            throw new UnknownResourceException(REQUESTED_FILE_WAS_NOT_FOUND);
        }
    }

    @Operation(description="Upload a new file version. Returns the URI of the newly created version.")
    @RequestMapping(value={"fileversion/{jwtToken:.+}/upload"}, method={RequestMethod.PUT})
    @CheckForNull
    public String uploadFileVersion(HttpServletResponse response, @PathVariable String jwtToken, HttpServletRequest request) {
        OpenDocumentTokenContent parsedToken = this._fileSyncService.validateAndParseJWT(jwtToken);
        if (parsedToken == null) {
            response.setStatus(HttpStatus.FORBIDDEN.value());
            return null;
        }
        PersonId personId = parsedToken.getPersonId();
        PersonAuthorizationContext authCtx = this._authorizationContextProvider.forPerson(personId);
        FileVersionBO versionToUpdate = this._fileService.getSingleVersionById(parsedToken.getVersionId());
        if (versionToUpdate == null) {
            throw new UnknownResourceException(REQUESTED_FILE_WAS_NOT_FOUND);
        }
        DocumentId fileId = versionToUpdate.getDocumentId();
        authCtx.check((AbstractId)fileId, StaticAction.DOCUMENT_WRITE);
        this.assertIsNewestVersion(versionToUpdate.getId(), fileId);
        FileItem fileItem = this._fileItemFactory.createItem("file", this.getMimeType(versionToUpdate), false, versionToUpdate.getName());
        try {
            IOUtils.copy((InputStream)request.getInputStream(), (OutputStream)fileItem.getOutputStream());
            FileVersionBO newFileVersion = this._documentTreeModificationService.uploadNewFileVersion(fileId, MultipartUtil.fileItemToByteSource((FileItem)fileItem), personId, null);
            return this._fileSyncService.getOpenDocumentUri(newFileVersion.getId(), personId);
        }
        catch (IOException e) {
            LOG.error("Failed to upload new file version", (Throwable)e);
            response.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
            return null;
        }
    }

    @CheckForNull
    private String getMimeType(FileVersionBO versionToUpdate) {
        return MediaType.OCTET_STREAM.is(MediaType.parse((String)versionToUpdate.getMimeType())) ? null : versionToUpdate.getMimeType();
    }

    @Operation(description="Retrieve information about file access, used to provide available actions to the user before uploading a new file version")
    @RequestMapping(value={"fileversion/{jwtToken:.+}/accessInfo"}, method={RequestMethod.GET})
    @Nonnull
    public FileVersionUploadInfo getFileAccessInfo(@PathVariable String jwtToken) {
        OpenDocumentTokenContent parsedToken = this._fileSyncService.validateAndParseJWT(jwtToken);
        if (parsedToken == null) {
            throw new PermissionDeniedException(INVALID_JWT_TOKEN_MSG);
        }
        PersonId personId = parsedToken.getPersonId();
        FileVersionBO version = this._fileService.getSingleVersionById(parsedToken.getVersionId());
        if (version == null) {
            throw new UnknownResourceException(REQUESTED_FILE_WAS_NOT_FOUND);
        }
        DocumentId fileId = version.getDocumentId();
        this.assertIsNewestVersion(parsedToken.getVersionId(), fileId);
        ImmutableSet allowedActions = this._authorizationContextProvider.forPerson(personId).may((SetMultimap)ImmutableSetMultimap.of((Object)fileId, (Object)StaticAction.DOCUMENT_WRITE, (Object)fileId, (Object)StaticAction.DOCUMENT_READ)).get((Object)fileId);
        FileLock fileLock = (FileLock)this._fileLockFrontendService.getFileLocks((Set)ImmutableSet.of((Object)fileId)).get((Object)fileId);
        return new FileVersionUploadInfo(allowedActions, fileLock, fileLock != null && fileLock.getOwner().getId().equals((Object)personId));
    }

    private void assertIsNewestVersion(DocumentVersionId versionToUpdate, DocumentId fileId) {
        FileVersionBO latestFileVersion = this._fileService.getLastFileVersion(fileId, PublishedFilter.PUBLISHED_OR_PRIVATE);
        if (latestFileVersion != null && !latestFileVersion.getId().equals((Object)versionToUpdate)) {
            throw new DocumentVersionConflictException(String.format("Failed to update file version with id %s because a newer file version with id %s exists already", versionToUpdate, latestFileVersion.getId()));
        }
    }
}

