/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.rest.controllers;

import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.drive.business.authorization.AuthorizationContext;
import de.justsoftware.drive.business.authorization.PersonAuthorizationContext;
import de.justsoftware.drive.business.change.ChangeModificationService;
import de.justsoftware.drive.business.folder.CurrentVersionData;
import de.justsoftware.drive.business.folder.FolderService;
import de.justsoftware.drive.business.search.DocumentSearchResultBO;
import de.justsoftware.drive.business.search.DocumentSearchResultEntryBO;
import de.justsoftware.drive.business.search.DocumentSearchService;
import de.justsoftware.drive.business.search.DriveSearchParameters;
import de.justsoftware.drive.business.search.DriveSearchParamsBuilder;
import de.justsoftware.drive.business.search.SearchAuthorizationContext;
import de.justsoftware.drive.business.search.SearchSortParams;
import de.justsoftware.drive.common.document.model.DocumentId;
import de.justsoftware.drive.common.document.model.DocumentListEntryId;
import de.justsoftware.drive.common.document.model.DocumentVersionId;
import de.justsoftware.drive.common.document.model.MicroblogEntryId;
import de.justsoftware.drive.common.document.model.PublishedFilter;
import de.justsoftware.drive.common.folder.model.FolderVersionBO;
import de.justsoftware.drive.common.item.model.ItemId;
import de.justsoftware.drive.common.item.model.ItemType;
import de.justsoftware.drive.common.model.AbstractId;
import de.justsoftware.drive.common.model.SortDirection;
import de.justsoftware.drive.rest.document.DocumentFrontendService;
import de.justsoftware.drive.rest.models.DocumentList;
import de.justsoftware.drive.rest.models.DocumentPath;
import de.justsoftware.drive.rest.models.Folder;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/documents/search"}, produces={"application/json"})
@Schema(description="Documents Search")
@ParametersAreNonnullByDefault
public class DocumentSearchController {
    static final String API_MAPPING = "/api/documents/search";
    private final DocumentSearchService _documentSearchService;
    private final DocumentFrontendService _documentFrontendService;
    private final FolderService _folderService;
    private final ChangeModificationService _changeModificationService;

    @Autowired
    public DocumentSearchController(DocumentSearchService documentSearchService, DocumentFrontendService documentFrontendService, FolderService folderService, ChangeModificationService changeModificationService) {
        this._documentSearchService = documentSearchService;
        this._documentFrontendService = documentFrontendService;
        this._folderService = folderService;
        this._changeModificationService = changeModificationService;
    }

    @Operation(description="Search in drive documents")
    @RequestMapping(method={RequestMethod.GET})
    @Nonnull
    public DocumentList search(PersonAuthorizationContext authCtx, @Parameter(description="limit the search to contents and subfolder of the given folder") @RequestParam(value="folderId", required=false) @Nullable DocumentId folderId, @Parameter(description="text to search for") @RequestParam(value="query", required=false) @Nullable String query, @Parameter(description="return only documents which are located below a parent of the provided item type") @RequestParam(value="parentItemType", required=false) @Nullable ItemType parentItemType, @RequestParam(value="grandmaItemId", required=false) @Nullable ItemId grandmaItemId, @RequestParam(value="sortField", defaultValue="RELEVANCE") SearchSortParams.SearchSortField sortField, @RequestParam(value="direction", defaultValue="DESC") SortDirection direction, @RequestParam(value="offset", defaultValue="0") int offset, @RequestParam(value="limit", defaultValue="20") int limit) {
        DriveSearchParamsBuilder params = DriveSearchParameters.builder();
        if (!Strings.isNullOrEmpty((String)query)) {
            params.searchText(query);
        }
        PublishedFilter publishedFilter = folderId != null ? this._documentFrontendService.checkRead((AuthorizationContext)authCtx, (AbstractId)folderId) : (grandmaItemId != null ? this._documentFrontendService.checkRead((AuthorizationContext)authCtx, (AbstractId)grandmaItemId) : PublishedFilter.ONLY_PUBLISHED);
        if (folderId != null) {
            params.searchInFolder(folderId);
        }
        if (parentItemType != null) {
            params.parentItemType(parentItemType);
        }
        if (grandmaItemId != null) {
            params.grandmaItemId(grandmaItemId);
        }
        DocumentSearchResultBO documentSearchResultBO = this._documentSearchService.search((SearchAuthorizationContext)authCtx, params.sort(sortField, direction).paging(offset, limit).build());
        FluentIterable versions = FluentIterable.from((Iterable)documentSearchResultBO.getResultEntries()).transform(DocumentSearchResultEntryBO.TO_DOCUMENT_VERSION_BO);
        DocumentFrontendService.CreateDocumentVisitor creator = this._documentFrontendService.documentCreator((Iterable)versions, (AuthorizationContext)authCtx, publishedFilter);
        DocumentPath path = this.getPath(authCtx, folderId, grandmaItemId, publishedFilter, creator);
        return new DocumentList(path, (List)versions.transform((Function)creator).toList(), documentSearchResultBO.getNumberOfResults());
    }

    @CheckForNull
    private DocumentPath getPath(PersonAuthorizationContext authCtx, @Nullable DocumentId folderId, @Nullable ItemId grandmaItemId, PublishedFilter publishedFilter, DocumentFrontendService.CreateDocumentVisitor creator) {
        Folder folder;
        DocumentVersionId newestChange;
        FolderVersionBO folderVersionBO;
        if (folderId != null) {
            CurrentVersionData versionData = (CurrentVersionData)this._folderService.getCurrentVersionDataOfDocuments((Set)ImmutableSet.of((Object)folderId), publishedFilter).get((Object)folderId);
            if (versionData == null) {
                return null;
            }
            ImmutableMap pathBOs = this._folderService.getFolderVersionsByIds((Set)versionData.getPath());
            FluentIterable documentPath = FluentIterable.from((Iterable)versionData.getPath()).transform(arg_0 -> ((ImmutableMap)pathBOs).get(arg_0)).filter(Objects::nonNull);
            return new DocumentPath((List)documentPath.transform(creator.toFolder()).toList(), this._documentFrontendService.getItem(versionData.getNewestChange().getItemId(), (AuthorizationContext)authCtx));
        }
        if (grandmaItemId != null && (folderVersionBO = (FolderVersionBO)this._folderService.getFolderVersionsByIds((Set)ImmutableSet.of((Object)(newestChange = this._changeModificationService.getOrCreateNewestChange(grandmaItemId, authCtx.getPersonId(), publishedFilter, null).getId()))).get((Object)newestChange)) != null && (folder = (Folder)creator.toFolder().apply((Object)folderVersionBO)) != null) {
            ImmutableList folderPath = ImmutableList.of((Object)folder);
            return new DocumentPath((List)folderPath, this._documentFrontendService.getItem(grandmaItemId, (AuthorizationContext)authCtx), (DocumentListEntryId)new MicroblogEntryId(grandmaItemId));
        }
        return null;
    }
}

