/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.rest.controllers;

import com.google.common.collect.ImmutableSet;
import de.justsoftware.drive.business.authorization.AuthorizationContext;
import de.justsoftware.drive.business.authorization.PersonAuthorizationContext;
import de.justsoftware.drive.business.common.FeatureToggleProvider;
import de.justsoftware.drive.business.common.ZookeeperConfigurationService;
import de.justsoftware.drive.business.person.PersonConfigService;
import de.justsoftware.drive.business.usergroup.UserGroupService;
import de.justsoftware.drive.common.document.model.DocumentListSortParams;
import de.justsoftware.drive.common.person.model.PersonConfigBO;
import de.justsoftware.drive.common.person.model.PersonId;
import de.justsoftware.drive.common.tenant.model.TenantId;
import de.justsoftware.drive.common.usergroup.model.UserGroupId;
import de.justsoftware.drive.rest.models.DocumentListSortParamsUpdate;
import de.justsoftware.drive.rest.models.StartupConfig;
import de.justsoftware.permission.client.model.CoreApp;
import de.justsoftware.permission.client.model.Role;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.UUID;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"}, produces={"application/json"})
@Schema(description="Configuration")
@ParametersAreNonnullByDefault
public class ConfigController {
    private final FeatureToggleProvider _featureToggleProvider;
    private final String _fileSyncDownloadPageURL;
    private final ImmutableSet<String> _newFileTypes;
    private final UserGroupService _userGroupService;
    private final ZookeeperConfigurationService _zookeeperConfigurationService;
    private final PersonConfigService _personConfigService;

    @Autowired
    public ConfigController(FeatureToggleProvider featureToggleProvider, @Value(value="${just.drive.fileSync.downloadPageURL}") String fileSyncDownloadPageURL, @Value(value="#{'${just.drive.newfiles.extensions}'}") String[] newFileTypes, ZookeeperConfigurationService zookeeperConfigurationService, UserGroupService userGroupService, PersonConfigService personConfigService) {
        this._featureToggleProvider = featureToggleProvider;
        this._fileSyncDownloadPageURL = fileSyncDownloadPageURL;
        this._zookeeperConfigurationService = zookeeperConfigurationService;
        this._newFileTypes = ImmutableSet.copyOf((Object[])newFileTypes);
        this._userGroupService = userGroupService;
        this._personConfigService = personConfigService;
    }

    @RequestMapping(value={"/config"}, method={RequestMethod.GET})
    @Operation(description="Retrieves the config needed at startup for the requesting user.")
    @Nonnull
    public StartupConfig startupConfig(PersonAuthorizationContext authCtx) {
        PersonId personId = authCtx.getPersonId();
        TenantId tenantId = authCtx.getTenantId();
        UserGroupId allUsersGroupId = this.getAllUsersGroupId((AuthorizationContext)authCtx, tenantId);
        DocumentListSortParams documentListSortParams = this._personConfigService.getPersonConfig(personId).getDocumentListSortParams();
        return new StartupConfig(this._featureToggleProvider.isPublicLinksEnabled(), personId, this._fileSyncDownloadPageURL, this._newFileTypes, this.mayCreateShares(authCtx), this._zookeeperConfigurationService.getUploadMaxFileSize().toBytes(), allUsersGroupId, documentListSortParams);
    }

    private boolean mayCreateShares(PersonAuthorizationContext authCtx) {
        TenantId tenantId = authCtx.getTenantId();
        if (tenantId == null) {
            return false;
        }
        return authCtx.may(Role.writeApp((CoreApp)CoreApp.DRIVE, (UUID)((UUID)tenantId.getId())));
    }

    @CheckForNull
    private UserGroupId getAllUsersGroupId(AuthorizationContext authCtx, @Nullable TenantId tenantId) {
        if (tenantId == null) {
            return null;
        }
        UserGroupId allUsersGroupId = this._userGroupService.getAllUsersGroupId(tenantId);
        if (allUsersGroupId == null) {
            return null;
        }
        boolean maySeeAllUsersGroup = authCtx.may(Role.read((String)allUsersGroupId.asPermissionRole().asString()));
        if (!maySeeAllUsersGroup) {
            return null;
        }
        return allUsersGroupId;
    }

    @PostMapping(value={"/config/setDocumentListSortOrder"})
    public void setDocumentListSortOrder(PersonAuthorizationContext context, @RequestBody DocumentListSortParamsUpdate params) {
        PersonId personId = context.getPersonId();
        PersonConfigBO personConfig = this._personConfigService.getPersonConfig(personId);
        personConfig.setDocumentListSortParams(params.toDocumentListSortParams());
        this._personConfigService.savePersonConfig(personId, personConfig);
    }
}

