/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.rest.config;

import de.justsoftware.drive.business.common.ZookeeperConfigurationService;
import de.justsoftware.drive.rest.config.UpdatableMultipartConfigElement;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.servlet.MultipartConfigElement;
import org.springframework.boot.autoconfigure.web.servlet.MultipartProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={MultipartProperties.class})
@ParametersAreNonnullByDefault
public class MultipartConfiguration {
    private final MultipartProperties _multipartProperties;
    private final ZookeeperConfigurationService _zookeeperConfigurationService;

    public MultipartConfiguration(MultipartProperties multipartProperties, ZookeeperConfigurationService zookeeperConfigurationService) {
        this._multipartProperties = multipartProperties;
        this._zookeeperConfigurationService = zookeeperConfigurationService;
    }

    @Bean
    @Nonnull
    public MultipartConfigElement multipartConfigElement() {
        MultipartConfigElement multipartConfigElement = this._multipartProperties.createMultipartConfig();
        UpdatableMultipartConfigElement updatableConfigElement = new UpdatableMultipartConfigElement(multipartConfigElement.getLocation(), this._zookeeperConfigurationService.getUploadMaxFileSize(), multipartConfigElement.getFileSizeThreshold());
        this._zookeeperConfigurationService.addUploadMaxFileSizeChangeListener(arg_0 -> ((UpdatableMultipartConfigElement)updatableConfigElement).setMaxFileSize(arg_0));
        return updatableConfigElement;
    }
}

