/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.rest.config;

import de.justsoftware.jwtfilter.JwtAuthenticationProcessingFilter;
import de.justsoftware.jwtfilter.keys.KeyMaterialProvider;
import de.justsoftware.jwtfilter.keys.PublicKeyCache;
import de.justsoftware.jwtfilter.verifier.JwtVerifier;
import de.justsoftware.jwtfilter.verifier.JwtVerifiers;
import java.util.Base64;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
@ParametersAreNonnullByDefault
public class JwtConfig {
    private static final String ENVIRONMENT_KEY_FOR_JWT_PUBLIC_KEY = "jwt.publicKey";
    private static final String ENVIRONMENT_KEY_FOR_JWT_PRIVATE_KEY = "jwt.privateKey";
    private final PublicKeyCache _keyCache;

    @Autowired
    public JwtConfig(Environment environment) {
        KeyMaterialProvider privKeyProvider = () -> Optional.ofNullable(environment.getProperty(ENVIRONMENT_KEY_FOR_JWT_PRIVATE_KEY)).map(JwtConfig::base64Decode);
        KeyMaterialProvider pubKeyProvider = () -> Optional.ofNullable(environment.getProperty(ENVIRONMENT_KEY_FOR_JWT_PUBLIC_KEY)).map(JwtConfig::base64Decode);
        this._keyCache = new PublicKeyCache(privKeyProvider, pubKeyProvider);
    }

    @Nonnull
    private static byte[] base64Decode(String base64Key) {
        return Base64.getDecoder().decode(base64Key);
    }

    @Bean
    @Nonnull
    public JwtAuthenticationProcessingFilter jwtAuthenticationProcessingFilter(JwtVerifier jwtVerifier) {
        return new JwtAuthenticationProcessingFilter(jwtVerifier);
    }

    @Bean
    @Nonnull
    public JwtVerifier jwtVerifier() {
        return JwtVerifiers.createEncryptedTokenVerifier((PublicKeyCache)this._keyCache);
    }
}

