/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.rest.config;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.oauth2.core.DefaultOAuth2AuthenticatedPrincipal;
import org.springframework.security.oauth2.core.OAuth2AuthenticatedPrincipal;
import org.springframework.security.oauth2.server.resource.introspection.NimbusOpaqueTokenIntrospector;
import org.springframework.security.oauth2.server.resource.introspection.OAuth2IntrospectionException;
import org.springframework.security.oauth2.server.resource.introspection.OpaqueTokenIntrospector;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class JustOpaqueTokenIntrospector
implements OpaqueTokenIntrospector {
    private static final Duration FIVE_SECONDS = Duration.ofSeconds(5L);
    private static final String PROFILE_ID_KEY = "profileId";
    private final OpaqueTokenIntrospector _delegate;
    private final LoadingCache<String, OAuth2AuthenticatedPrincipal> _tokenCache;

    public JustOpaqueTokenIntrospector(@Value(value="${just.drive.oauth2.resource.client_id}") String clientId, @Value(value="${just.drive.oauth2.resource.client_secret}") String clientSecret, @Value(value="${just.drive.oauth2.resource.check_token_endpoint}") String checkTokenEndpoint, @Value(value="${just.drive.oauth2.resource.accessTokenCache.maxSize:1000}") int maxAccessTokenCacheSize) {
        this._delegate = new NimbusOpaqueTokenIntrospector(checkTokenEndpoint, clientId, clientSecret);
        this._tokenCache = Caffeine.newBuilder().expireAfterWrite(Duration.ofMinutes(1L)).refreshAfterWrite(FIVE_SECONDS).maximumSize((long)maxAccessTokenCacheSize).recordStats().build(arg_0 -> this.uncachedIntrospect(arg_0));
    }

    public OAuth2AuthenticatedPrincipal introspect(String token) {
        return (OAuth2AuthenticatedPrincipal)this._tokenCache.get((Object)token);
    }

    @Nonnull
    private OAuth2AuthenticatedPrincipal uncachedIntrospect(String token) {
        OAuth2AuthenticatedPrincipal principal = this._delegate.introspect(token);
        String profileId = (String)principal.getAttribute(PROFILE_ID_KEY);
        if (profileId == null) {
            throw new OAuth2IntrospectionException("missing profileId in token response");
        }
        return new DefaultOAuth2AuthenticatedPrincipal(profileId, principal.getAttributes(), this.extractAuthorities(principal));
    }

    @Nonnull
    private Collection<GrantedAuthority> extractAuthorities(OAuth2AuthenticatedPrincipal principal) {
        List scopes = (List)principal.getAttribute("scope");
        if (scopes == null) {
            return List.of();
        }
        return scopes.stream().map(scope -> "SCOPE_" + scope).map(SimpleGrantedAuthority::new).collect(Collectors.toUnmodifiableList());
    }
}

