/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.persistence.sharesubscription;

import com.google.common.collect.ImmutableSet;
import de.justsoftware.drive.common.item.model.ItemId;
import de.justsoftware.drive.common.person.model.PersonId;
import de.justsoftware.drive.persistence.sharesubscription.ShareSubscriptionDAO;
import de.justsoftware.drive.persistence.sharesubscription.ShareSubscriptionMapper;
import de.justsoftware.toolbox.mybatis.DAOSupport;
import java.util.Collection;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class ShareSubscriptionDAOImpl
implements ShareSubscriptionDAO {
    private final ShareSubscriptionMapper _mapper;
    private final DAOSupport _daoSupport;

    @Autowired
    public ShareSubscriptionDAOImpl(ShareSubscriptionMapper mapper, DAOSupport daoSupport) {
        this._mapper = mapper;
        this._daoSupport = daoSupport;
    }

    public ImmutableSet<ItemId> subscriptions(PersonId personId) {
        return ImmutableSet.copyOf((Collection)this._mapper.getSubscriptions(personId));
    }

    public ItemId subscription(PersonId personId, ItemId shareId) {
        return this._mapper.getSubscription(personId, shareId);
    }

    public void subscribe(ItemId shareId, PersonId personId) {
        this._mapper.subscribe(shareId, personId);
    }

    public void unsubscribe(ItemId shareId, Set<PersonId> personIds) {
        this._daoSupport.partition(personIds).noResult(persons -> this._mapper.unsubscribe(shareId, persons));
    }

    public void unsubscribePersonFromShares(Set<ItemId> shareIds, PersonId personId) {
        this._daoSupport.partition(shareIds).noResult(shares -> this._mapper.unsubscribePersonFromShares(shares, personId));
    }

    public void unsubscribeAll(ItemId shareId) {
        this._mapper.unsubscribeAll(shareId);
    }

    public void unsubscribeAll(PersonId personId) {
        this._mapper.unsubscribeAllForUser(personId);
    }
}

