/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.persistence.search;

import de.justsoftware.drive.common.document.model.DocumentId;
import de.justsoftware.drive.common.item.model.ItemId;
import de.justsoftware.drive.common.person.model.PersonId;
import de.justsoftware.drive.persistence.search.SearchIndexQueueEntryCreateModel;
import de.justsoftware.drive.persistence.search.model.SearchIndexQueueEntryBO;
import de.justsoftware.drive.persistence.search.model.SearchIndexQueueEntryId;
import de.justsoftware.drive.persistence.search.model.SearchIndexType;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.ibatis.annotations.Arg;
import org.apache.ibatis.annotations.ConstructorArgs;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.ResultType;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.Update;
import org.apache.ibatis.session.RowBounds;
import org.joda.time.DateTime;

@ParametersAreNonnullByDefault
@Mapper
public interface SearchIndexQueueMapper {
    @Insert(value={"INSERT INTO search_index_queue(document_id, index_type)", "VALUES ( #{_documentId}, #{_indexType})"})
    public void insertEntry(SearchIndexQueueEntryCreateModel var1);

    @Nonnull
    @Select(value={"SELECT * FROM search_index_queue", "WHERE in_progress_time IS NULL OR in_progress_time < #{beforeTimestamp}", "ORDER BY id ASC FOR UPDATE"})
    @ConstructorArgs(value={@Arg(column="id", id=true, javaType=SearchIndexQueueEntryId.class), @Arg(column="document_id", javaType=DocumentId.class), @Arg(column="index_type", javaType=SearchIndexType.class)})
    @ResultType(value=SearchIndexQueueEntryBO.class)
    public List<SearchIndexQueueEntryBO> getEntries(DateTime var1, RowBounds var2);

    @Select(value={"SELECT count(*) FROM search_index_queue", "WHERE in_progress_time IS NULL OR in_progress_time < #{beforeTimestamp}"})
    public int getEntriesCount(DateTime var1);

    @Delete(value={"<script>", "DELETE from search_index_queue", "WHERE id IN (<foreach collection='ids' item='id' separator=','>#{id}</foreach>)", "</script>"})
    public void deleteEntries(@Param(value="ids") List<SearchIndexQueueEntryId> var1);

    @Insert(value={"INSERT INTO search_index_queue (document_id, index_type)", "SELECT DISTINCT document_id, #{indexType}", "FROM document_version"})
    public void insertAllDocuments(@Param(value="indexType") SearchIndexType var1);

    @Update(value={"<script>", "UPDATE search_index_queue", "SET in_progress_time=#{currentTimestamp}", "WHERE id IN (<foreach collection='ids' item='id' separator=','>#{id}</foreach>)", "</script>"})
    public void markEntriesAsInProgress(@Param(value="ids") List<SearchIndexQueueEntryId> var1, @Param(value="currentTimestamp") DateTime var2);

    @Update(value={"<script>", "UPDATE search_index_queue", "SET in_progress_time=null", "WHERE id IN (<foreach collection='ids' item='id' separator=','>#{id}</foreach>)", "</script>"})
    public void unmarkEntriesAsInProgress(@Param(value="ids") List<SearchIndexQueueEntryId> var1);

    @Insert(value={"<script>", "INSERT INTO search_index_queue (document_id, index_type)", "SELECT DISTINCT(v.document_id), #{indexType}", "FROM document_version v", "JOIN change c ON c.folder_version_id = v.change_id", "WHERE c.item_id IN (<foreach collection='items' item='i' separator=','>#{i}</foreach>)", "</script>"})
    public void insertAllDocumentsOfItems(@Param(value="items") List<ItemId> var1, @Param(value="indexType") SearchIndexType var2);

    @Insert(value={"<script>", "INSERT INTO search_index_queue (document_id, index_type)", "SELECT DISTINCT(v.document_id),  #{indexType}", "FROM document_version v ", "JOIN change c ON c.folder_version_id = v.change_id ", "JOIN item i on i.id=c.item_id ", "WHERE i.parent_item IN (<foreach collection='items' item='i' separator=','>#{i}</foreach>)", "</script>"})
    public void insertAllDocumentsOfItemParents(@Param(value="items") List<ItemId> var1, @Param(value="indexType") SearchIndexType var2);

    @Insert(value={"<script>", "INSERT INTO search_index_queue (document_id, index_type)", "SELECT DISTINCT(d.id), #{indexType}", "FROM document d", "JOIN document_version v ON d.last_version_id = v.id", "WHERE v.owner IN (<foreach collection='persons' item='i' separator=','>#{i}</foreach>)", "</script>"})
    public void insertAllDocumentsOfOwner(@Param(value="persons") List<PersonId> var1, @Param(value="indexType") SearchIndexType var2);
}

