/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.persistence.publiclinks;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.drive.common.document.model.DocumentId;
import de.justsoftware.drive.common.person.model.PersonId;
import de.justsoftware.drive.common.publiclinks.model.PublicLinkBO;
import de.justsoftware.drive.persistence.publiclinks.IDGenerator;
import de.justsoftware.drive.persistence.publiclinks.PublicLinkDAO;
import de.justsoftware.drive.persistence.publiclinks.PublicLinkMapper;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collection;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class PublicLinkDAOImpl
implements PublicLinkDAO {
    private static final Logger LOGGER = LoggerFactory.getLogger(PublicLinkDAOImpl.class);
    private static final int MAX_INSERTION_ATTEMPTS = 10;
    private final PublicLinkMapper _mapper;
    private final IDGenerator _idGenerator;

    @Autowired
    public PublicLinkDAOImpl(PublicLinkMapper mapper, IDGenerator idGenerator) {
        this._mapper = mapper;
        this._idGenerator = idGenerator;
    }

    public PublicLinkBO getPublicLink(String linkID) {
        return this._mapper.getPublicLink(linkID);
    }

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"}, justification="False positive when checking for ex!=null")
    public String createPublicLink(PersonId personId, DocumentId fileId, DateTime expires) {
        DuplicateKeyException ex;
        int attempts = 0;
        String linkID = null;
        do {
            ex = null;
            try {
                linkID = this._idGenerator.randomID();
                this._mapper.createPublicLink(linkID, fileId, expires, personId);
            }
            catch (DuplicateKeyException e) {
                ex = e;
                ++attempts;
            }
        } while (ex != null && attempts < 10);
        if (ex != null) {
            LOGGER.error("We could not store a new ID after trying " + attempts + " times. Giving up. This is a hint that the function used for generating random IDs is not random enough.");
            throw ex;
        }
        return linkID;
    }

    public ImmutableList<PublicLinkBO> getPublicLinks(DocumentId fileId) {
        return ImmutableList.copyOf((Collection)this._mapper.getPublicLinks(fileId));
    }

    public ImmutableSet<DocumentId> hasLinks(Set<DocumentId> documentsToCheck) {
        if (documentsToCheck.isEmpty()) {
            return ImmutableSet.of();
        }
        return ImmutableSet.copyOf((Collection)this._mapper.hasLinks(documentsToCheck));
    }

    public void deleteLink(DocumentId fileID, String linkID) {
        this._mapper.deleteLink(fileID, linkID);
    }

    public void deleteExpiredLinks() {
        this._mapper.deleteExpiredLinks();
    }

    public ImmutableList<String> getPublicLinksIncludingExpired(Set<DocumentId> documentIds) {
        return ImmutableList.copyOf((Collection)this._mapper.getPublicLinksIncludingExpired(documentIds));
    }

    public void updateLink(DocumentId fileID, String linkID, DateTime expirationDate, String password) {
        if (expirationDate != null || password != null) {
            this._mapper.updateLink(fileID, linkID, expirationDate, password);
        }
    }
}

