/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.persistence.folder;

import de.justsoftware.drive.common.document.model.DocumentId;
import de.justsoftware.drive.common.document.model.DocumentVersionId;
import de.justsoftware.drive.common.folder.model.FolderVersionBO;
import de.justsoftware.drive.common.item.model.ItemId;
import de.justsoftware.drive.common.person.model.PersonId;
import de.justsoftware.drive.persistence.folder.FolderVersionCreateModel;
import java.util.List;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.ibatis.annotations.Arg;
import org.apache.ibatis.annotations.ConstructorArgs;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Result;
import org.apache.ibatis.annotations.ResultMap;
import org.apache.ibatis.annotations.ResultType;
import org.apache.ibatis.annotations.Results;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.session.ResultHandler;
import org.joda.time.DateTime;

@ParametersAreNonnullByDefault
@Mapper
public interface FolderVersionMapper {
    public static final String FOLDER_VERSION_BO_COLS = "f.id, d.document_id, d.version, d.name, d.change_id, d.first_published_change_id, d.change_date, d.owner, c.item_id";
    public static final String FOLDER_VERSION_BO_MAP = "FolderBoMap";

    @Insert(value={"INSERT INTO folder_version(id )", "VALUES (#{_id})"})
    public void insertFolderVersion(FolderVersionCreateModel var1);

    @Select(value={"<script>", "SELECT f.id, d.document_id, d.version, d.name, d.change_id, d.first_published_change_id, d.change_date, d.owner, c.item_id", "FROM folder_version f", "JOIN document_version d ON f.id = d.id", "JOIN change c ON c.folder_version_id = d.change_id", "WHERE f.id IN (<foreach collection='ids' item='i' separator=','>#{i}</foreach>)", "</script>"})
    @ResultType(value=FolderVersionBO.class)
    @ConstructorArgs(value={@Arg(column="id", id=true, javaType=DocumentVersionId.class), @Arg(column="document_id", javaType=DocumentId.class), @Arg(column="version", javaType=int.class), @Arg(column="name", javaType=String.class), @Arg(column="change_id", javaType=DocumentVersionId.class), @Arg(column="owner", javaType=PersonId.class), @Arg(column="change_date", javaType=DateTime.class), @Arg(column="item_id", javaType=ItemId.class), @Arg(column="first_published_change_id", javaType=DocumentVersionId.class)})
    @Results(id="FolderBoMap")
    public void getFolderVersionsByIds(ResultHandler<FolderVersionBO> var1, @Param(value="ids") List<DocumentVersionId> var2);

    @Select(value={"<script>", "SELECT f.id, d.document_id, d.version, d.name, d.change_id, d.first_published_change_id, d.change_date, d.owner, c.item_id", "FROM folder_version f", "JOIN document_version d ON f.id = d.id", "JOIN change c ON c.folder_version_id = d.change_id", "WHERE d.change_id IN (<foreach collection='changeIds' item='i' separator=','>#{i}</foreach>)", "</script>"})
    @ResultType(value=FolderVersionBO.class)
    @ResultMap(value={"FolderBoMap"})
    public void getFolderVersionsByChangeIds(ResultHandler<FolderVersionBO> var1, @Param(value="changeIds") List<DocumentVersionId> var2);

    @Delete(value={"<script>", "DELETE FROM folder_version fv", "WHERE EXISTS (SELECT 1 FROM document_version dv WHERE dv.id = fv.id", "    AND dv.change_id IN (<foreach collection='ids' item='i' separator=','>#{i}</foreach>)", ")", "</script>"})
    public void deleteIntroducedByChanges(@Param(value="ids") List<DocumentVersionId> var1);

    @Delete(value={"<script>", "DELETE FROM folder_version", "WHERE id IN (<foreach collection='ids' item='i' separator=','>#{i}</foreach>)", "</script>"})
    public void deleteByIds(@Param(value="ids") List<DocumentVersionId> var1);

    @Select(value={"<script>", "SELECT f.id as document_version_id, d.document_id", "FROM folder_version f", "JOIN document_version d ON f.id = d.id", "WHERE d.document_id IN (<foreach collection='ids' item='i' separator=','>#{i}</foreach>)", "</script>"})
    @Results(value={@Result(column="document_id", property="key", javaType=DocumentId.class), @Result(column="document_version_id", property="value", javaType=DocumentVersionId.class)})
    @ResultType(value=Map.class)
    public void getVersionsByDocumentIds(ResultHandler<Map<String, Object>> var1, @Param(value="ids") List<? extends DocumentId> var2);
}

