/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.persistence.file;

import com.google.common.collect.ImmutableMap;
import de.justsoftware.drive.common.document.model.DocumentVersionId;
import de.justsoftware.drive.common.file.model.FilePreviewInfoBO;
import de.justsoftware.drive.common.file.model.PreviewId;
import de.justsoftware.drive.common.file.model.StorageId;
import de.justsoftware.drive.persistence.exception.DuplicateKeyException;
import de.justsoftware.drive.persistence.file.FileVersionPreviewCreateModel;
import de.justsoftware.drive.persistence.file.FileVersionPreviewDAO;
import de.justsoftware.drive.persistence.file.FileVersionPreviewMapper;
import de.justsoftware.toolbox.mybatis.DAOSupport;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.ibatis.session.RowBounds;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@ParametersAreNonnullByDefault
@Repository
public class FileVersionPreviewDAOImpl
implements FileVersionPreviewDAO {
    private final FileVersionPreviewMapper _previewMapper;
    private final DAOSupport _daoSupport;

    @Autowired
    public FileVersionPreviewDAOImpl(FileVersionPreviewMapper previewMapper, DAOSupport daoSupport) {
        this._previewMapper = previewMapper;
        this._daoSupport = daoSupport;
    }

    public void create(FileVersionPreviewCreateModel createModel) {
        try {
            this._previewMapper.insertFileVersionPreview(createModel);
        }
        catch (org.springframework.dao.DuplicateKeyException e) {
            throw new DuplicateKeyException((Throwable)e);
        }
    }

    public List<DocumentVersionId> getNextQueueEntries(int limit) {
        return this._previewMapper.getVersionsWithoutPreview(new RowBounds(0, limit));
    }

    public void update(FileVersionPreviewCreateModel createModel) {
        this._previewMapper.updatePreviewStatus(createModel);
    }

    public ImmutableMap<StorageId, FilePreviewInfoBO> getPreviewInfos(Set<StorageId> storageIds) {
        return (ImmutableMap)this._daoSupport.partition(storageIds).index(FilePreviewInfoBO::getId).asMap().query((arg_0, arg_1) -> ((FileVersionPreviewMapper)this._previewMapper).getInfoByStorageIds(arg_0, arg_1));
    }

    public ImmutableMap<PreviewId, FilePreviewInfoBO> getPreviewInfosByPreviewId(Set<PreviewId> previewIds) {
        return (ImmutableMap)this._daoSupport.partition(previewIds).index(FilePreviewInfoBO::getPreviewId).asMap().query((arg_0, arg_1) -> ((FileVersionPreviewMapper)this._previewMapper).getInfoByPreviewIds(arg_0, arg_1));
    }

    @Nonnull
    public ImmutableMap<DocumentVersionId, PreviewId> getPreviewIdByFileVersionId(Set<DocumentVersionId> fileVersions) {
        return this._daoSupport.partition(fileVersions).asMap((arg_0, arg_1) -> ((FileVersionPreviewMapper)this._previewMapper).getPreviewIdByFileVersionId(arg_0, arg_1));
    }

    public void deletePreviews(Set<StorageId> storageIds) {
        this._daoSupport.partition(storageIds).noResult(arg_0 -> ((FileVersionPreviewMapper)this._previewMapper).deleteByStorageId(arg_0));
    }
}

