/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.persistence.document;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import de.justsoftware.drive.common.document.model.DocumentId;
import de.justsoftware.drive.common.document.model.DocumentVersionId;
import de.justsoftware.drive.common.item.model.ItemId;
import de.justsoftware.drive.persistence.document.DocumentVersionDAO;
import de.justsoftware.drive.persistence.document.DocumentVersionMapper;
import de.justsoftware.toolbox.mybatis.DAOSupport;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
@ParametersAreNonnullByDefault
public class DocumentVersionDAOImpl
implements DocumentVersionDAO {
    private static final int ORACLE_SAVE_PARTITION_SIZE = 900;
    private final DocumentVersionMapper _documentVersionMapper;
    private final DAOSupport _daoSupport;

    @Autowired
    public DocumentVersionDAOImpl(DocumentVersionMapper documentVersionMapper, DAOSupport daoSupport) {
        this._documentVersionMapper = documentVersionMapper;
        this._daoSupport = daoSupport;
    }

    public ImmutableMap<DocumentVersionId, DocumentId> getDocumentIdsOfVersions(Set<DocumentVersionId> versionIds) {
        return this._daoSupport.partition(versionIds).asMap((arg_0, arg_1) -> ((DocumentVersionMapper)this._documentVersionMapper).getDocumentIdsByDocument(arg_0, arg_1));
    }

    public ImmutableSetMultimap<DocumentVersionId, DocumentVersionId> getNewDocumentsForChange(Set<DocumentVersionId> ids) {
        return this._daoSupport.partition(ids).asSetMultimap((arg_0, arg_1) -> ((DocumentVersionMapper)this._documentVersionMapper).getNewDocumentsForChange(arg_0, arg_1));
    }

    public ImmutableSetMultimap<DocumentVersionId, DocumentVersionId> getPublishedDocumentsForChange(Set<DocumentVersionId> changes) {
        return this._daoSupport.partition(changes).asSetMultimap((arg_0, arg_1) -> ((DocumentVersionMapper)this._documentVersionMapper).getPublishedDocumentsForChange(arg_0, arg_1));
    }

    public ImmutableMap<DocumentVersionId, DocumentVersionId> getFirstPublishedChangesForDocumentVersions(Set<DocumentVersionId> documentVersions) {
        return this._daoSupport.partition(documentVersions).asMap((arg_0, arg_1) -> ((DocumentVersionMapper)this._documentVersionMapper).getFirstPublishedChangesForDocuments(arg_0, arg_1));
    }

    public ImmutableMap<DocumentVersionId, DocumentVersionId> getFirstPublishedChangesForDocumentsVersionsRecursive(Set<DocumentVersionId> documentVersions) {
        return this._daoSupport.partition(documentVersions).asMap((arg_0, arg_1) -> ((DocumentVersionMapper)this._documentVersionMapper).getFirstPublishedChangesForDocumentsRecursive(arg_0, arg_1));
    }

    public void setFirstPublishedChange(Map<DocumentVersionId, DocumentVersionId> publishedChangesPerDocumentVersion) {
        publishedChangesPerDocumentVersion.forEach((arg_0, arg_1) -> ((DocumentVersionMapper)this._documentVersionMapper).setFirstPublishedChange(arg_0, arg_1));
    }

    public void deletePublishedChange(Set<DocumentVersionId> documents) {
        this._daoSupport.partition(documents).noResult(arg_0 -> ((DocumentVersionMapper)this._documentVersionMapper).deletePublishedChange(arg_0));
    }

    public ImmutableMap<DocumentId, ItemId> getItemIdsOfDocument(Set<DocumentId> documents) {
        return this._daoSupport.partition(documents).asMap((arg_0, arg_1) -> ((DocumentVersionMapper)this._documentVersionMapper).getItemIdsOfDocument(arg_0, arg_1));
    }

    public ImmutableMap<DocumentVersionId, ItemId> getItemIdsOfDocumentVersions(Set<DocumentVersionId> documents) {
        return this._daoSupport.partition(documents).asMap((arg_0, arg_1) -> ((DocumentVersionMapper)this._documentVersionMapper).getItemIdsOfDocumentVersions(arg_0, arg_1));
    }

    public void moveVersionsToTargetChange(Set<DocumentVersionId> versions, DocumentVersionId change) {
        this._daoSupport.partition(versions).noResult(documentVersionIds -> this._documentVersionMapper.moveVersionsToTargetChange(documentVersionIds, change));
    }

    public void moveOtherVersionsToTargetChange(Map<DocumentId, DocumentVersionId> mapping, DocumentVersionId change) {
        Iterables.partition(mapping.entrySet(), (int)900).forEach(entries -> {
            ArrayList<DocumentId> documents = new ArrayList<DocumentId>(entries.size());
            ArrayList<DocumentVersionId> latestVersions = new ArrayList<DocumentVersionId>(entries.size());
            for (Map.Entry entry : entries) {
                documents.add((DocumentId)entry.getKey());
                latestVersions.add((DocumentVersionId)entry.getValue());
            }
            this._documentVersionMapper.moveOtherVersionsToTargetChange(latestVersions, documents, change);
        });
    }

    public void deleteIntroducedByChanges(Set<DocumentVersionId> changeIds) {
        this._daoSupport.partition(changeIds).noResult(arg_0 -> ((DocumentVersionMapper)this._documentVersionMapper).deleteIntroducedByChanges(arg_0));
    }

    public ImmutableSet<DocumentId> getDocumentsByChangeIds(Set<DocumentVersionId> changeIds) {
        return this._daoSupport.partition(changeIds).asSet((arg_0, arg_1) -> ((DocumentVersionMapper)this._documentVersionMapper).getDocumentsByChangeIds(arg_0, arg_1));
    }

    public Set<DocumentVersionId> getAllDocumentsForItem(ItemId itemId) {
        return this._documentVersionMapper.getAllDocumentsForItem(itemId);
    }
}

