/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.persistence.conversationmigration;

import de.justsoftware.drive.common.item.model.ItemId;
import de.justsoftware.drive.persistence.conversationmigration.ConversationMigrationDAO;
import de.justsoftware.drive.persistence.conversationmigration.ConversationMigrationMapper;
import de.justsoftware.drive.persistence.transaction.TransactionSupport;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class ConversationMigrationDAOImpl
implements ConversationMigrationDAO {
    private final TransactionSupport _transactionSupport;
    private final ConversationMigrationMapper _mapper;

    public ConversationMigrationDAOImpl(TransactionSupport transactionSupport, ConversationMigrationMapper mapper) {
        this._transactionSupport = transactionSupport;
        this._mapper = mapper;
    }

    public void migrate(ItemId originalId, ItemId migratedId) {
        this._transactionSupport.doInTransaction(() -> {
            this._mapper.migrateChange(originalId, migratedId);
            this._mapper.migrateItem(originalId, migratedId);
            this._mapper.migrateItemReadRole(originalId, migratedId);
        });
    }
}

