/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.persistence.context;

import de.justsoftware.drive.persistence.DrivePersistenceScanMarker;
import de.justsoftware.drive.persistence.context.DrivePersistenceConfiguration;
import de.justsoftware.toolbox.mybatis.SupportedJdbcDriver;
import de.justsoftware.toolbox.mybatis.result.DAOSupportImpl;
import de.justsoftware.toolbox.mybatis.type.AbstractDriverSpecificTypeHandler;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.sql.DataSource;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.session.SqlSessionFactoryBuilder;
import org.apache.ibatis.transaction.TransactionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.mybatis.spring.annotation.MapperScan;
import org.mybatis.spring.transaction.SpringManagedTransactionFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;

@Configuration
@MapperScan(basePackageClasses={DrivePersistenceScanMarker.class}, annotationClass=Mapper.class, sqlSessionFactoryRef="sqlSessionFactory")
@ParametersAreNonnullByDefault
public class DrivePersistenceConfiguration {
    static final String SQL_SESSION_FACTORY = "sqlSessionFactory";

    @Nonnull
    @Bean
    public SupportedJdbcDriver supportedJdbcDriver(@Value(value="${spring.datasource.url}") String jdbcUrl) {
        return SupportedJdbcDriver.driverFromUrl((String)jdbcUrl);
    }

    @Nonnull
    @Bean
    public DAOSupportImpl daoSupport(SupportedJdbcDriver driver) {
        return new DAOSupportImpl(() -> driver);
    }

    @Bean(value={"sqlSessionFactory"})
    @DependsOn(value={"liquibase"})
    @Nonnull
    public SqlSessionFactoryBean sessionFactoryBean(DataSource source, SupportedJdbcDriver supportedJdbcDriver, @Value(value="${just.drive.jdbc.batchsize:100}") int batchSize) {
        AbstractDriverSpecificTypeHandler.setJdbcDriver((SupportedJdbcDriver)supportedJdbcDriver);
        SqlSessionFactoryBean sessionFactoryBean = new SqlSessionFactoryBean();
        sessionFactoryBean.setDataSource(source);
        sessionFactoryBean.setTypeHandlersPackage("de.justsoftware.drive.persistence,de.justsoftware.toolbox.mybatis.type.common");
        sessionFactoryBean.setTransactionFactory((TransactionFactory)new SpringManagedTransactionFactory());
        sessionFactoryBean.setSqlSessionFactoryBuilder((SqlSessionFactoryBuilder)new SqlSessionFactoryBuilderExtension(supportedJdbcDriver, batchSize));
        return sessionFactoryBean;
    }
}

