/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.persistence.common.typehandler;

import com.google.common.annotations.VisibleForTesting;
import de.justsoftware.drive.common.document.model.DocumentListSortParams;
import de.justsoftware.drive.common.document.model.DocumentSortField;
import de.justsoftware.drive.common.model.SortDirection;
import de.justsoftware.toolbox.mybatis.type.StringBasedTypeHandler;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.ibatis.type.MappedTypes;

@MappedTypes(value={DocumentListSortParams.class})
@ParametersAreNonnullByDefault
public class DocumentListSortTypeHandler
extends StringBasedTypeHandler<DocumentListSortParams> {
    public DocumentListSortTypeHandler() {
        super(DocumentListSortTypeHandler::fromString, DocumentListSortTypeHandler::convertToString);
    }

    @Nonnull
    @VisibleForTesting
    static DocumentListSortParams fromString(String raw) {
        String[] split = raw.split(",");
        if (split.length != 2) {
            return DocumentListSortParams.DEFAULT;
        }
        try {
            return new DocumentListSortParams(DocumentSortField.valueOf((String)split[0]), SortDirection.valueOf((String)split[1]));
        }
        catch (IllegalArgumentException e) {
            return DocumentListSortParams.DEFAULT;
        }
    }

    @Nonnull
    @VisibleForTesting
    static String convertToString(DocumentListSortParams documentListSortParams) {
        return String.join((CharSequence)",", documentListSortParams.getColumn().toString(), documentListSortParams.getDirection().toString());
    }
}

