/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.persistence.accessrequest;

import com.google.common.collect.ImmutableSet;
import de.justsoftware.drive.common.accessrequest.model.AccessRequestBO;
import de.justsoftware.drive.common.item.model.ItemId;
import de.justsoftware.drive.common.person.model.PersonId;
import de.justsoftware.drive.persistence.accessrequest.AccessRequestDAO;
import de.justsoftware.drive.persistence.accessrequest.AccessRequestMapper;
import de.justsoftware.toolbox.mybatis.DAOSupport;
import java.util.Collection;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@ParametersAreNonnullByDefault
@Repository
public class AccessRequestDAOImpl
implements AccessRequestDAO {
    private final AccessRequestMapper _accessRequestMapper;
    private final DAOSupport _daoSupport;

    @Autowired
    public AccessRequestDAOImpl(AccessRequestMapper accessRequestMapper, DAOSupport daoSupport) {
        this._accessRequestMapper = accessRequestMapper;
        this._daoSupport = daoSupport;
    }

    public ImmutableSet<AccessRequestBO> getPendingRequestsForShare(ItemId shareId) {
        return ImmutableSet.copyOf((Collection)this._accessRequestMapper.getPendingRequestsForShare(shareId));
    }

    public ImmutableSet<AccessRequestBO> getPendingRequestsForUser(PersonId userId) {
        return ImmutableSet.copyOf((Collection)this._accessRequestMapper.getPendingRequestsForUser(userId));
    }

    public void deletePendingRequestsForUser(PersonId userId) {
        this._accessRequestMapper.deletePendingRequestsForUser(userId);
    }

    public void deletePendingRequestsForShare(ItemId shareId) {
        this._accessRequestMapper.deletePendingRequestsForShare(shareId);
    }

    public void deletePendingRequestsForPermittedUsers(Set<PersonId> newlyPermittedUsers, ItemId requestedShare) {
        this._daoSupport.partition(newlyPermittedUsers).noResult(users -> this._accessRequestMapper.deletePendingRequestByUserForShare(users, requestedShare));
    }

    public void deletePendingRequestsForUsersAndShare(Set<PersonId> userIds, ItemId shareId) {
        this._daoSupport.partition(userIds).noResult(users -> this._accessRequestMapper.deletePendingRequestByUserForShare(users, shareId));
    }

    public void createNewAccessRequest(PersonId requestingUser, ItemId requestedShare) {
        this._accessRequestMapper.createNewPendingRequest(requestingUser, requestedShare);
    }
}

