/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.business.sync.impl;

import com.google.common.collect.ImmutableSet;
import de.justsoftware.drive.business.common.ZookeeperUtil;
import de.justsoftware.drive.business.person.PersonService;
import de.justsoftware.drive.business.sync.FileSyncService;
import de.justsoftware.drive.business.sync.OpenDocumentTokenContent;
import de.justsoftware.drive.common.document.model.DocumentVersionId;
import de.justsoftware.drive.common.person.model.PersonBO;
import de.justsoftware.drive.common.person.model.PersonId;
import de.justsoftware.drive.common.sync.model.FileSyncUsageBO;
import de.justsoftware.drive.persistence.sync.FileSyncDAO;
import de.justsoftware.jwtfilter.generator.JwtClaimsBuilder;
import de.justsoftware.jwtfilter.generator.JwtGenerator;
import de.justsoftware.jwtfilter.keys.JwtKeyLoadingException;
import de.justsoftware.jwtfilter.verifier.JwtVerificationConstraintBuilder;
import de.justsoftware.jwtfilter.verifier.JwtVerifier;
import de.justsoftware.toolbox.clock.Clock;
import java.util.Set;
import java.util.UUID;
import javax.annotation.CheckForNull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.cache.NodeCache;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.MalformedClaimException;
import org.jose4j.jwt.consumer.InvalidJwtException;
import org.jose4j.lang.JoseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class FileSyncServiceImpl
implements FileSyncService {
    private static final String PERSON_ID = "pId";
    private static final String VERSION_ID = "vId";
    private static final String SYSTEM_DOMAIN_PREFIX_PATH = "/just/url/systemDomainPrefix";
    private static final String FILE_SYNC_URL_SCHEME = "just-filesync://";
    private static final Logger LOG = LoggerFactory.getLogger(FileSyncServiceImpl.class);
    private static final int OPEN_LINK_LIFETIME_MIN = 1440;
    private final NodeCache _systemDomainPrefixCache;
    private final PersonService _personService;
    private final FileSyncDAO _fileSyncDAO;
    private final Clock _clock;
    private final JwtVerifier _jwtVerifier;
    private final JwtGenerator _jwtGenerator;

    @Autowired
    public FileSyncServiceImpl(CuratorFramework zookeeperClient, PersonService personService, FileSyncDAO fileSyncDAO, Clock clock, JwtVerifier signedJwtVerifier, JwtGenerator signedJwtGenerator) {
        this._personService = personService;
        this._fileSyncDAO = fileSyncDAO;
        this._clock = clock;
        this._systemDomainPrefixCache = ZookeeperUtil.createNodeCache((CuratorFramework)zookeeperClient, (String)SYSTEM_DOMAIN_PREFIX_PATH);
        this._jwtVerifier = signedJwtVerifier;
        this._jwtGenerator = signedJwtGenerator;
    }

    @CheckForNull
    private String getHostURL() {
        return ZookeeperUtil.getStringFromNodeCache((String)SYSTEM_DOMAIN_PREFIX_PATH, (NodeCache)this._systemDomainPrefixCache).orElse(null);
    }

    public String getOpenDocumentUri(DocumentVersionId versionId, PersonId personId) {
        String hostURL = this.getHostURL();
        if (hostURL == null) {
            return null;
        }
        PersonBO person = (PersonBO)this._personService.getPersonsByIds((Set)ImmutableSet.of((Object)personId)).get((Object)personId);
        if (person == null) {
            LOG.warn("Can not create just-filesync URI for unknown person {}", (Object)personId);
            return null;
        }
        JwtClaimsBuilder claimsBuilder = new JwtClaimsBuilder().withLifetime(1440L).withIssuer(hostURL).withCustomClaim(VERSION_ID, ((UUID)versionId.getId()).toString()).withCustomClaim(PERSON_ID, String.valueOf(personId.getId())).withCustomClaim("pName", person.getFullname()).withCustomClaim("pEmail", person.getEmail());
        try {
            String token = this._jwtGenerator.generateJWT(claimsBuilder);
            return FILE_SYNC_URL_SCHEME + token;
        }
        catch (JwtKeyLoadingException | JoseException e) {
            throw new IllegalStateException("Could not sign just-filesync URL", e);
        }
    }

    public OpenDocumentTokenContent validateAndParseJWT(String token) {
        String hostUrl = this.getHostURL();
        if (hostUrl == null) {
            LOG.error("Could not determine host url. Can't validate token.");
            return null;
        }
        JwtVerificationConstraintBuilder constraintBuilder = new JwtVerificationConstraintBuilder().withMaxFutureValidity(1440).withExpectedIssuer(hostUrl);
        try {
            JwtClaims claims = this._jwtVerifier.verify(constraintBuilder, token);
            PersonId personId = (PersonId)PersonId.parse((String)claims.getStringClaimValue(PERSON_ID)).orElseThrow(() -> new MalformedClaimException("Could not read PersonId from subject"));
            return new OpenDocumentTokenContent(personId, new DocumentVersionId(claims.getStringClaimValue(VERSION_ID)));
        }
        catch (JwtKeyLoadingException | MalformedClaimException | InvalidJwtException e) {
            LOG.warn("Could not validate or parse JWT token", e);
            return null;
        }
    }

    public void markFileSyncUsage(PersonId personId, DocumentVersionId versionId) {
        this._fileSyncDAO.markSyncappUsed(personId, versionId, this._clock.now());
    }

    public FileSyncUsageBO getLastFileSyncUsage(PersonId personId) {
        return this._fileSyncDAO.getLastFileSyncUsage(personId);
    }
}

