/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.business.search;

import de.justsoftware.drive.common.item.model.ItemId;
import de.justsoftware.drive.persistence.search.SearchIndexQueueDAO;
import de.justsoftware.drive.persistence.search.model.SearchIndexType;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.messaging.handler.annotation.Header;
import org.springframework.stereotype.Component;

@Component
@ParametersAreNonnullByDefault
public class ItemVisibilityChangedConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(ItemVisibilityChangedConsumer.class);
    private final SearchIndexQueueDAO _indexQueueDAO;

    public ItemVisibilityChangedConsumer(SearchIndexQueueDAO indexQueueDAO) {
        this._indexQueueDAO = indexQueueDAO;
    }

    @KafkaListener(topics={"just.item.visibilityChanged"}, containerFactory="itemIdStringConsumer", groupId="just.drive.ItemChangedConsumer")
    public void listen(@Header(value="kafka_receivedMessageKey") ItemId itemId) {
        LOG.debug(String.format("item changed - %s", itemId));
        this._indexQueueDAO.insertAllDocumentsOfItems(Set.of(itemId), SearchIndexType.METADATA);
        this._indexQueueDAO.insertAllDocumentsOfItemParents(Set.of(itemId), SearchIndexType.METADATA);
    }
}

